/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record Triangle(Vec3 vertex0, Vec3 vertex1, Vec3 vertex2, Vec3 edge1, Vec3 edge2) {
    public Triangle(Vec3 vertex0, Vec3 vertex1, Vec3 vertex2) {
        this(vertex0, vertex1, vertex2, vertex1.subtract(vertex0), vertex2.subtract(vertex0));
    }

    public boolean intersects(Vec3 rayOrigin, Vec3 rayVector) {
        return !Mth.equal((double)0.0, (double)this.computeIntersectDistance(rayOrigin, rayVector));
    }

    @Nullable
    public Vec3 clip(Vec3 rayOrigin, Vec3 rayVector) {
        double t = this.computeIntersectDistance(rayOrigin, rayVector);
        return Mth.equal((double)t, (double)0.0) ? null : rayOrigin.add(rayVector.scale(t));
    }

    private double computeIntersectDistance(Vec3 rayOrigin, Vec3 rayVector) {
        Vec3 pvec = rayVector.cross(this.edge2);
        double det = this.edge1.dot(pvec);
        if (Mth.equal((double)det, (double)0.0)) {
            return 0.0;
        }
        double invDet = 1.0 / det;
        Vec3 tvec = rayOrigin.subtract(this.vertex0);
        double u = invDet * tvec.dot(pvec);
        if (u < 0.0 || u > 1.0) {
            return 0.0;
        }
        Vec3 qvec = tvec.cross(this.edge1);
        double v = invDet * rayVector.dot(qvec);
        if (v < 0.0 || u + v > 1.0) {
            return 0.0;
        }
        return invDet * this.edge2.dot(qvec);
    }
}

