/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.rng;

import com.portingdeadmods.portingdeadlibs.utils.rng.WeightedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedList<T> {
    private final List<WeightedElement<T>> elements = new ArrayList<WeightedElement<T>>();
    private final List<Integer> prefixSums = new ArrayList<Integer>();
    private int totalWeight = 0;
    private final Random random = new Random();

    public void add(WeightedElement<? extends T> element) {
        this.elements.add(new WeightedElement<T>(element.object(), element.weight()));
        this.totalWeight += element.weight();
        this.prefixSums.add(this.totalWeight);
    }

    public void remove(WeightedElement<? extends T> element) {
        int index = this.elements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException("Element not found in list");
        }
        this.elements.remove(index);
        this.totalWeight -= element.weight();
        this.prefixSums.remove(index);
    }

    public void remove(int index) {
        if (index < 0 || index >= this.elements.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        WeightedElement<T> element = this.elements.get(index);
        this.elements.remove(index);
        this.totalWeight -= element.weight();
        this.prefixSums.remove(index);
    }

    public T next() {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("Trying to select from an empty list");
        }
        int rand = this.random.nextInt(this.totalWeight);
        int index = this.binarySearch(rand);
        return this.elements.get(index).object();
    }

    private int binarySearch(int target) {
        int low = 0;
        int high = this.prefixSums.size() - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            if (this.prefixSums.get(mid) > target) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }
}

