/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class Polygon
implements Renderable {
    private final List<Vector2f> vertices;
    private int color = -1;
    private boolean filled = true;
    private float lineWidth = 1.0f;

    public Polygon() {
        this.vertices = new ArrayList<Vector2f>();
    }

    public Polygon(List<Vector2f> vertices) {
        this.vertices = new ArrayList<Vector2f>(vertices);
    }

    public static Polygon regular(int sides, float radius) {
        ArrayList<Vector2f> verts = new ArrayList<Vector2f>();
        double angleStep = Math.PI * 2 / (double)sides;
        for (int i = 0; i < sides; ++i) {
            float x = (float)((double)radius * Math.cos((double)i * angleStep));
            float y = (float)((double)radius * Math.sin((double)i * angleStep));
            verts.add(new Vector2f(x, y));
        }
        return new Polygon(verts);
    }

    public static Polygon rectangle(float width, float height) {
        ArrayList<Vector2f> verts = new ArrayList<Vector2f>();
        verts.add(new Vector2f(-width / 2.0f, -height / 2.0f));
        verts.add(new Vector2f(width / 2.0f, -height / 2.0f));
        verts.add(new Vector2f(width / 2.0f, height / 2.0f));
        verts.add(new Vector2f(-width / 2.0f, height / 2.0f));
        return new Polygon(verts);
    }

    public Polygon addVertex(float x, float y) {
        this.vertices.add(new Vector2f(x, y));
        return this;
    }

    public Polygon rotateCW(double theta) {
        for (Vector2f vertex : this.vertices) {
            float x = vertex.x;
            float y = vertex.y;
            vertex.x = (float)((double)x * Math.cos(theta) - (double)y * Math.sin(theta));
            vertex.y = (float)((double)x * Math.sin(theta) + (double)y * Math.cos(theta));
        }
        return this;
    }

    public Polygon rotateCCW(double theta) {
        return this.rotateCW(-theta);
    }

    public Polygon translate(float dx, float dy) {
        for (Vector2f vertex : this.vertices) {
            vertex.add(dx, dy);
        }
        return this;
    }

    public Polygon translateX(float dx) {
        return this.translate(dx, 0.0f);
    }

    public Polygon translateY(float dy) {
        return this.translate(0.0f, dy);
    }

    public Polygon setColor(int color) {
        this.color = color;
        return this;
    }

    public Polygon setColor(int a, int r, int g, int b) {
        return this.setColor(FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b));
    }

    public Polygon setFilled(boolean filled) {
        this.filled = filled;
        return this;
    }

    public Polygon setLineWidth(float width) {
        this.lineWidth = width;
        return this;
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        if (this.vertices.size() < 3) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        float r = (float)FastColor.ARGB32.red((int)this.color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)this.color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)this.color) / 255.0f;
        float a = (float)FastColor.ARGB32.alpha((int)this.color) / 255.0f;
        if (a == 0.0f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        if (this.filled) {
            this.renderFilledPolygon(tesselator, matrix, x, y, r, g, b, a);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private void renderFilledPolygon(Tesselator tesselator, Matrix4f matrix, int x, int y, float r, float g, float b, float a) {
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        if (this.vertices.size() >= 3) {
            Vector2f first = this.vertices.get(0);
            for (int i = 1; i < this.vertices.size() - 1; ++i) {
                Vector2f second = this.vertices.get(i);
                Vector2f third = this.vertices.get(i + 1);
                buffer.addVertex(matrix, first.x + (float)x, first.y + (float)y, 0.0f).setColor(r, g, b, a);
                buffer.addVertex(matrix, second.x + (float)x, second.y + (float)y, 0.0f).setColor(r, g, b, a);
                buffer.addVertex(matrix, third.x + (float)x, third.y + (float)y, 0.0f).setColor(r, g, b, a);
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static class Builder {
        private final Polygon polygon = new Polygon();

        public Builder vertex(float x, float y) {
            this.polygon.addVertex(x, y);
            return this;
        }

        public Builder color(int color) {
            this.polygon.setColor(color);
            return this;
        }

        public Builder color(int a, int r, int g, int b) {
            this.polygon.setColor(a, r, g, b);
            return this;
        }

        public Builder filled(boolean filled) {
            this.polygon.setFilled(filled);
            return this;
        }

        public Builder lineWidth(float width) {
            this.polygon.setLineWidth(width);
            return this;
        }

        public Builder rotateCW(double theta) {
            this.polygon.rotateCW(theta);
            return this;
        }

        public Builder rotateCCW(double theta) {
            this.polygon.rotateCCW(theta);
            return this;
        }

        public Builder translate(float x, float y) {
            this.polygon.translate(x, y);
            return this;
        }

        public Builder translateX(float x) {
            this.polygon.translateX(x);
            return this;
        }

        public Builder translateY(float y) {
            this.polygon.translateY(y);
            return this;
        }

        public Polygon build() {
            return this.polygon;
        }
    }
}

