/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.renderers;

import com.mojang.blaze3d.platform.NativeImage;
import com.portingdeadmods.portingdeadlibs.utils.renderers.PixelManipulator;
import java.awt.Color;
import java.util.Random;
import net.minecraft.util.FastColor;

public class Effects {

    public static class Emboss
    extends PixelEffect {
        @Override
        public NativeImage apply(NativeImage input) {
            return new Convolution(ConvolutionKernel.EMBOSS).apply(input);
        }

        @Override
        public String getName() {
            return "emboss";
        }
    }

    public static class Sharpen
    extends Convolution {
        public final float strength;

        Sharpen(float strength) {
            super(new float[][]{{0.0f, -strength, 0.0f}, {-strength, 1.0f + 4.0f * strength, -strength}, {0.0f, -strength, 0.0f}});
            this.strength = strength;
        }

        @Override
        public String getName() {
            return "sharpen_" + this.strength;
        }
    }

    public static class Convolution
    extends PixelEffect {
        public final float[][] kernel;

        Convolution(float[][] kernel) {
            this.kernel = kernel;
        }

        Convolution(ConvolutionKernel kernel) {
            this.kernel = kernel.kernel;
        }

        @Override
        public NativeImage apply(NativeImage input) {
            NativeImage result = new NativeImage(input.getWidth(), input.getHeight(), false);
            for (int y = 1; y < input.getHeight() - 1; ++y) {
                for (int x = 1; x < input.getWidth() - 1; ++x) {
                    float rSum = 0.0f;
                    float gSum = 0.0f;
                    float bSum = 0.0f;
                    for (int ky = -1; ky <= 1; ++ky) {
                        for (int kx = -1; kx <= 1; ++kx) {
                            int pixel = input.getPixelRGBA(x + kx, y + ky);
                            float weight = this.kernel[ky + 1][kx + 1];
                            rSum += (float)FastColor.ARGB32.red((int)pixel) * weight;
                            gSum += (float)FastColor.ARGB32.green((int)pixel) * weight;
                            bSum += (float)FastColor.ARGB32.blue((int)pixel) * weight;
                        }
                    }
                    int a = FastColor.ARGB32.alpha((int)input.getPixelRGBA(x, y));
                    int r = Math.max(0, Math.min(255, (int)rSum));
                    int g = Math.max(0, Math.min(255, (int)gSum));
                    int b = Math.max(0, Math.min(255, (int)bSum));
                    result.setPixelRGBA(x, y, FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b));
                }
            }
            return result;
        }

        @Override
        public String getName() {
            StringBuilder name = new StringBuilder("convolution_");
            float[][] fArray = this.kernel;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                float[] row;
                for (float value : row = fArray[i]) {
                    name.append(value).append("_");
                }
            }
            return name.toString();
        }
    }

    public static enum ConvolutionKernel {
        BLUR(new float[][]{{0.11111111f, 0.11111111f, 0.11111111f}, {0.11111111f, 0.11111111f, 0.11111111f}, {0.11111111f, 0.11111111f, 0.11111111f}}),
        SHARPEN(new float[][]{{0.0f, -1.0f, 0.0f}, {-1.0f, 5.0f, -1.0f}, {0.0f, -1.0f, 0.0f}}),
        EMBOSS(new float[][]{{-2.0f, -1.0f, 0.0f}, {-1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 2.0f}});

        public final float[][] kernel;

        private ConvolutionKernel(float[][] kernel) {
            this.kernel = kernel;
        }
    }

    public static class Mirror
    extends PixelEffect {
        private final MirrorMode mode;

        Mirror(MirrorMode mode) {
            this.mode = mode;
        }

        @Override
        public NativeImage apply(NativeImage input) {
            int width = input.getWidth();
            int height = input.getHeight();
            NativeImage output = new NativeImage(width, height, false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcX = x;
                    int srcY = y;
                    switch (this.mode.ordinal()) {
                        case 0: {
                            srcX = width - 1 - x;
                            break;
                        }
                        case 1: {
                            srcY = height - 1 - y;
                            break;
                        }
                        case 2: {
                            srcX = width - 1 - x;
                            srcY = height - 1 - y;
                        }
                    }
                    output.setPixelRGBA(x, y, input.getPixelRGBA(srcX, srcY));
                }
            }
            return output;
        }

        @Override
        public String getName() {
            return "mirror_" + this.mode.name().toLowerCase();
        }

        public static enum MirrorMode {
            HORIZONTAL,
            VERTICAL,
            BOTH;

        }
    }

    public static class Blur
    extends PixelEffect {
        public final int radius;

        Blur(int radius) {
            this.radius = radius;
        }

        @Override
        public NativeImage apply(NativeImage input) {
            NativeImage result = new NativeImage(input.getWidth(), input.getHeight(), false);
            for (int y = 0; y < input.getHeight(); ++y) {
                for (int x = 0; x < input.getWidth(); ++x) {
                    int rSum = 0;
                    int gSum = 0;
                    int bSum = 0;
                    int aSum = 0;
                    int count = 0;
                    for (int dy = -this.radius; dy <= this.radius; ++dy) {
                        for (int dx = -this.radius; dx <= this.radius; ++dx) {
                            int px = Math.max(0, Math.min(input.getWidth() - 1, x + dx));
                            int py = Math.max(0, Math.min(input.getHeight() - 1, y + dy));
                            int pixel = input.getPixelRGBA(px, py);
                            aSum += FastColor.ARGB32.alpha((int)pixel);
                            rSum += FastColor.ARGB32.red((int)pixel);
                            gSum += FastColor.ARGB32.green((int)pixel);
                            bSum += FastColor.ARGB32.blue((int)pixel);
                            ++count;
                        }
                    }
                    result.setPixelRGBA(x, y, FastColor.ARGB32.color((int)(aSum / count), (int)(rSum / count), (int)(gSum / count), (int)(bSum / count)));
                }
            }
            return result;
        }

        @Override
        public String getName() {
            return "blur_" + this.radius;
        }
    }

    public static class EdgeDetect
    extends PixelEffect {
        public final int edgeColor;
        public final int threshold;

        EdgeDetect(int edgeColor, int threshold) {
            this.edgeColor = edgeColor;
            this.threshold = threshold;
        }

        private static int getLuminance(int color) {
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            return (int)(0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b);
        }

        @Override
        public NativeImage apply(NativeImage input) {
            NativeImage result = new NativeImage(input.getWidth(), input.getHeight(), false);
            for (int y = 1; y < input.getHeight() - 1; ++y) {
                for (int x = 1; x < input.getWidth() - 1; ++x) {
                    int center = EdgeDetect.getLuminance(input.getPixelRGBA(x, y));
                    int left = EdgeDetect.getLuminance(input.getPixelRGBA(x - 1, y));
                    int right = EdgeDetect.getLuminance(input.getPixelRGBA(x + 1, y));
                    int top = EdgeDetect.getLuminance(input.getPixelRGBA(x, y - 1));
                    int bottom = EdgeDetect.getLuminance(input.getPixelRGBA(x, y + 1));
                    int edgeStrength = Math.abs(center - left) + Math.abs(center - right) + Math.abs(center - top) + Math.abs(center - bottom);
                    if (edgeStrength > this.threshold) {
                        result.setPixelRGBA(x, y, this.edgeColor);
                        continue;
                    }
                    result.setPixelRGBA(x, y, input.getPixelRGBA(x, y));
                }
            }
            return result;
        }

        @Override
        public String getName() {
            return "edge_" + this.threshold;
        }
    }

    public static class Noise
    extends SimplePixelEffect {
        public final float intensity;
        public final Random random = new Random();

        Noise(float intensity) {
            this.intensity = intensity;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            float noise = (this.random.nextFloat() - 0.5f) * this.intensity;
            int a = FastColor.ARGB32.alpha((int)color);
            int r = Math.max(0, Math.min(255, (int)((float)FastColor.ARGB32.red((int)color) + noise * 255.0f)));
            int g = Math.max(0, Math.min(255, (int)((float)FastColor.ARGB32.green((int)color) + noise * 255.0f)));
            int b = Math.max(0, Math.min(255, (int)((float)FastColor.ARGB32.blue((int)color) + noise * 255.0f)));
            return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
        }

        @Override
        public String getName() {
            return "noise_" + this.intensity;
        }
    }

    public static class Pixelate
    extends SimplePixelEffect {
        public final int pixelSize;

        Pixelate(int pixelSize) {
            this.pixelSize = pixelSize;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int px = x / this.pixelSize * this.pixelSize;
            int py = y / this.pixelSize * this.pixelSize;
            return image.getPixelRGBA(Math.min(px, image.getWidth() - 1), Math.min(py, image.getHeight() - 1));
        }

        @Override
        public String getName() {
            return "pixelate_" + this.pixelSize;
        }
    }

    public static class Threshold
    extends SimplePixelEffect {
        public final int threshold;

        Threshold(int threshold) {
            this.threshold = threshold;
        }

        private static int getLuminance(int color) {
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            return (int)(0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b);
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int lum = Threshold.getLuminance(color);
            int a = FastColor.ARGB32.alpha((int)color);
            return lum > this.threshold ? FastColor.ARGB32.color((int)a, (int)255, (int)255, (int)255) : FastColor.ARGB32.color((int)a, (int)0, (int)0, (int)0);
        }

        @Override
        public String getName() {
            return "threshold_" + this.threshold;
        }
    }

    public static class Gamma
    extends SimplePixelEffect {
        public final float gamma;

        Gamma(float gamma) {
            this.gamma = gamma;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = (int)(255.0 * Math.pow((double)FastColor.ARGB32.red((int)color) / 255.0, 1.0 / (double)this.gamma));
            int g = (int)(255.0 * Math.pow((double)FastColor.ARGB32.green((int)color) / 255.0, 1.0 / (double)this.gamma));
            int b = (int)(255.0 * Math.pow((double)FastColor.ARGB32.blue((int)color) / 255.0, 1.0 / (double)this.gamma));
            return FastColor.ARGB32.color((int)a, (int)Math.max(0, Math.min(255, r)), (int)Math.max(0, Math.min(255, g)), (int)Math.max(0, Math.min(255, b)));
        }

        @Override
        public String getName() {
            return "gamma_" + this.gamma;
        }
    }

    public static class Sepia
    extends SimplePixelEffect {
        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            int tr = (int)(0.393f * (float)r + 0.769f * (float)g + 0.189f * (float)b);
            int tg = (int)(0.349f * (float)r + 0.686f * (float)g + 0.168f * (float)b);
            int tb = (int)(0.272f * (float)r + 0.534f * (float)g + 0.131f * (float)b);
            return FastColor.ARGB32.color((int)a, (int)Math.min(255, tr), (int)Math.min(255, tg), (int)Math.min(255, tb));
        }

        @Override
        public String getName() {
            return "sepia";
        }
    }

    public static class Opacity
    extends SimplePixelEffect {
        public final int opacity;

        Opacity(int opacity) {
            this.opacity = opacity;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            return FastColor.ARGB32.color((int)this.opacity, (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color));
        }

        @Override
        public String getName() {
            return "opacity_" + this.opacity;
        }
    }

    public static class Saturation
    extends SimplePixelEffect {
        public final float factor;

        Saturation(float factor) {
            this.factor = factor;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] * this.factor));
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            return FastColor.ARGB32.color((int)a, (int)(rgb >> 16 & 0xFF), (int)(rgb >> 8 & 0xFF), (int)(rgb & 0xFF));
        }

        @Override
        public String getName() {
            return "saturation_" + this.factor;
        }
    }

    public static class HueShift
    extends SimplePixelEffect {
        public final float degrees;

        HueShift(float degrees) {
            this.degrees = degrees;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            hsb[0] = (hsb[0] + this.degrees / 360.0f) % 1.0f;
            if (hsb[0] < 0.0f) {
                hsb[0] = hsb[0] + 1.0f;
            }
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            return FastColor.ARGB32.color((int)a, (int)(rgb >> 16 & 0xFF), (int)(rgb >> 8 & 0xFF), (int)(rgb & 0xFF));
        }

        @Override
        public String getName() {
            return "hue_" + this.degrees;
        }
    }

    public static class ColorFilter
    extends SimplePixelEffect {
        public final float r;
        public final float g;
        public final float b;

        ColorFilter(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int fa = FastColor.ARGB32.alpha((int)color);
            int fr = Math.min(255, (int)((float)FastColor.ARGB32.red((int)color) * this.r));
            int fg = Math.min(255, (int)((float)FastColor.ARGB32.green((int)color) * this.g));
            int fb = Math.min(255, (int)((float)FastColor.ARGB32.blue((int)color) * this.b));
            return FastColor.ARGB32.color((int)fa, (int)fr, (int)fg, (int)fb);
        }

        @Override
        public String getName() {
            return "colorfilter_" + this.r + "_" + this.g + "_" + this.b;
        }
    }

    public static class Tint
    extends SimplePixelEffect {
        public final int tintColor;
        public final float strength;

        Tint(int tintColor, float strength) {
            this.tintColor = tintColor;
            this.strength = strength;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a1 = FastColor.ARGB32.alpha((int)color);
            int r1 = FastColor.ARGB32.red((int)color);
            int g1 = FastColor.ARGB32.green((int)color);
            int b1 = FastColor.ARGB32.blue((int)color);
            int a2 = FastColor.ARGB32.alpha((int)this.tintColor);
            int r2 = FastColor.ARGB32.red((int)this.tintColor);
            int g2 = FastColor.ARGB32.green((int)this.tintColor);
            int b2 = FastColor.ARGB32.blue((int)this.tintColor);
            int a = (int)((float)a1 * (1.0f - this.strength) + (float)a2 * this.strength);
            int r = (int)((float)r1 * (1.0f - this.strength) + (float)r2 * this.strength);
            int g = (int)((float)g1 * (1.0f - this.strength) + (float)g2 * this.strength);
            int b = (int)((float)b1 * (1.0f - this.strength) + (float)b2 * this.strength);
            return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
        }

        @Override
        public String getName() {
            return "tint_" + Integer.toHexString(this.tintColor);
        }
    }

    public static class Contrast
    extends SimplePixelEffect {
        public final float factor;

        Contrast(float factor) {
            this.factor = factor;
        }

        private static int adjustChannelContrast(int value, float contrast) {
            float normalized = (float)value / 255.0f;
            float adjusted = (normalized - 0.5f) * contrast + 0.5f;
            return Math.max(0, Math.min(255, (int)(adjusted * 255.0f)));
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = Contrast.adjustChannelContrast(FastColor.ARGB32.red((int)color), this.factor);
            int g = Contrast.adjustChannelContrast(FastColor.ARGB32.green((int)color), this.factor);
            int b = Contrast.adjustChannelContrast(FastColor.ARGB32.blue((int)color), this.factor);
            return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
        }

        @Override
        public String getName() {
            return "contrast_" + this.factor;
        }
    }

    public static class Brightness
    extends SimplePixelEffect {
        public final float factor;

        Brightness(float factor) {
            this.factor = factor;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = Math.min(255, (int)((float)FastColor.ARGB32.red((int)color) * this.factor));
            int g = Math.min(255, (int)((float)FastColor.ARGB32.green((int)color) * this.factor));
            int b = Math.min(255, (int)((float)FastColor.ARGB32.blue((int)color) * this.factor));
            return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
        }

        @Override
        public String getName() {
            return "brightness_" + this.factor;
        }
    }

    public static class Invert
    extends SimplePixelEffect {
        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = 255 - FastColor.ARGB32.red((int)color);
            int g = 255 - FastColor.ARGB32.green((int)color);
            int b = 255 - FastColor.ARGB32.blue((int)color);
            return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
        }

        @Override
        public String getName() {
            return "invert";
        }
    }

    public static class Grayscale
    extends SimplePixelEffect {
        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            int a = FastColor.ARGB32.alpha((int)color);
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            int gray = (int)(0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b);
            return FastColor.ARGB32.color((int)a, (int)gray, (int)gray, (int)gray);
        }

        @Override
        public String getName() {
            return "grayscale";
        }
    }

    public static class NamedEffect
    extends CustomEffect {
        private final String name;

        NamedEffect(String name, PixelManipulator manipulator) {
            super(manipulator);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class CustomEffect
    extends SimplePixelEffect {
        private final PixelManipulator manipulator;

        CustomEffect(PixelManipulator manipulator) {
            this.manipulator = manipulator;
        }

        @Override
        protected int processPixel(int x, int y, int color, NativeImage image) {
            return this.manipulator.manipulate(x, y, color);
        }

        @Override
        public String getName() {
            return "custom";
        }
    }

    public static abstract class SimplePixelEffect
    extends PixelEffect {
        @Override
        public NativeImage apply(NativeImage input) {
            NativeImage output = new NativeImage(input.getWidth(), input.getHeight(), false);
            for (int y = 0; y < input.getHeight(); ++y) {
                for (int x = 0; x < input.getWidth(); ++x) {
                    output.setPixelRGBA(x, y, this.processPixel(x, y, input.getPixelRGBA(x, y), input));
                }
            }
            return output;
        }

        protected abstract int processPixel(int var1, int var2, int var3, NativeImage var4);
    }

    public static abstract class PixelEffect {
        public abstract NativeImage apply(NativeImage var1);

        public abstract String getName();
    }
}

