/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.metrics;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.Commands;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class Profiler {
    private static final Map<String, ProfilerInstance> INSTANCES = new HashMap<String, ProfilerInstance>();
    private static boolean enabled = false;
    private static boolean stressTest = false;
    private static final ProfilerInstance stressProfiler = Profiler.create("StressTest", ChatFormatting.RED);

    public static ProfilerInstance create(String name, ChatFormatting color) {
        ProfilerInstance instance = new ProfilerInstance(name, color);
        INSTANCES.put(name, instance);
        return instance;
    }

    public static class ProfilerInstance {
        private final String name;
        private final ChatFormatting color;
        private long startTime;
        private final List<Long> measurements = new ArrayList<Long>();
        private double currentAvg = 0.0;

        private ProfilerInstance(String name, ChatFormatting color) {
            this.name = name;
            this.color = color;
        }

        public void start() {
            if (enabled) {
                this.startTime = System.nanoTime();
            }
        }

        public void end() {
            if (enabled && this.startTime != 0L) {
                this.measurements.add(System.nanoTime() - this.startTime);
                if (this.measurements.size() > 100) {
                    this.measurements.remove(0);
                }
                this.currentAvg = this.measurements.stream().mapToLong(l -> l).average().orElse(0.0) / 1000000.0;
            }
        }

        private String getStats() {
            return String.format("%s: %.2f ms", this.name, this.currentAvg);
        }
    }

    @EventBusSubscriber(modid="portingdeadlibs", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onRender(RenderGuiEvent.Post event) {
            if (!enabled) {
                return;
            }
            GuiGraphics graphics = event.getGuiGraphics();
            int y = 5;
            for (ProfilerInstance instance : INSTANCES.values()) {
                String text = instance.getStats();
                graphics.drawString(Minecraft.getInstance().font, text, 5, y, instance.color.getColor().intValue());
                y += 10;
            }
        }
    }

    @EventBusSubscriber(modid="portingdeadlibs")
    public static class ProfilerCommands {
        @SubscribeEvent
        public static void register(RegisterCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"pdl").then(Commands.literal((String)"profiler").then(Commands.literal((String)"toggle").executes(context -> {
                enabled = !enabled;
                return 1;
            }))));
        }
    }
}

