/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class UniqueArray<E>
extends ArrayList<E>
implements Set<E> {
    public UniqueArray() {
    }

    public UniqueArray(Collection<? extends E> c) {
        this.addAll(c);
    }

    public UniqueArray(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        if (this.contains(element)) {
            return;
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @SafeVarargs
    public final boolean addAll(E ... c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<E> toAdd = new ArrayList<E>();
        for (E e : c) {
            if (this.contains(e)) continue;
            toAdd.add(e);
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        return super.addAll(index, toAdd);
    }

    @Override
    public E set(int index, E element) {
        Object current = this.get(index);
        if (Objects.equals(current, element)) {
            return super.set(index, element);
        }
        int existingIndex = this.indexOf(element);
        if (existingIndex >= 0 && existingIndex != index) {
            return current;
        }
        return super.set(index, element);
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return super.toArray(a);
    }

    public List<E> toList() {
        return new ArrayList(this);
    }

    public Set<E> toSet() {
        return new HashSet(this);
    }

    public static <T> Codec<UniqueArray<T>> CODEC(Codec<T> elementCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)elementCodec).fieldOf("elements").forGetter(UniqueArray::toList)).apply((Applicative)instance, UniqueArray::new));
    }

    public static <B extends ByteBuf, T> StreamCodec<B, UniqueArray<T>> STREAM_CODEC(StreamCodec<B, T> elementStreamCodec) {
        return StreamCodec.composite((StreamCodec)elementStreamCodec.apply(ByteBufCodecs.list()), UniqueArray::toList, UniqueArray::new);
    }
}

