/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.UnknownNullability;

public class SerializerUtils {
    public static <H> INBTSerializable<Tag> empty(H ignoredHandler) {
        return new INBTSerializable<Tag>(){

            public @UnknownNullability Tag serializeNBT(HolderLookup.Provider provider) {
                return new CompoundTag();
            }

            public void deserializeNBT(HolderLookup.Provider provider, Tag tag) {
            }
        };
    }

    public static INBTSerializable<CompoundTag> fluidTank(IFluidHandler tank) {
        return new FluidTankSerializer((FluidTank)tank);
    }

    private record FluidTankSerializer(FluidTank tank) implements INBTSerializable<CompoundTag>
    {
        public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
            return this.tank.writeToNBT(provider, new CompoundTag());
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.tank.setFluid(this.tank.readFromNBT(provider, tag).getFluid());
        }
    }
}

