/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class LazyFinal<T>
implements Supplier<T> {
    @Nullable
    private volatile T cachedValue = null;
    private volatile boolean initialized = false;
    private final Object lock = new Object();

    public static <T> LazyFinal<T> create() {
        return new LazyFinal<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(T value) {
        if (this.initialized) {
            throw new IllegalStateException("WriteOnceLazy has already been initialized");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("WriteOnceLazy has already been initialized");
            }
            this.cachedValue = value;
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Supplier<T> supplier) {
        if (this.initialized) {
            throw new IllegalStateException("WriteOnceLazy has already been initialized");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("WriteOnceLazy has already been initialized");
            }
            T value = supplier.get();
            if (value == null) {
                throw new IllegalArgumentException("Supplier returned null, which is not allowed");
            }
            this.cachedValue = value;
            this.initialized = true;
        }
    }

    public void ifInitialized(Consumer<T> consumer) {
        if (this.initialized) {
            consumer.accept(this.cachedValue);
        }
    }

    @Override
    @Nullable
    public T get() {
        return this.cachedValue;
    }

    public T getOrThrow() {
        if (!this.initialized) {
            throw new IllegalStateException("LazyFinal has not been initialized yet");
        }
        return this.cachedValue;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public T getOrDefault(T defaultValue) {
        return this.initialized ? this.cachedValue : defaultValue;
    }

    public String toString() {
        return "LazyFinal{initialized=" + this.initialized + ", value=" + (this.initialized ? String.valueOf(this.cachedValue) : "uninitialized") + "}";
    }
}

