/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.networking;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.data.saved.SavedDataHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncSavedDataToServerPayload<T>(SavedDataHolder<T> holder, T value) implements CustomPacketPayload
{
    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return SyncSavedDataToServerPayload.type(this.holder);
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            this.holder.value().preSyncFunction().accept(context.player());
            this.holder.value().setData(context.player().level(), this.value);
            this.holder.value().postSyncFunction().accept(context.player());
        }).exceptionally(err -> {
            PortingDeadLibs.LOGGER.error("Failed to handle SyncSavedDataPayload", err);
            return null;
        });
    }

    public static <T> CustomPacketPayload.Type<SyncSavedDataToServerPayload<T>> type(SavedDataHolder<T> dataHolder) {
        return new CustomPacketPayload.Type(dataHolder.key().withPrefix("sync_").withSuffix("_to_server_payload"));
    }

    private static <T> SyncSavedDataToServerPayload<T> untyped(SavedDataHolder<?> network, T value) {
        return new SyncSavedDataToServerPayload(network, value);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, SyncSavedDataToServerPayload<T>> streamCodec(SavedDataHolder<?> dataHolder) {
        return StreamCodec.composite(SavedDataHolder.STREAM_CODEC, SyncSavedDataToServerPayload::holder, dataHolder.value().streamCodec(), SyncSavedDataToServerPayload::value, SyncSavedDataToServerPayload::untyped);
    }
}

