/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.client.screens.widgets;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.BufferUtils;

public class BlockRenderingWidget
extends AbstractWidget {
    public final Map<BlockPos, Block> blocksToRender = new HashMap<BlockPos, Block>();
    public int maxLeft;
    public int maxRight;
    public int maxForward;
    public int maxBackward;
    public int maxUp;
    public int maxDown;
    private final BlockRenderDispatcher blocks = Minecraft.getInstance().getBlockRenderer();
    private double zoom = 1.0;
    public double rotation = 30.0;
    public double yOffset = 0.0;

    public BlockRenderingWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
    }

    public BlockRenderingWidget(int x, int y, int width, int height, Map<BlockPos, Block> blocksToRender) {
        this(x, y, width, height);
        this.blocksToRender.putAll(blocksToRender);
        for (BlockPos pos : blocksToRender.keySet()) {
            if (pos.getX() < this.maxLeft) {
                this.maxLeft = pos.getX();
            }
            if (pos.getX() > this.maxRight) {
                this.maxRight = pos.getX();
            }
            if (pos.getZ() < this.maxForward) {
                this.maxForward = pos.getZ();
            }
            if (pos.getZ() > this.maxBackward) {
                this.maxBackward = pos.getZ();
            }
            if (pos.getY() < this.maxDown) {
                this.maxDown = pos.getY();
            }
            if (pos.getY() <= this.maxUp) continue;
            this.maxUp = pos.getY();
        }
    }

    public Map<Integer, Map<BlockPos, Block>> getBlocksAsLayers() {
        HashMap<Integer, Map<BlockPos, Block>> layers = new HashMap<Integer, Map<BlockPos, Block>>();
        for (BlockPos pos : this.blocksToRender.keySet()) {
            layers.putIfAbsent(pos.getY(), new HashMap());
            ((Map)layers.get(pos.getY())).put(pos, this.blocksToRender.get(pos));
        }
        return layers;
    }

    public Map<BlockPos, Block> getBlocksToRender() {
        return this.blocksToRender;
    }

    public void addBlockToRender(BlockPos pos, Block block) {
        this.blocksToRender.put(pos, block);
    }

    public void removeBlockToRender(BlockPos pos) {
        this.blocksToRender.remove(pos);
    }

    private void drawScaledTexture(GuiGraphics guiGraphics, ResourceLocation texture, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        guiGraphics.blit(texture, this.getX(), this.getY(), this.getWidth(), this.getHeight(), u, v, uWidth, vHeight, textureWidth, textureHeight);
    }

    private void renderRecipe(GuiGraphics guiGraphics, double guiScaleFactor) {
        PoseStack mx = guiGraphics.pose();
        try {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -12566464);
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            double scale = Minecraft.getInstance().getWindow().getGuiScale();
            Matrix4f matrix = mx.last().pose();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            matrix.get(buf);
            int scaledX = (int)((double)this.getX() * scale);
            int scaledY = (int)((double)this.getY() * scale);
            int scaledWidth = (int)((double)this.getWidth() * scale);
            int scaledHeight = (int)((double)this.getHeight() * scale);
            int scissorX = Math.round((float)((double)buf.get(12) * scale + (double)scaledX));
            int scissorY = Math.round((float)((double)(Minecraft.getInstance().getWindow().getHeight() - scaledY - scaledHeight) - (double)buf.get(13) * scale));
            int scissorW = Math.round(scaledWidth);
            int scissorH = Math.round(scaledHeight);
            RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
            mx.pushPose();
            mx.translate((double)this.getX() + (double)this.getWidth() / 2.0, (double)this.getY() + (double)this.getHeight() / 2.0, 100.0);
            int totalLayers = this.maxUp - this.maxDown + 1;
            float avgDim = (float)Math.sqrt(totalLayers * 9);
            float previewScale = (float)(3.0 + Math.exp(3.0f - avgDim / 5.0f)) * (float)this.zoom;
            mx.scale(previewScale, -previewScale, previewScale);
            this.drawBlocks(mx, buffers);
            mx.popPose();
            buffers.endBatch();
            RenderSystem.disableScissor();
        }
        catch (Exception ex) {
            PortingDeadLibs.LOGGER.warn("Error rendering multiblock", (Throwable)ex);
        }
    }

    private void drawBlocks(PoseStack mx, MultiBufferSource.BufferSource buffers) {
        mx.mulPose(new Quaternionf().rotationXYZ((float)Math.toRadians(this.rotation), (float)Math.toRadians(30.0), 0.0f));
        Map<Integer, Map<BlockPos, Block>> layersMap = this.getBlocksAsLayers();
        IntIntPair width = IntIntPair.of((int)this.maxLeft, (int)this.maxRight);
        mx.translate(-((double)width.leftInt() / 2.0) - 0.5, -((double)layersMap.keySet().size() / 2.0) - 0.5, -((double)width.rightInt() / 2.0) - 0.5);
        for (int y : layersMap.keySet()) {
            this.renderBlockLayer(mx, buffers, layersMap.get(y));
        }
    }

    private void renderBlockLayer(PoseStack mx, MultiBufferSource.BufferSource buffers, Map<BlockPos, Block> layer) {
        mx.pushPose();
        for (BlockPos pos : layer.keySet()) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            mx.pushPose();
            mx.translate((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            Block block = layer.get(pos);
            if (block != null && block != Blocks.AIR) {
                this.renderBlock(mx, buffers, block.defaultBlockState());
            }
            mx.popPose();
        }
        mx.popPose();
    }

    private void renderBlock(PoseStack mx, MultiBufferSource.BufferSource buffers, BlockState state) {
        try {
            this.blocks.renderSingleBlock(state, mx, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        }
        catch (Exception e) {
            PortingDeadLibs.LOGGER.warn("Error rendering block in preview: {}", (Object)state);
            PortingDeadLibs.LOGGER.error("Stack Trace", (Throwable)e);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered()) {
            this.zoom = Math.clamp(this.zoom + scrollY * 0.1, 0.1, 5.0);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button) && this.isHovered()) {
            this.rotation = (this.rotation + dragY) % 360.0;
            this.yOffset = (this.yOffset - dragX) % 360.0;
            return true;
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        Window mainWindow = Minecraft.getInstance().getWindow();
        double guiScaleFactor = mainWindow.getGuiScale();
        this.renderRecipe(guiGraphics, guiScaleFactor);
        if (this.isHovered()) {
            guiGraphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -2130706433);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

