/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.cache;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;

public class AllPlayersCache {
    private static final List<UUID> UUIDS = new UniqueArray<UUID>();
    private static final Map<UUID, String> NAMES = new HashMap<UUID, String>();
    private static final Map<UUID, PlayerSkin> SKINS = new HashMap<UUID, PlayerSkin>();

    public static void add(UUID uuid, String name, PlayerSkin skin) {
        if (!UUIDS.contains(uuid)) {
            UUIDS.add(uuid);
        }
        NAMES.put(uuid, name);
        SKINS.put(uuid, skin);
    }

    public static void add(UUID uuid, String name) {
        if (!UUIDS.contains(uuid)) {
            UUIDS.add(uuid);
        }
        NAMES.put(uuid, name);
    }

    public static String getName(UUID uuid) {
        String name = NAMES.get(uuid);
        if (name == null) {
            name = "!Unknown Player!";
        }
        return name;
    }

    public static PlayerSkin getSkin(UUID uuid) {
        PlayerSkin skin = SKINS.get(uuid);
        if (skin == null) {
            skin = DefaultPlayerSkin.get((UUID)uuid);
        }
        return skin;
    }

    public static List<UUID> getUUIDs() {
        return UUIDS;
    }

    public static void clearCache() {
        UUIDS.clear();
        NAMES.clear();
        SKINS.clear();
    }
}

