/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.gui.menus.slots;

import com.portingdeadmods.portingdeadlibs.api.gui.menus.slots.AbstractSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceSlot<T>
extends AbstractSlot {
    protected T reference;
    protected final ReferenceListener<T> listener;
    private final int width;
    private final int height;

    public ReferenceSlot(int index, int x, int y, int width, int height, @Nullable ReferenceListener<T> listener) {
        super(index, x, y);
        this.listener = listener;
        this.reference = this.getEmptyReference();
        this.width = width;
        this.height = height;
    }

    protected abstract T getEmptyReference();

    public abstract boolean setReference(ItemStack var1);

    public boolean setReferenceDirectly(T reference) {
        if (reference == null || this.isReferenceEmpty(reference)) {
            this.clearReference();
            return true;
        }
        T copyOfReference = this.copyReference(reference);
        if (!this.areReferencesEqual(copyOfReference, this.reference)) {
            this.reference = copyOfReference;
            if (this.listener != null) {
                this.listener.onReferenceChanged(copyOfReference);
            }
            return true;
        }
        return false;
    }

    protected abstract T copyReference(T var1);

    protected abstract boolean areReferencesEqual(T var1, T var2);

    protected abstract boolean isReferenceEmpty(T var1);

    public void clearReference() {
        if (!this.isReferenceEmpty(this.reference)) {
            this.reference = this.getEmptyReference();
            if (this.listener != null) {
                this.listener.onReferenceChanged(this.reference);
            }
        }
    }

    public T getReference() {
        return this.reference;
    }

    public boolean handleSpecialClick(Player player, ClickType clickType, ClickAction clickAction) {
        return false;
    }

    public static interface ReferenceListener<T> {
        public void onReferenceChanged(T var1);
    }
}

