/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.gui.menus;

import com.google.common.collect.ImmutableList;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.slots.FluidReferenceSlot;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.slots.ItemReferenceSlot;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public abstract class PDLAbstractContainerMenu<T extends ContainerBlockEntity>
extends AbstractContainerMenu {
    @NotNull
    public final T blockEntity;
    @NotNull
    protected final Inventory inv;
    private final ContainerLevelAccess access;
    private final ImmutableList<Block> validBlocks;
    private final NonNullList<ItemReferenceSlot> itemReferenceSlots;
    private final NonNullList<FluidReferenceSlot> fluidReferenceSlots;

    public PDLAbstractContainerMenu(MenuType<?> menuType, int containerId, @NotNull Inventory inv, @NotNull T blockEntity) {
        super(menuType, containerId);
        this.blockEntity = blockEntity;
        this.inv = inv;
        this.access = ContainerLevelAccess.create((Level)inv.player.level(), (BlockPos)blockEntity.getBlockPos());
        this.validBlocks = ImmutableList.copyOf((Collection)blockEntity.getType().getValidBlocks());
        this.itemReferenceSlots = NonNullList.create();
        this.fluidReferenceSlots = NonNullList.create();
    }

    @NotNull
    public T getBlockEntity() {
        return this.blockEntity;
    }

    protected void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 83 + i * 18));
            }
        }
    }

    protected void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 141));
        }
    }

    protected void addPlayerInventory(Inventory playerInventory, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, y + i * 18));
            }
        }
    }

    protected void addPlayerHotbar(Inventory playerInventory, int y) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, y));
        }
    }

    protected void addItemReferenceSlot(ItemReferenceSlot slot) {
        this.itemReferenceSlots.add((Object)slot);
    }

    protected void addFluidReferenceSlot(FluidReferenceSlot slot) {
        this.fluidReferenceSlots.add((Object)slot);
    }

    public boolean stillValid(Player player) {
        for (Block block : this.validBlocks) {
            boolean valid = PDLAbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)block);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsShiftClick(Player player, int index) {
        return true;
    }

    protected abstract int getMergeableSlotCount();

    public ItemStack quickMoveStack(Player player, int index) {
        if (!this.supportsShiftClick(player, index)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            stack = stackInSlot.copy();
            if (!this.performMerge(index, stackInSlot)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stackInSlot, stack);
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return stack;
    }

    protected boolean performMerge(int index, ItemStack stack) {
        int invBase = this.getMergeableSlotCount();
        int invFull = this.slots.size();
        int invHotbar = invFull - 9;
        int invPlayer = invHotbar - 27;
        if (index < invPlayer) {
            return this.moveItemStackTo(stack, invPlayer, invFull, false);
        }
        return this.moveItemStackTo(stack, 0, invBase, false);
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return PDLAbstractContainerMenu.mergeItemStack((List<Slot>)this.slots, stack, startIndex, endIndex, reverseDirection);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack stackInSlot;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = reverseDirection ? endIndex - 1 : startIndex;
        int n = iterOrder = reverseDirection ? -1 : 1;
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                if (!slot.mayPlace(stack)) {
                    i += iterOrder;
                    continue;
                }
                stackInSlot = slot.getItem();
                if (!stackInSlot.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
                    int maxSize;
                    int size = stackInSlot.getCount() + stack.getCount();
                    if (size <= (maxSize = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()))) {
                        stack.setCount(0);
                        stackInSlot.setCount(size);
                        slot.set(stackInSlot);
                        successful = true;
                    } else if (stackInSlot.getCount() < maxSize) {
                        stack.shrink(maxSize - stackInSlot.getCount());
                        stackInSlot.setCount(maxSize);
                        slot.set(stackInSlot);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (!stack.isEmpty()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                stackInSlot = slot.getItem();
                if (stackInSlot.isEmpty() && slot.mayPlace(stack)) {
                    int maxSize = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize());
                    int splitSize = Math.min(maxSize, stack.getCount());
                    slot.set(stack.split(splitSize));
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    @NotNull
    public Inventory getInv() {
        return this.inv;
    }

    public NonNullList<ItemReferenceSlot> getItemReferenceSlots() {
        return this.itemReferenceSlots;
    }

    public NonNullList<FluidReferenceSlot> getFluidReferenceSlots() {
        return this.fluidReferenceSlots;
    }
}

