/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.data.saved;

import com.mojang.serialization.Codec;
import com.portingdeadmods.portingdeadlibs.PDLRegistries;
import com.portingdeadmods.portingdeadlibs.api.client.data.PDLClientSavedData;
import com.portingdeadmods.portingdeadlibs.api.data.saved.SavedDataHolder;
import com.portingdeadmods.portingdeadlibs.api.data.saved.SavedDataWrapper;
import com.portingdeadmods.portingdeadlibs.networking.SyncSavedDataToClientPayload;
import com.portingdeadmods.portingdeadlibs.networking.SyncSavedDataToServerPayload;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PDLSavedData<T> {
    private final Supplier<T> defaultValueSupplier;
    private final Codec<T> codec;
    private final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
    private final Consumer<Player> preSyncFunction;
    private final Consumer<Player> postSyncFunction;
    private final boolean global;

    private PDLSavedData(Builder<T> builder) {
        this.codec = builder.codec;
        this.streamCodec = builder.streamCodec;
        this.defaultValueSupplier = builder.defaultValueSupplier;
        this.preSyncFunction = builder.preSyncFunction;
        this.postSyncFunction = builder.postSyncFunction;
        this.global = builder.global;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public Supplier<T> defaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public Consumer<Player> preSyncFunction() {
        return this.preSyncFunction;
    }

    public Consumer<Player> postSyncFunction() {
        return this.postSyncFunction;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isSynced() {
        return this.streamCodec != null;
    }

    public void syncToPlayer(ServerPlayer player) {
        if (!this.isSynced()) {
            return;
        }
        T data = this.getData(player.level());
        PacketDistributor.sendToPlayer((ServerPlayer)player, new SyncSavedDataToClientPayload(new SavedDataHolder(PDLRegistries.SAVED_DATA.getKey((Object)this), this), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sync(Level level) {
        if (!this.isSynced()) {
            return;
        }
        T data = this.getData(level);
        if (level.isClientSide()) {
            PacketDistributor.sendToServer(new SyncSavedDataToServerPayload(new SavedDataHolder(PDLRegistries.SAVED_DATA.getKey((Object)this), this), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers(new SyncSavedDataToClientPayload(new SavedDataHolder(PDLRegistries.SAVED_DATA.getKey((Object)this), this), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setData(Level level, T data) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel0 = (ServerLevel)level;
            ServerLevel serverLevel = this.isGlobal() ? serverLevel0.getServer().overworld() : serverLevel0;
            ResourceLocation location = PDLRegistries.SAVED_DATA.getKey((Object)this);
            if (location != null) {
                SavedDataWrapper.setData(new SavedDataHolder(location, this), serverLevel, data);
            }
        } else {
            ResourceLocation key = PDLRegistries.SAVED_DATA.getKey((Object)this);
            if (key != null) {
                PDLClientSavedData.CLIENT_SAVED_DATA_CACHE.put(key, data);
            }
        }
    }

    public T getData(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel0 = (ServerLevel)level;
            ServerLevel serverLevel = this.isGlobal() ? serverLevel0.getServer().overworld() : serverLevel0;
            ResourceLocation location = PDLRegistries.SAVED_DATA.getKey((Object)this);
            if (location != null) {
                return SavedDataWrapper.getData(new SavedDataHolder(location, this), serverLevel);
            }
        } else {
            ResourceLocation location = PDLRegistries.SAVED_DATA.getKey((Object)this);
            if (location != null) {
                return (T)PDLClientSavedData.CLIENT_SAVED_DATA_CACHE.get(location);
            }
        }
        return null;
    }

    public static <T> Builder<T> builder(Codec<T> codec, Supplier<T> defaultValueSupplier) {
        return new Builder<T>(codec, defaultValueSupplier);
    }

    public static final class Builder<T> {
        private final Supplier<T> defaultValueSupplier;
        private final Codec<T> codec;
        private Consumer<Player> preSyncFunction;
        private Consumer<Player> postSyncFunction;
        private StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
        private boolean global = false;

        private Builder(Codec<T> codec, Supplier<T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            this.codec = codec;
        }

        public Builder<T> synced(StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
            this.streamCodec = streamCodec;
            return this;
        }

        public Builder<T> preSync(Consumer<Player> preSyncFunction) {
            this.preSyncFunction = preSyncFunction;
            return this;
        }

        public Builder<T> postSync(Consumer<Player> postSyncFunction) {
            this.postSyncFunction = postSyncFunction;
            return this;
        }

        public Builder<T> global() {
            this.global = true;
            return this;
        }

        public PDLSavedData<T> build() {
            if (this.preSyncFunction != null && this.postSyncFunction != null && this.streamCodec == null) {
                throw new RuntimeException("Cannot provide sync functions for a saved data without a stream codec");
            }
            if (this.streamCodec != null) {
                if (this.preSyncFunction == null) {
                    this.preSyncFunction = p -> {};
                }
                if (this.postSyncFunction == null) {
                    this.postSyncFunction = p -> {};
                }
            }
            return new PDLSavedData(this);
        }
    }
}

