/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.portingdeadmods.portingdeadlibs.api.fluids.BaseFluidType;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockController;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockPart;
import com.portingdeadmods.portingdeadlibs.client.PDLRenderTypes;
import com.portingdeadmods.portingdeadlibs.mixins.LevelRendererMixin;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4i;

@Mod(value="portingdeadlibs", dist={Dist.CLIENT})
public final class PortingDeadLibsClient {
    public static final String MODID = "portingdeadlibs";

    public PortingDeadLibsClient(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::registerClientExtensions);
        NeoForge.EVENT_BUS.addListener(this::renderOutline);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void registerClientExtensions(RegisterClientExtensionsEvent event) {
        for (FluidType fluidType : NeoForgeRegistries.FLUID_TYPES) {
            if (!(fluidType instanceof BaseFluidType)) continue;
            final BaseFluidType baseFluidType = (BaseFluidType)fluidType;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return baseFluidType.getStillTexture();
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return baseFluidType.getFlowingTexture();
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return baseFluidType.getOverlayTexture();
                }

                public int getTintColor() {
                    Vector4i color = baseFluidType.getColor();
                    return FastColor.ARGB32.color((int)color.w, (int)color.x, (int)color.y, (int)color.z);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector4i color = baseFluidType.getColor();
                    return new Vector3f((float)color.x / 255.0f, (float)color.y / 255.0f, (float)color.z / 255.0f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)1.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            }, new FluidType[]{baseFluidType});
        }
    }

    public void renderOutline(RenderHighlightEvent.Block event) {
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level world = living.level();
            BlockHitResult rtr = event.getTarget();
            BlockPos pos = rtr.getBlockPos();
            Vec3 renderView = event.getCamera().getPosition();
            BlockState targetBlock = world.getBlockState(rtr.getBlockPos());
            if (targetBlock.getBlock() instanceof GhostMultiblockController || targetBlock.getBlock() instanceof GhostMultiblockPart) {
                ((LevelRendererMixin)event.getLevelRenderer()).callRenderHitOutline(event.getPoseStack(), event.getMultiBufferSource().getBuffer(PDLRenderTypes.LINES_NONTRANSLUCENT), (Entity)living, renderView.x, renderView.y, renderView.z, pos, targetBlock);
                event.setCanceled(true);
            }
        }
    }
}

