/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge.data.providers;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.sashiro.compressedblocks.Constants;
import net.sashiro.compressedblocks.block.CBBlock;

public class CBRecipeProvider
extends RecipeProvider {
    public CBRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    private static CBBlock getCbBlock(ItemLike result, ItemLike ingredient) {
        CBBlock block = null;
        if (ingredient instanceof CBBlock) {
            block = (CBBlock)ingredient;
        } else if (result instanceof CBBlock) {
            block = (CBBlock)result;
        }
        return block;
    }

    private void makeShapedRecipe(RecipeOutput exporter, RecipeCategory recipeCategory, ItemLike result, ItemLike ingredient, String fileName) {
        CBBlock compressedBlock = CBRecipeProvider.getCbBlock(result, ingredient);
        if (compressedBlock != null && compressedBlock.getCompressor().hasSmallerCompression()) {
            ShapedRecipeBuilder.shaped((RecipeCategory)recipeCategory, (ItemLike)result).define(Character.valueOf('#'), ingredient).pattern("##").pattern("##").unlockedBy("has_item", CBRecipeProvider.has((ItemLike)ingredient.asItem())).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)("shaped_lesser_" + fileName)));
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)recipeCategory, (ItemLike)result).define(Character.valueOf('#'), ingredient).pattern("###").pattern("###").pattern("###").unlockedBy("has_item", CBRecipeProvider.has((ItemLike)ingredient.asItem())).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)("shaped_" + fileName)));
        }
    }

    private void makeShapelessRecipe(RecipeOutput exporter, RecipeCategory recipeCategory, ItemLike result, ItemLike ingredient, String recipeName) {
        CBBlock compressedBlock = CBRecipeProvider.getCbBlock(result, ingredient);
        if (compressedBlock != null && compressedBlock.getCompressor().hasSmallerCompression()) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemLike)result, (int)4).requires(ingredient).unlockedBy("has_item", CBRecipeProvider.has((ItemLike)ingredient.asItem())).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)("shapeless_lesser_" + recipeName)));
        } else {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemLike)result, (int)9).requires(ingredient).unlockedBy("has_item", CBRecipeProvider.has((ItemLike)ingredient.asItem())).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)("shapeless_" + recipeName)));
        }
    }

    @ParametersAreNonnullByDefault
    protected void buildRecipes(RecipeOutput exporter) {
        ArrayList<Block> blocks = Constants.BLOCKS;
        for (int i = 0; i < blocks.size(); ++i) {
            String blockName = blocks.get(i).getDescriptionId().replace("block.compressedblocks.", "");
            if (blockName.contains("c0_")) {
                String cbBlockName = blockName.replace("c0_", "");
                for (Block mcBlock : BuiltInRegistries.BLOCK) {
                    String mcBlockName = mcBlock.getDescriptionId().replace("block.minecraft.", "");
                    if (!cbBlockName.equals(mcBlockName)) continue;
                    this.makeShapedRecipe(exporter, RecipeCategory.BUILDING_BLOCKS, (ItemLike)blocks.get(i), (ItemLike)mcBlock, blockName);
                    this.makeShapelessRecipe(exporter, RecipeCategory.BUILDING_BLOCKS, (ItemLike)mcBlock, (ItemLike)blocks.get(i), blockName);
                }
                continue;
            }
            this.makeShapedRecipe(exporter, RecipeCategory.BUILDING_BLOCKS, (ItemLike)blocks.get(i), (ItemLike)blocks.get(i - 1), blockName);
            this.makeShapelessRecipe(exporter, RecipeCategory.BUILDING_BLOCKS, (ItemLike)blocks.get(i - 1), (ItemLike)blocks.get(i), blockName);
        }
        ArrayList<Block> crate_items = Constants.CRATES;
        for (int i = 0; i < crate_items.size(); ++i) {
            String crate_itemName = crate_items.get(i).getDescriptionId().replace("block.compressedblocks.", "");
            if (crate_itemName.startsWith("crated")) {
                String crate_itemName_clean = crate_itemName.replace("crated_", "");
                for (Item vanillaItem : BuiltInRegistries.ITEM) {
                    String vanillaItemName = vanillaItem.getDescriptionId().replace("item.minecraft.", "").replace("block.minecraft.", "");
                    if (!crate_itemName_clean.equals(vanillaItemName)) continue;
                    this.makeShapedRecipe(exporter, RecipeCategory.MISC, (ItemLike)crate_items.get(i), (ItemLike)vanillaItem, crate_itemName);
                    this.makeShapelessRecipe(exporter, RecipeCategory.MISC, (ItemLike)vanillaItem, (ItemLike)crate_items.get(i), crate_itemName);
                }
                continue;
            }
            this.makeShapedRecipe(exporter, RecipeCategory.MISC, (ItemLike)crate_items.get(i), (ItemLike)crate_items.get(i - 1), crate_itemName);
            this.makeShapelessRecipe(exporter, RecipeCategory.MISC, (ItemLike)crate_items.get(i - 1), (ItemLike)crate_items.get(i), crate_itemName);
        }
    }
}

