/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge.data.providers;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.sashiro.compressedblocks.neoforge.CompressedBlocksNeoForge;
import net.sashiro.compressedblocks.neoforge.data.CBTags;
import org.jetbrains.annotations.NotNull;

public class CBBlockTagsProvider
extends BlockTagsProvider {
    public CBBlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, modId, existingFileHelper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider holder) {
        String name;
        Block block;
        for (DeferredHolder registryObject : CompressedBlocksNeoForge.CRATE_BLOCKS.getEntries()) {
            block = (Block)registryObject.get();
            name = block.getDescriptionId().replace("block.compressedblocks.", "");
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)block);
            if (name.startsWith("crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_01).add((Object)block);
            }
            if (name.startsWith("double_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_02).add((Object)block);
            }
            if (name.startsWith("triple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_03).add((Object)block);
            }
            if (name.startsWith("quadruple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_04).add((Object)block);
            }
            if (name.startsWith("quintuple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_05).add((Object)block);
            }
            if (name.startsWith("sextuple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_06).add((Object)block);
            }
            if (name.startsWith("septuple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_07).add((Object)block);
            }
            if (name.startsWith("octuple_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_08).add((Object)block);
            }
            if (name.startsWith("mega_crated_")) {
                this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_09).add((Object)block);
            }
            if (!name.startsWith("giga_crated_")) continue;
            this.tag(CBTags.CompressionBlockTags.COMPRESSION_X_10).add((Object)block);
        }
        for (DeferredHolder registryObject : CompressedBlocksNeoForge.BLOCKS.getEntries()) {
            block = (Block)registryObject.get();
            name = block.getDescriptionId().replace("block.compressedblocks.", "");
            if (name.startsWith("c0")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_01).add((Object)block);
            }
            if (name.startsWith("c1")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_02).add((Object)block);
            }
            if (name.startsWith("c2")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_03).add((Object)block);
            }
            if (name.startsWith("c3")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_04).add((Object)block);
            }
            if (name.startsWith("c4")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_05).add((Object)block);
            }
            if (name.startsWith("c5")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_06).add((Object)block);
            }
            if (name.startsWith("c6")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_07).add((Object)block);
            }
            if (name.startsWith("c7")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_08).add((Object)block);
            }
            if (name.startsWith("c8")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_09).add((Object)block);
            }
            if (name.startsWith("c9")) {
                this.tag(CBTags.CompressionBlockTags.CRATE_X_10).add((Object)block);
            }
            if (Stream.of("slime", "honey", "vine", "vein", "lichen").anyMatch(name::contains)) continue;
            if (name.contains("dirt") || name.contains("sand") && !name.contains("sandstone") || name.contains("gravel") || name.contains("clay")) {
                this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)block);
                continue;
            }
            if (Stream.of("hay", "wart", "kelp", "moss", "sculk").anyMatch(name::contains)) {
                this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)block);
                continue;
            }
            if (Stream.of("wood", "plank", "log").anyMatch(name::contains)) {
                this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)block);
                continue;
            }
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
        }
    }
}

