/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J \u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ldev/bluesheep/nanomirai/util/InputSingleItemHandler;", "Lnet/neoforged/neoforge/items/IItemHandler;", "itemHandler", "slotId", "", "<init>", "(Lnet/neoforged/neoforge/items/IItemHandler;I)V", "getItemHandler", "()Lnet/neoforged/neoforge/items/IItemHandler;", "getSlotId", "()I", "getSlots", "getStackInSlot", "Lnet/minecraft/world/item/ItemStack;", "slot", "insertItem", "stack", "simulate", "", "extractItem", "amount", "getSlotLimit", "isItemValid", "nanomirai"})
public class InputSingleItemHandler
implements IItemHandler {
    @NotNull
    private final IItemHandler itemHandler;
    private final int slotId;

    public InputSingleItemHandler(@NotNull IItemHandler itemHandler, int slotId) {
        Intrinsics.checkNotNullParameter((Object)itemHandler, (String)"itemHandler");
        this.itemHandler = itemHandler;
        this.slotId = slotId;
    }

    @NotNull
    public final IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public final int getSlotId() {
        return this.slotId;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(this.slotId);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack itemStack = this.itemHandler.insertItem(this.slotId, stack, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"insertItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack = this.itemHandler.extractItem(this.slotId, amount, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"extractItem(...)");
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(this.slotId);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.itemHandler.isItemValid(this.slotId, stack);
    }
}

