/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ldev/bluesheep/nanomirai/util/InputItemHandler;", "Lnet/neoforged/neoforge/items/IItemHandler;", "itemHandler", "<init>", "(Lnet/neoforged/neoforge/items/IItemHandler;)V", "getItemHandler", "()Lnet/neoforged/neoforge/items/IItemHandler;", "getSlots", "", "getStackInSlot", "Lnet/minecraft/world/item/ItemStack;", "slot", "insertItem", "stack", "simulate", "", "extractItem", "amount", "getSlotLimit", "isItemValid", "nanomirai"})
public final class InputItemHandler
implements IItemHandler {
    @NotNull
    private final IItemHandler itemHandler;

    public InputItemHandler(@NotNull IItemHandler itemHandler) {
        Intrinsics.checkNotNullParameter((Object)itemHandler, (String)"itemHandler");
        this.itemHandler = itemHandler;
    }

    @NotNull
    public final IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getSlots() {
        return this.itemHandler.getSlots() - 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(slot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack itemStack = this.itemHandler.insertItem(slot + 1, stack, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"insertItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack = this.itemHandler.extractItem(slot + 1, amount, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"extractItem(...)");
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot + 1);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.itemHandler.isItemValid(slot + 1, stack);
    }
}

