/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.recipe.synthesize;

import dev.bluesheep.nanomirai.recipe.BlockWithPairItemInput;
import dev.bluesheep.nanomirai.registry.NanoMiraiItems;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeSerializer;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020!H\u0016J\f\u0010&\u001a\u0006\u0012\u0002\b\u00030'H\u0016J\f\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006*"}, d2={"Ldev/bluesheep/nanomirai/recipe/synthesize/SynthesizeRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/bluesheep/nanomirai/recipe/BlockWithPairItemInput;", "result", "Lnet/minecraft/world/item/ItemStack;", "tier", "", "inputBlock", "Lnet/minecraft/world/level/block/state/BlockState;", "inputCatalystItem", "Lnet/minecraft/world/item/crafting/Ingredient;", "duration", "<init>", "(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/crafting/Ingredient;I)V", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "getTier", "()I", "getInputBlock", "()Lnet/minecraft/world/level/block/state/BlockState;", "getInputCatalystItem", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getDuration", "getIngredients", "Lnet/minecraft/core/NonNullList;", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "assemble", "p0", "p1", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "nanomirai"})
public final class SynthesizeRecipe
implements Recipe<BlockWithPairItemInput> {
    @NotNull
    private final ItemStack result;
    private final int tier;
    @NotNull
    private final BlockState inputBlock;
    @NotNull
    private final Ingredient inputCatalystItem;
    private final int duration;

    public SynthesizeRecipe(@NotNull ItemStack result, int tier, @NotNull BlockState inputBlock, @NotNull Ingredient inputCatalystItem, int duration) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)inputBlock, (String)"inputBlock");
        Intrinsics.checkNotNullParameter((Object)inputCatalystItem, (String)"inputCatalystItem");
        this.result = result;
        this.tier = tier;
        this.inputBlock = inputBlock;
        this.inputCatalystItem = inputCatalystItem;
        this.duration = duration;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    public final int getTier() {
        return this.tier;
    }

    @NotNull
    public final BlockState getInputBlock() {
        return this.inputBlock;
    }

    @NotNull
    public final Ingredient getInputCatalystItem() {
        return this.inputCatalystItem;
    }

    public final int getDuration() {
        return this.duration;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        Object[] objectArray = new Ingredient[]{this.inputCatalystItem};
        NonNullList nonNullList = NonNullList.of((Object)Ingredient.EMPTY, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"of(...)");
        return nonNullList;
    }

    public boolean matches(@NotNull BlockWithPairItemInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        boolean isBlockMatch = input.getBlock().is(this.inputBlock.getBlock());
        Rarity rarity = (Rarity)input.getMainhand().get(DataComponents.RARITY);
        boolean isNanomachineTierEnough = (rarity != null ? rarity.ordinal() : -1) >= this.tier;
        return this.inputCatalystItem.test(input.getOffhand()) && input.getMainhand().is((Item)NanoMiraiItems.INSTANCE.getSYNTHESIZE_NANO()) && isNanomachineTierEnough && isBlockMatch;
    }

    @NotNull
    public ItemStack assemble(@NotNull BlockWithPairItemInput p0, @NotNull HolderLookup.Provider p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = NanoMiraiRecipeSerializer.INSTANCE.getSYNTHESIZE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        return NanoMiraiRecipeType.INSTANCE.getSYNTHESIZE();
    }
}

