/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.bluesheep.nanomirai.recipe.StackedIngredient;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ldev/bluesheep/nanomirai/recipe/StackedIngredient;", "", "count", "", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "<init>", "(ILnet/minecraft/world/item/crafting/Ingredient;)V", "getCount", "()I", "getIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "test", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "isEmpty", "Companion", "nanomirai"})
public final class StackedIngredient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int count;
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private static final Codec<StackedIngredient> CODEC;
    @NotNull
    private static final StackedIngredient EMPTY;

    private StackedIngredient(int count, Ingredient ingredient) {
        this.count = count;
        this.ingredient = ingredient;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    public final boolean test(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.ingredient.test(stack) && stack.getCount() >= this.count;
    }

    public final boolean isEmpty() {
        return this.ingredient.isEmpty() || this.count <= 0;
    }

    private static final Integer CODEC$lambda$2$lambda$0(KProperty1 $tmp0, StackedIngredient p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Ingredient CODEC$lambda$2$lambda$1(KProperty1 $tmp0, StackedIngredient p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$2(RecordCodecBuilder.Instance inst) {
        return inst.group((App)Codec.INT.fieldOf("count").forGetter(arg_0 -> StackedIngredient.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(arg_0 -> StackedIngredient.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)inst, (p0$count, p1$ingredient) -> new StackedIngredient((int)p0$count, (Ingredient)p1$ingredient));
    }

    public /* synthetic */ StackedIngredient(int count, Ingredient ingredient, DefaultConstructorMarker $constructor_marker) {
        this(count, ingredient);
    }

    static {
        Codec codec = RecordCodecBuilder.create(StackedIngredient::CODEC$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        Ingredient ingredient = Ingredient.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"EMPTY");
        EMPTY = new StackedIngredient(0, ingredient);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J'\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J'\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0012\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/bluesheep/nanomirai/recipe/StackedIngredient$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/bluesheep/nanomirai/recipe/StackedIngredient;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "EMPTY", "getEMPTY", "()Ldev/bluesheep/nanomirai/recipe/StackedIngredient;", "of", "count", "", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "items", "", "Lnet/minecraft/world/level/ItemLike;", "(I[Lnet/minecraft/world/level/ItemLike;)Ldev/bluesheep/nanomirai/recipe/StackedIngredient;", "stacks", "Lnet/minecraft/world/item/ItemStack;", "(I[Lnet/minecraft/world/item/ItemStack;)Ldev/bluesheep/nanomirai/recipe/StackedIngredient;", "tag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "nanomirai"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<StackedIngredient> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StackedIngredient getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final StackedIngredient of() {
            return this.getEMPTY();
        }

        @NotNull
        public final StackedIngredient of(int count, @NotNull Ingredient ingredient) {
            Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
            return new StackedIngredient(count, ingredient, null);
        }

        @NotNull
        public final StackedIngredient of(int count, ItemLike ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Ingredient ingredient = Ingredient.of((ItemLike[])Arrays.copyOf(items, items.length));
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
            return new StackedIngredient(count, ingredient, null);
        }

        @NotNull
        public final StackedIngredient of(int count, ItemStack ... stacks) {
            Intrinsics.checkNotNullParameter((Object)stacks, (String)"stacks");
            Ingredient ingredient = Ingredient.of((ItemStack[])Arrays.copyOf(stacks, stacks.length));
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
            return new StackedIngredient(count, ingredient, null);
        }

        @NotNull
        public final StackedIngredient of(int count, @NotNull TagKey<Item> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Ingredient ingredient = Ingredient.of(tag);
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
            return new StackedIngredient(count, ingredient, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

