/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.menu;

import dev.bluesheep.nanomirai.block.entity.AssemblerBlockEntity;
import dev.bluesheep.nanomirai.menu.OutputSlotItemHandler;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlocks;
import dev.bluesheep.nanomirai.registry.NanoMiraiMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006*"}, d2={"Ldev/bluesheep/nanomirai/menu/AssemblerMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInv", "Lnet/minecraft/world/entity/player/Inventory;", "access", "Lnet/minecraft/world/inventory/ContainerLevelAccess;", "blockEntity", "Ldev/bluesheep/nanomirai/block/entity/AssemblerBlockEntity;", "data", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;Ldev/bluesheep/nanomirai/block/entity/AssemblerBlockEntity;Lnet/minecraft/world/inventory/ContainerData;)V", "extraData", "Lnet/minecraft/network/FriendlyByteBuf;", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "getAccess", "()Lnet/minecraft/world/inventory/ContainerLevelAccess;", "getBlockEntity", "()Ldev/bluesheep/nanomirai/block/entity/AssemblerBlockEntity;", "getData", "()Lnet/minecraft/world/inventory/ContainerData;", "playerInventoryIndex", "getPlayerInventoryIndex", "()I", "hotbarIndex", "getHotbarIndex", "hotbarIndexEnd", "getHotbarIndexEnd", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "quickMovedSlotIndex", "stillValid", "", "addPlayerInventorySlots", "", "addContainerSlots", "container", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "nanomirai"})
public final class AssemblerMenu
extends AbstractContainerMenu {
    @NotNull
    private final ContainerLevelAccess access;
    @NotNull
    private final AssemblerBlockEntity blockEntity;
    @NotNull
    private final ContainerData data;
    private final int playerInventoryIndex;
    private final int hotbarIndex;
    private final int hotbarIndexEnd;

    public AssemblerMenu(int containerId, @NotNull Inventory playerInv, @NotNull ContainerLevelAccess access, @NotNull AssemblerBlockEntity blockEntity, @NotNull ContainerData data2) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(NanoMiraiMenu.INSTANCE.getASSEMBLER(), containerId);
        this.access = access;
        this.blockEntity = blockEntity;
        this.data = data2;
        this.playerInventoryIndex = this.blockEntity.getItemHandler().getSlots();
        this.hotbarIndex = this.playerInventoryIndex + 27;
        this.hotbarIndexEnd = this.hotbarIndex + 9;
        this.addContainerSlots(this.blockEntity.getItemHandler());
        this.addPlayerInventorySlots(playerInv);
        this.addDataSlots(this.data);
    }

    @NotNull
    public final ContainerLevelAccess getAccess() {
        return this.access;
    }

    @NotNull
    public final AssemblerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @NotNull
    public final ContainerData getData() {
        return this.data;
    }

    public AssemblerMenu(int containerId, @NotNull Inventory playerInv, @NotNull FriendlyByteBuf extraData) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.NULL;
        Intrinsics.checkNotNullExpressionValue((Object)containerLevelAccess, (String)"NULL");
        BlockEntity blockEntity = playerInv.player.level().getBlockEntity(extraData.readBlockPos());
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.bluesheep.nanomirai.block.entity.AssemblerBlockEntity");
        this(containerId, playerInv, containerLevelAccess, (AssemblerBlockEntity)blockEntity, (ContainerData)new SimpleContainerData(2));
    }

    public final int getPlayerInventoryIndex() {
        return this.playerInventoryIndex;
    }

    public final int getHotbarIndex() {
        return this.hotbarIndex;
    }

    public final int getHotbarIndexEnd() {
        return this.hotbarIndexEnd;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int quickMovedSlotIndex) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack quickMovedStack = ItemStack.EMPTY;
        Object object = this.slots.get(quickMovedSlotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot quickMovedSlot = (Slot)object;
        if (quickMovedSlot.hasItem()) {
            ItemStack rawStack = quickMovedSlot.getItem();
            quickMovedStack = rawStack.copy();
            if (quickMovedSlotIndex == 0) {
                if (!this.moveItemStackTo(rawStack, this.playerInventoryIndex, this.hotbarIndexEnd, true)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
                this.getSlot(0).onQuickCraft(rawStack, quickMovedStack);
            } else {
                int n = this.playerInventoryIndex;
                boolean bl = quickMovedSlotIndex <= this.hotbarIndexEnd ? n <= quickMovedSlotIndex : false;
                if (bl) {
                    if (!this.moveItemStackTo(rawStack, 0, this.playerInventoryIndex, false)) {
                        if (quickMovedSlotIndex < this.hotbarIndex) {
                            if (!this.moveItemStackTo(rawStack, this.hotbarIndex, this.hotbarIndexEnd, false)) {
                                ItemStack itemStack = ItemStack.EMPTY;
                                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                                return itemStack;
                            }
                        } else if (!this.moveItemStackTo(rawStack, this.playerInventoryIndex, this.hotbarIndex, false)) {
                            ItemStack itemStack = ItemStack.EMPTY;
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                            return itemStack;
                        }
                    }
                } else if (!this.moveItemStackTo(rawStack, this.playerInventoryIndex, this.hotbarIndexEnd, false)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            }
            if (rawStack.isEmpty()) {
                quickMovedSlot.set(ItemStack.EMPTY);
            } else {
                quickMovedSlot.setChanged();
            }
            if (rawStack.getCount() == quickMovedStack.getCount()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            quickMovedSlot.onTake(player, rawStack);
        }
        ItemStack itemStack = quickMovedStack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)NanoMiraiBlocks.INSTANCE.getNANOMACHINE_ASSEMBLER()));
    }

    private final void addPlayerInventorySlots(Inventory playerInv) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.addSlot(new Slot((Container)playerInv, row, 8 + row * 18, 142));
        }
    }

    private final void addContainerSlots(ItemStackHandler container) {
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)container, 0, 124, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)container, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
    }
}

