/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.block.entity;

import com.mojang.serialization.DynamicOps;
import dev.bluesheep.nanomirai.block.SynthesizeDisplayBlock;
import dev.bluesheep.nanomirai.recipe.BlockWithPairItemInput;
import dev.bluesheep.nanomirai.recipe.synthesize.SynthesizeRecipe;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockEntities;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import dev.bluesheep.nanomirai.util.InputSingleItemHandler;
import dev.bluesheep.nanomirai.util.NanoTier;
import dev.bluesheep.nanomirai.util.SynthesizeState;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0006\u0010)\u001a\u00020\u001fJ\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,J\u0006\u0010.\u001a\u00020,J\u001e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0005J\u0018\u00103\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u00104\u001a\u00020\u001fH\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J\u0006\u00106\u001a\u000207J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u000207H\u0002J\u0014\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0<0;H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001a\u00a8\u0006?"}, d2={"Ldev/bluesheep/nanomirai/block/entity/SynthesizeDisplayBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "inputItemHandler", "Ldev/bluesheep/nanomirai/util/InputSingleItemHandler;", "getInputItemHandler", "()Ldev/bluesheep/nanomirai/util/InputSingleItemHandler;", "block", "getBlock", "()Lnet/minecraft/world/level/block/state/BlockState;", "setBlock", "(Lnet/minecraft/world/level/block/state/BlockState;)V", "progress", "", "getProgress", "()I", "setProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "drops", "setPrimaryItem", "stack", "Lnet/minecraft/world/item/ItemStack;", "setSecondaryItem", "getRecipeResult", "tick", "level", "Lnet/minecraft/world/level/Level;", "state", "spawnParticles", "startCrafting", "craftItem", "hasCraftingFinished", "", "increaseCraftingProgress", "hasRecipe", "getCurrentRecipe", "Ljava/util/Optional;", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/bluesheep/nanomirai/recipe/synthesize/SynthesizeRecipe;", "Companion", "nanomirai"})
public final class SynthesizeDisplayBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private final InputSingleItemHandler inputItemHandler;
    @NotNull
    private BlockState block;
    private int progress;
    private int maxProgress;

    public SynthesizeDisplayBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(NanoMiraiBlockEntities.INSTANCE.getSYNTHESIZE_DISPLAY(), pos, blockState);
        ItemStackHandler itemStackHandler = this.itemHandler = new ItemStackHandler(2);
        this.inputItemHandler = new InputSingleItemHandler(this, itemStackHandler){
            final /* synthetic */ SynthesizeDisplayBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super((IItemHandler)$super_call_param$1, 1);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                if (this.getItemHandler().getStackInSlot(this.getSlotId()).isEmpty()) {
                    ItemStack newStack = stack.copy();
                    ItemStack itemStack = newStack.split(1);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"split(...)");
                    this.this$0.setSecondaryItem(itemStack);
                    Intrinsics.checkNotNull((Object)newStack);
                    return newStack;
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        };
        BlockState blockState2 = Blocks.AIR.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        this.block = blockState2;
        this.maxProgress = 100;
    }

    @NotNull
    public final ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public final InputSingleItemHandler getInputItemHandler() {
        return this.inputItemHandler;
    }

    @NotNull
    public final BlockState getBlock() {
        return this.block;
    }

    public final void setBlock(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<set-?>");
        this.block = blockState;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n) {
        this.progress = n;
    }

    public final int getMaxProgress() {
        return this.maxProgress;
    }

    public final void setMaxProgress(int n) {
        this.maxProgress = n;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("items"));
        BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("block")).result().ifPresent(arg_0 -> SynthesizeDisplayBlockEntity.loadAdditional$lambda$1(arg_0 -> SynthesizeDisplayBlockEntity.loadAdditional$lambda$0(this, arg_0), arg_0));
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.put("items", (Tag)this.itemHandler.serializeNBT(registries));
        BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.block).result().ifPresent(arg_0 -> SynthesizeDisplayBlockEntity.saveAdditional$lambda$3(arg_0 -> SynthesizeDisplayBlockEntity.saveAdditional$lambda$2(tag, arg_0), arg_0));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void drops() {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.setItem(0, this.itemHandler.getStackInSlot(1));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition.above(), (Container)((Container)inventory));
    }

    public final void setPrimaryItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.itemHandler.setStackInSlot(0, stack);
        this.setChanged();
    }

    public final void setSecondaryItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.itemHandler.setStackInSlot(1, stack);
        this.startCrafting();
        this.setChanged();
    }

    @NotNull
    public final ItemStack getRecipeResult() {
        ItemStack itemStack;
        Optional<RecipeHolder<SynthesizeRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            itemStack = ((SynthesizeRecipe)recipe.get().value()).getResult();
        } else {
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNull((Object)itemStack2);
            itemStack = itemStack2;
        }
        return itemStack;
    }

    public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.itemHandler.getStackInSlot(1).isEmpty() && this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.spawnParticles(level, pos);
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem(level);
            }
        }
    }

    private final void spawnParticles(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Vec3 center = pos.getCenter();
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, center.x, center.y, center.z, 1, 0.3, 0.3, 0.3, 0.2);
        if (this.progress % 5 != 0) {
            return;
        }
        ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.itemHandler.getStackInSlot(1)), center.x, center.y, center.z, 5, 0.3, 0.3, 0.3, 0.1);
    }

    private final void startCrafting() {
        Optional<RecipeHolder<SynthesizeRecipe>> recipe = this.getCurrentRecipe();
        SynthesizeState state = SynthesizeState.INVALID;
        if (recipe.isPresent()) {
            state = SynthesizeState.CRAFTING;
            Rarity rarity = (Rarity)this.itemHandler.getStackInSlot(0).get(DataComponents.RARITY);
            if (rarity == null) {
                rarity = Rarity.COMMON;
            }
            NanoTier tier = NanoTier.Companion.fromRarity(rarity);
            this.maxProgress = (int)((double)((SynthesizeRecipe)recipe.get().value()).getDuration() / tier.getProcessingSpeedMultiplier());
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SynthesizeDisplayBlock.Companion.getSTATE(), (Comparable)((Object)state)));
        this.setChanged();
    }

    private final void craftItem(Level level) {
        ItemStack output = this.getRecipeResult().copy();
        Item outputItem = output.getItem();
        if (outputItem instanceof BlockItem) {
            v0 = level.setBlockAndUpdate(this.worldPosition, ((BlockItem)outputItem).getBlock().defaultBlockState());
        } else {
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.setItem(0, output);
            Containers.dropContents((Level)level, (BlockPos)this.worldPosition, (Container)((Container)inventory));
            v0 = level.removeBlock(this.worldPosition, false);
        }
    }

    public final boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private final void increaseCraftingProgress() {
        int n = this.progress;
        this.progress = n + 1;
    }

    private final boolean hasRecipe() {
        return this.getCurrentRecipe().isPresent();
    }

    private final Optional<RecipeHolder<SynthesizeRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            Optional<RecipeHolder<SynthesizeRecipe>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<SynthesizeRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getSYNTHESIZE();
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new BlockWithPairItemInput(this.block, itemStack, itemStack2);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Optional optional = recipeManager.getRecipeFor(recipeType, recipeInput, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        return optional;
    }

    private static final Unit loadAdditional$lambda$0(SynthesizeDisplayBlockEntity this$0, BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this$0.block = state;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit saveAdditional$lambda$2(CompoundTag $tag, Tag it) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $tag.put("block", it);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Ldev/bluesheep/nanomirai/block/entity/SynthesizeDisplayBlockEntity$Companion;", "", "<init>", "()V", "capabilityProvider", "Lnet/neoforged/neoforge/items/IItemHandler;", "blockEntity", "Ldev/bluesheep/nanomirai/block/entity/SynthesizeDisplayBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "nanomirai"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IItemHandler capabilityProvider(@NotNull SynthesizeDisplayBlockEntity blockEntity, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            Direction direction2 = direction;
            return (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) == -1 ? null : (IItemHandler)blockEntity.getInputItemHandler();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                $EnumSwitchMapping$0 = new int[Direction.values().length];
            }
        }
    }
}

