/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.block.entity;

import dev.bluesheep.nanomirai.block.LaserEngraverBlock;
import dev.bluesheep.nanomirai.recipe.DualRecipeInput;
import dev.bluesheep.nanomirai.recipe.laser.LaserRecipe;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockEntities;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import dev.bluesheep.nanomirai.util.InputSingleItemHandler;
import dev.bluesheep.nanomirai.util.OutputItemHandler;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0001BB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J\u0006\u0010.\u001a\u00020$J\u001e\u0010/\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0005J\b\u00103\u001a\u00020$H\u0002J\b\u00104\u001a\u00020$H\u0002J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u000206H\u0002J\u0014\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:H\u0002J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020\u0017H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006C"}, d2={"Ldev/bluesheep/nanomirai/block/entity/LaserEngraverBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "inputItemHandler", "Ldev/bluesheep/nanomirai/util/InputSingleItemHandler;", "getInputItemHandler", "()Ldev/bluesheep/nanomirai/util/InputSingleItemHandler;", "lensItemHandler", "getLensItemHandler", "outputItemHandler", "Ldev/bluesheep/nanomirai/util/OutputItemHandler;", "getOutputItemHandler", "()Ldev/bluesheep/nanomirai/util/OutputItemHandler;", "progress", "", "getProgress", "()I", "setProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "data", "Lnet/minecraft/world/inventory/ContainerData;", "getData", "()Lnet/minecraft/world/inventory/ContainerData;", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "drops", "tick", "level", "Lnet/minecraft/world/level/Level;", "state", "resetProgress", "craftItem", "hasCraftingFinished", "", "increaseCraftingProgress", "hasRecipe", "getCurrentRecipe", "Ljava/util/Optional;", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/bluesheep/nanomirai/recipe/laser/LaserRecipe;", "canInsertItemIntoOutputSlot", "output", "Lnet/minecraft/world/item/ItemStack;", "canInsertAmountIntoOutputSlot", "count", "Companion", "nanomirai"})
public final class LaserEngraverBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private final InputSingleItemHandler inputItemHandler;
    @NotNull
    private final InputSingleItemHandler lensItemHandler;
    @NotNull
    private final OutputItemHandler outputItemHandler;
    private int progress;
    private int maxProgress;
    @NotNull
    private final ContainerData data;
    public static final int SIZE = 3;
    public static final int OUTPUT_SLOT = 0;

    public LaserEngraverBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(NanoMiraiBlockEntities.INSTANCE.getLASER_ENGRAVER(), pos, blockState);
        this.itemHandler = new ItemStackHandler(3);
        this.inputItemHandler = new InputSingleItemHandler((IItemHandler)this.itemHandler, 1);
        this.lensItemHandler = new InputSingleItemHandler((IItemHandler)this.itemHandler, 2);
        this.outputItemHandler = new OutputItemHandler((IItemHandler)this.itemHandler, 0);
        this.maxProgress = 100;
        this.data = new ContainerData(this){
            final /* synthetic */ LaserEngraverBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> this.this$0.getProgress();
                    case 1 -> this.this$0.getMaxProgress();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        this.this$0.setProgress(value);
                        break;
                    }
                    case 1: {
                        this.this$0.setMaxProgress(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public final ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public final InputSingleItemHandler getInputItemHandler() {
        return this.inputItemHandler;
    }

    @NotNull
    public final InputSingleItemHandler getLensItemHandler() {
        return this.lensItemHandler;
    }

    @NotNull
    public final OutputItemHandler getOutputItemHandler() {
        return this.outputItemHandler;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n) {
        this.progress = n;
    }

    public final int getMaxProgress() {
        return this.maxProgress;
    }

    public final void setMaxProgress(int n) {
        this.maxProgress = n;
    }

    @NotNull
    public final ContainerData getData() {
        return this.data;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("items"));
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.put("items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        int n = inventory.getContainerSize();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)((Container)inventory));
    }

    public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.hasRecipe()) {
            if (!((Boolean)state.getValue((Property)LaserEngraverBlock.Companion.getCRAFTING())).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LaserEngraverBlock.Companion.getCRAFTING(), (Comparable)Boolean.valueOf(true)), 3);
            }
            this.increaseCraftingProgress();
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            if (((Boolean)state.getValue((Property)LaserEngraverBlock.Companion.getCRAFTING())).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LaserEngraverBlock.Companion.getCRAFTING(), (Comparable)Boolean.valueOf(false)), 3);
            }
            this.resetProgress();
        }
    }

    private final void resetProgress() {
        this.progress = 0;
        this.maxProgress = 100;
    }

    private final void craftItem() {
        Optional<RecipeHolder<LaserRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = ((LaserRecipe)recipe.get().value()).getResult();
        this.itemHandler.extractItem(1, 1, false);
        ItemStack outputStack = this.itemHandler.getStackInSlot(0);
        if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)result)) {
            outputStack.setCount(outputStack.getCount() + result.getCount());
        } else {
            this.itemHandler.setStackInSlot(0, result.copy());
        }
    }

    private final boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private final void increaseCraftingProgress() {
        int n = this.progress;
        this.progress = n + 1;
    }

    private final boolean hasRecipe() {
        Optional<RecipeHolder<LaserRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((LaserRecipe)recipe.get().value()).getResult();
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private final Optional<RecipeHolder<LaserRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            Optional<RecipeHolder<LaserRecipe>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<LaserRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getLASER();
        ItemStack itemStack = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.itemHandler.getStackInSlot(2);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new DualRecipeInput(itemStack, itemStack2);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Optional optional = recipeManager.getRecipeFor(recipeType, recipeInput, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        return optional;
    }

    private final boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.itemHandler.getStackInSlot(0).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.itemHandler.getStackInSlot(0), (ItemStack)output);
    }

    private final boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(0).isEmpty() ? 64 : this.itemHandler.getStackInSlot(0).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(0).getCount();
        return maxCount >= currentCount + count;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/bluesheep/nanomirai/block/entity/LaserEngraverBlockEntity$Companion;", "", "<init>", "()V", "SIZE", "", "OUTPUT_SLOT", "capabilityProvider", "Lnet/neoforged/neoforge/items/IItemHandler;", "blockEntity", "Ldev/bluesheep/nanomirai/block/entity/LaserEngraverBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "nanomirai"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IItemHandler capabilityProvider(@NotNull LaserEngraverBlockEntity blockEntity, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            Direction direction2 = direction;
            return switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                case -1 -> (IItemHandler)blockEntity.getItemHandler();
                case 1 -> blockEntity.getOutputItemHandler();
                case 2 -> blockEntity.getInputItemHandler();
                default -> blockEntity.getLensItemHandler();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.DOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.UP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

