/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.block;

import com.mojang.serialization.MapCodec;
import dev.bluesheep.nanomirai.block.SynthesizeDisplayBlock;
import dev.bluesheep.nanomirai.block.entity.SynthesizeDisplayBlockEntity;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockEntities;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockStates;
import dev.bluesheep.nanomirai.util.SynthesizeState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007H\u0014J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J0\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J8\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\u001a\"\b\b\u0000\u0010\u001b*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\rH\u0014\u00a8\u0006!"}, d2={"Ldev/bluesheep/nanomirai/block/SynthesizeDisplayBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "codec", "Lcom/mojang/serialization/MapCodec;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "onRemove", "level", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "Companion", "nanomirai"})
public final class SynthesizeDisplayBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<SynthesizeDisplayBlock> CODEC;
    @NotNull
    private static final EnumProperty<SynthesizeState> STATE;

    public SynthesizeDisplayBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STATE, (Comparable)((Object)SynthesizeState.IDLE)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{STATE};
        builder.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new SynthesizeDisplayBlockEntity(pos, state);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!Intrinsics.areEqual((Object)state.getBlock(), (Object)newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof SynthesizeDisplayBlockEntity && !((SynthesizeDisplayBlockEntity)blockEntity).hasCraftingFinished()) {
            ((SynthesizeDisplayBlockEntity)blockEntity).drops();
            level.setBlockAndUpdate(pos, ((SynthesizeDisplayBlockEntity)blockEntity).getBlock());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        if (level.isClientSide) {
            return null;
        }
        return BaseEntityBlock.createTickerHelper(blockEntityType, NanoMiraiBlockEntities.INSTANCE.getSYNTHESIZE_DISPLAY(), (BlockEntityTicker)getTicker.1.INSTANCE);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(SynthesizeDisplayBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        STATE = NanoMiraiBlockStates.INSTANCE.getSYNTHESIZE_STATE();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/bluesheep/nanomirai/block/SynthesizeDisplayBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/bluesheep/nanomirai/block/SynthesizeDisplayBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STATE", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Ldev/bluesheep/nanomirai/util/SynthesizeState;", "getSTATE", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "nanomirai"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SynthesizeDisplayBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final EnumProperty<SynthesizeState> getSTATE() {
            return STATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

