/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.kubejs;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.strainers.recipe.MeshChanceResult;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MeshChanceResultComponent
implements RecipeComponent<MeshChanceResult> {
    public static final MeshChanceResultComponent MESH_CHANCE_RESULT = new MeshChanceResultComponent();
    public static final RecipeComponentType<?> CONDITION = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"mesh_chance_result"), (RecipeComponent)MESH_CHANCE_RESULT);

    public RecipeComponentType<?> type() {
        return CONDITION;
    }

    public Codec<MeshChanceResult> codec() {
        return MeshChanceResult.CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.OBJECT;
    }

    public MeshChanceResult wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof MeshChanceResult) {
            MeshChanceResult mcr = (MeshChanceResult)from;
            return mcr;
        }
        if (from instanceof NativeArray) {
            NativeArray arr = (NativeArray)from;
            if (arr.getLength() < 1L) {
                throw new IllegalArgumentException("MeshChanceResult array must have at least 1 element (item)");
            }
            ItemStack stack = this.parseCountedItemString(String.valueOf(arr.get(0)));
            float chance = arr.getLength() > 1L ? Float.parseFloat(String.valueOf(arr.get(1))) : 1.0f;
            Ingredient mesh = arr.getLength() > 2L ? this.parseMeshObject(arr.get(2)) : Ingredient.EMPTY;
            return new MeshChanceResult(new ChanceResult(stack, chance), mesh);
        }
        if (from instanceof NativeObject) {
            ItemStack stack;
            NativeObject obj = (NativeObject)from;
            Object itemObj = obj.get((Object)"item");
            Object chanceObj = obj.get((Object)"chance");
            Object countAtTopLevel = obj.get((Object)"count");
            Object meshObj = obj.get((Object)"mesh");
            if (itemObj == null) {
                throw new IllegalArgumentException("MeshChanceResult missing 'item' field");
            }
            if (itemObj instanceof String) {
                String itemStr = (String)itemObj;
                stack = this.parseCountedItemString(itemStr);
                if (countAtTopLevel != null) {
                    stack.setCount((int)Double.parseDouble(String.valueOf(countAtTopLevel)));
                }
            } else if (itemObj instanceof NativeObject) {
                NativeObject itemNativeObj = (NativeObject)itemObj;
                String idStr = String.valueOf(itemNativeObj.get((Object)"id"));
                int count = itemNativeObj.get((Object)"count") != null ? (int)Double.parseDouble(String.valueOf(itemNativeObj.get((Object)"count"))) : 1;
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)idStr));
                if (item == null) {
                    throw new IllegalArgumentException("Invalid item ID: " + idStr);
                }
                stack = new ItemStack((ItemLike)item, count);
            } else {
                throw new IllegalArgumentException("Invalid 'item' field type: " + String.valueOf(itemObj.getClass()));
            }
            float chance = chanceObj != null ? Float.parseFloat(String.valueOf(chanceObj)) : 1.0f;
            Ingredient mesh = meshObj != null ? this.parseMeshObject(meshObj) : Ingredient.EMPTY;
            return new MeshChanceResult(new ChanceResult(stack, chance), mesh);
        }
        if (from instanceof String) {
            String s = (String)from;
            ItemStack stack = this.parseCountedItemString(s);
            return new MeshChanceResult(new ChanceResult(stack, 1.0f), Ingredient.EMPTY);
        }
        throw new IllegalArgumentException("Cannot convert object to MeshChanceResult: " + String.valueOf(from));
    }

    private ItemStack parseCountedItemString(String input) {
        if ((input = input.trim()).matches("^\\d+x\\s+.+$")) {
            String[] parts = input.split("\\s+", 2);
            int count = Integer.parseInt(parts[0].replace("x", ""));
            String itemId = parts[1];
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
            if (item == null) {
                throw new IllegalArgumentException("Invalid item ID: " + itemId);
            }
            return new ItemStack((ItemLike)item, count);
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)input));
        if (item == null) {
            throw new IllegalArgumentException("Invalid item ID: " + input);
        }
        return new ItemStack((ItemLike)item);
    }

    private Ingredient parseMeshObject(Object meshObj) {
        if (meshObj instanceof String) {
            String meshStr = (String)meshObj;
            if ((meshStr = meshStr.trim()).startsWith("#")) {
                return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)meshStr.substring(1))));
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)meshStr));
            if (item == null) {
                throw new IllegalArgumentException("Invalid mesh item: " + meshStr);
            }
            return Ingredient.of((ItemLike[])new ItemLike[]{item});
        }
        if (meshObj instanceof NativeArray) {
            NativeArray arr = (NativeArray)meshObj;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (Object o : arr) {
                if (!(o instanceof String)) continue;
                String s = (String)o;
                ingredients.add(this.parseMeshObject(s));
            }
            ItemStack[] stacks = (ItemStack[])ingredients.stream().flatMap(i -> Arrays.stream(i.getItems())).toArray(ItemStack[]::new);
            return Ingredient.of((ItemStack[])stacks);
        }
        return Ingredient.EMPTY;
    }
}

