/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.client.rendering.ClientTransformationUtils;
import io.wispforest.accessories.api.client.rendering.CustomDataRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.client.ClientDelayedCache;
import io.wispforest.accessories.data.CustomRendererLoader;
import java.lang.ref.SoftReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Experimental
public class ClientRenderingUtils {
    private static final ClientDelayedCache<ParticleTimeKey> PARTICLE_UPDATE_CACHE = new ClientDelayedCache();
    private static final Map<EntityType, EntityData> ENTITY_CACHE = new HashMap<EntityType, EntityData>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handle(ItemStack stack, LivingEntity targetEntity, @Nullable HumanoidArm arm, EntityModel<? extends LivingEntity> entityModel, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        ClientRenderingUtils.handle(ItemStack.hashItemAndComponents((ItemStack)stack), targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, functions);
    }

    public static void handle(int uniqueKey, LivingEntity targetEntity, @Nullable HumanoidArm arm, EntityModel<? extends LivingEntity> entityModel, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = Minecraft.getInstance().level;
        block12: for (RenderingFunction function : functions) {
            RenderingFunction renderingFunction;
            Objects.requireNonNull(function);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformation.class, RenderingFunction.Block.class, RenderingFunction.Entity.class, RenderingFunction.Item.class, RenderingFunction.Model.class, RenderingFunction.Particle.class, RenderingFunction.Compound.class, CustomDataRenderer.class}, (Object)renderingFunction, n)) {
                case 0: {
                    RenderingFunction.Transformation transformation = (RenderingFunction.Transformation)renderingFunction;
                    ClientTransformationUtils.transformStack(transformation.transformations(), poseStack, targetEntity, entityModel, () -> ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, List.of(transformation.renderingFunction())));
                    break;
                }
                case 1: {
                    RenderingFunction.Block blockData = (RenderingFunction.Block)renderingFunction;
                    BlockState state = blockData.state();
                    BlockEntity blockEntity = blockData.type() != null ? BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)blockData.state(), (CompoundTag)blockData.data(), (HolderLookup.Provider)level.registryAccess()) : null;
                    poseStack.pushPose();
                    poseStack.translate(-0.5, 0.0, -0.5);
                    ClientRenderingUtils.renderBlock(client, state, blockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay, color);
                    poseStack.popPose();
                    break;
                }
                case 2: {
                    RenderingFunction.Entity entityData = (RenderingFunction.Entity)renderingFunction;
                    try {
                        Entity entity;
                        EntityData currentEntityData = ENTITY_CACHE.computeIfAbsent(entityData.entityType(), entityType -> {
                            Entity entity = entityData.entityType().create((Level)level);
                            if (entity != null) {
                                CompoundTag defaultData = entity.saveWithoutId(new CompoundTag());
                                return new EntityData(new SoftReference<Entity>(entity), defaultData, true);
                            }
                            return new EntityData(null, new CompoundTag(), false);
                        });
                        if (!currentEntityData.wasSpawnable()) continue block12;
                        if (!currentEntityData.canBeGotten()) {
                            currentEntityData.createNewReference(entityData.entityType(), (Level)level);
                        }
                        if (!currentEntityData.wasSpawnable() || (entity = currentEntityData.reference().get()) == null) continue block12;
                        boolean customData = false;
                        if (!entityData.data().isEmpty()) {
                            customData = true;
                            entity.load(entityData.data());
                        }
                        if (entityData.allowTicking() || entity instanceof Display) {
                            entity.tick();
                        }
                        client.getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, buffer, packedLight);
                        if (!customData) continue block12;
                        currentEntityData.resetEntity();
                        break;
                    }
                    catch (Exception e) {
                        continue block12;
                    }
                }
                case 3: {
                    RenderingFunction.Item itemData = (RenderingFunction.Item)renderingFunction;
                    ItemStack stack = itemData.stack();
                    client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, poseStack, buffer, packedLight, packedOverlay, client.getItemRenderer().getModel(stack, (Level)level, null, 0));
                    break;
                }
                case 4: {
                    RenderingFunction.Model modelData = (RenderingFunction.Model)renderingFunction;
                    BakedModel model = Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(modelData.id(), modelData.variant()));
                    client.getItemRenderer().render(Items.BEDROCK.getDefaultInstance(), ItemDisplayContext.GROUND, false, poseStack, buffer, packedLight, packedOverlay, model);
                    break;
                }
                case 5: {
                    RenderingFunction.Particle particleData = (RenderingFunction.Particle)renderingFunction;
                    if (!PARTICLE_UPDATE_CACHE.hasAllottedTime(new ParticleTimeKey(targetEntity.getUUID(), uniqueKey, particleData), particleData.delay())) continue block12;
                    Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)poseStack.last().pose()).add((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f());
                    ClientRenderingUtils.renderParticle((Level)level, particleData, pos.x(), pos.y(), pos.z());
                    break;
                }
                case 6: {
                    RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction;
                    if (arm != null && !compoundFunction.firstPersonArmTarget().hasArm(arm)) continue block12;
                    ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, compoundFunction.renderingFunctions());
                    break;
                }
                case 7: {
                    CustomDataRenderer renderer = (CustomDataRenderer)renderingFunction;
                    RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                    if (renderFunction == null) continue block12;
                    ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, List.of(renderFunction));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented RendererFunc: " + function.key());
                }
            }
        }
    }

    private static void renderParticle(Level level, RenderingFunction.Particle particle, double x, double y, double z) {
        RandomSource random = level.getRandom();
        try {
            if (particle.count() == 0) {
                double xSpd = particle.speed() * particle.delta().x();
                double ySpd = particle.speed() * particle.delta().y();
                double zSpd = particle.speed() * particle.delta().z();
                level.addParticle(particle.particleData(), particle.force(), x, y, z, xSpd, ySpd, zSpd);
            } else {
                for (int i = 0; i < particle.count(); ++i) {
                    double g = random.nextGaussian() * (double)particle.delta().x();
                    double h = random.nextGaussian() * (double)particle.delta().y();
                    double j = random.nextGaussian() * (double)particle.delta().z();
                    double k = random.nextGaussian() * (double)particle.speed();
                    double l = random.nextGaussian() * (double)particle.speed();
                    double m = random.nextGaussian() * (double)particle.speed();
                    level.addParticle(particle.particleData(), particle.force(), x + g, y + h, z + j, k, l, m);
                }
            }
        }
        catch (Throwable var16) {
            LOGGER.warn("Could not spawn particle effect {}", (Object)particle.particleData());
        }
    }

    private static void renderBlock(Minecraft client, BlockState state, @Nullable BlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, int color) {
        RenderSystem.runAsFancy(() -> {
            BlockEntityRenderer \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
            if (state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                client.getBlockRenderer().renderSingleBlock(state, poseStack, buffer, packedLight, packedOverlay);
            }
            if (blockEntity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = client.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                \u043c\u0435\u0434\u0432\u0435\u0434\u044c.render(blockEntity, partialTick, poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        });
    }

    private static final class EntityData {
        private final CompoundTag defaultData;
        @Nullable
        private SoftReference<Entity> reference;
        private boolean wasSpawnable;

        private EntityData(@Nullable SoftReference<Entity> reference, CompoundTag defaultData, boolean wasSpawnable) {
            this.reference = reference;
            this.defaultData = defaultData;
            this.wasSpawnable = wasSpawnable;
        }

        private boolean canBeGotten() {
            return this.reference != null && this.reference.get() != null;
        }

        @Nullable
        public SoftReference<Entity> reference() {
            return this.reference;
        }

        public void resetEntity() {
            if (this.reference == null) {
                return;
            }
            Entity entity = this.reference.get();
            if (entity == null) {
                return;
            }
            try {
                entity.load(this.defaultData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void createNewReference(EntityType type, Level level) {
            Entity entity = type.create(level);
            if (entity == null) {
                this.wasSpawnable = false;
                return;
            }
            this.reference = new SoftReference<Entity>(entity);
        }

        public CompoundTag defaultData() {
            return this.defaultData;
        }

        public boolean wasSpawnable() {
            return this.wasSpawnable;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EntityData that = (EntityData)obj;
            return Objects.equals(this.reference, that.reference) && Objects.equals(this.defaultData, that.defaultData) && this.wasSpawnable == that.wasSpawnable;
        }

        public int hashCode() {
            return Objects.hash(this.reference, this.defaultData, this.wasSpawnable);
        }

        public String toString() {
            return "EntityData[reference=" + String.valueOf(this.reference) + ", defaultData=" + String.valueOf(this.defaultData) + ", wasSpawnable=" + this.wasSpawnable + "]";
        }
    }

    private record ParticleTimeKey(UUID entityUUID, int uniqueKey, RenderingFunction.Particle particleData) {
    }
}

