/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.base.CaseFormat;
import io.wispforest.accessories.api.client.ModelTarget;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public sealed interface Transformation {
    public static final Endec<Transformation> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "translation" -> Translation.ENDEC;
        case "raw_rotation" -> RawRotation.ENDEC;
        case "axis_rotation" -> AxisRotation.ENDEC;
        case "scale" -> Scale.ENDEC;
        case "transform_to" -> TransformTo.ENDEC;
        case "matrix" -> Matrix.ENDEC;
        default -> throw new IllegalStateException("A invalid transform was created meaning such is unable to be decoded!");
    }, Transformation::key, (Endec)Endec.STRING, (String)"type");

    public static Transformation translation(float x, float y, float z) {
        return Transformation.translation(new Vector3f(x, y, z));
    }

    public static Transformation translation(Vector3f translation) {
        return new Translation(translation);
    }

    public static Transformation rawRotation(Quaternionf rotation) {
        return new RawRotation(rotation);
    }

    public static Transformation axisRotation(float angle, Side side) {
        Vec3i axis = side.rotationAxis();
        return Transformation.axisRotation(new AxisAngle4f(angle, (float)axis.getX(), (float)axis.getY(), (float)axis.getZ()));
    }

    public static Transformation axisRotation(float angle, float x, float y, float z) {
        return Transformation.axisRotation(new AxisAngle4f(angle, x, y, z));
    }

    public static Transformation axisRotation(AxisAngle4f rotation) {
        return new AxisRotation(rotation);
    }

    public static Transformation scale(float x, float y, float z) {
        return Transformation.scale(new Vector3f(x, y, z));
    }

    public static Transformation scale(Vector3f scale) {
        return new Scale(scale);
    }

    public static Transformation modelTarget(String modelPart, @Nullable Vector3f rawNormal) {
        return Transformation.modelTarget(new ModelTarget(modelPart, rawNormal, null));
    }

    public static Transformation modelTarget(String modelPart, @Nullable Side side) {
        return Transformation.modelTarget(new ModelTarget(modelPart, null, side));
    }

    public static Transformation modelTarget(ModelTarget target) {
        return new TransformTo(target);
    }

    public static Transformation matrix(Matrix4f matrix4f) {
        return new Matrix(matrix4f);
    }

    default public String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    public record Translation(Vector3f translation) implements Transformation
    {
        public static final StructEndec<Translation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Translation::translation), Translation::new);
    }

    public record RawRotation(Quaternionf quarternionf) implements Transformation
    {
        public static final StructEndec<RawRotation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.QUATERNIONF_COMPONENTS.flatFieldOf(RawRotation::quarternionf), RawRotation::new);
    }

    public record AxisRotation(AxisAngle4f axisAngle4f) implements Transformation
    {
        public static final StructEndec<AxisRotation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.AXISANGLE4F.flatFieldOf(AxisRotation::axisAngle4f), AxisRotation::new);
    }

    public record Scale(Vector3f scale) implements Transformation
    {
        public static final StructEndec<Scale> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Scale::scale), Scale::new);
    }

    public record TransformTo(ModelTarget target) implements Transformation
    {
        public static final StructEndec<TransformTo> ENDEC = StructEndecBuilder.of((StructField)ModelTarget.ENDEC.flatFieldOf(TransformTo::target), TransformTo::new);
    }

    public record Matrix(Matrix4f matrix4f) implements Transformation
    {
        public static final StructEndec<Matrix> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.MATRIX4F.fieldOf("value", Matrix::matrix4f), Matrix::new);
    }
}

