/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.client.AccessoryArmorRenderer;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.ArmorRenderingExtension;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.EmptyRenderer;
import io.wispforest.accessories.api.client.WrappedAccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.ClientRenderingUtils;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesRendererRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<ResourceLocation, Supplier<AccessoryRenderer>>();
    private static final BiMap<ResourceLocation, AccessoryRenderer> CACHED_RENDERERS = HashBiMap.create();

    public static void registerRenderer(ResourceLocation location, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(location, renderer);
    }

    public static void registerRenderer(Item item, Supplier<@NotNull AccessoryRenderer> renderer) {
        AccessoriesRendererRegistry.registerRenderer(AccessoriesRendererRegistry.getRendererId(item), renderer);
    }

    public static void registerNoRenderer(Item item) {
        AccessoriesRendererRegistry.registerRenderer(item, EmptyRenderer::new);
    }

    public static void registerArmorRendering(Item item) {
        if (item instanceof Equipable && !AccessoriesRendererRegistry.hasRenderer(item)) {
            AccessoriesRendererRegistry.registerRenderer(item, () -> new AccessoryArmorRenderer(){});
        }
    }

    public static boolean hasRenderer(Item item) {
        return AccessoriesRendererRegistry.hasRenderer(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static boolean hasRenderer(ResourceLocation rendererId) {
        return RENDERERS.containsKey(rendererId);
    }

    public static AccessoryRenderer getRenderer(ItemStack stack) {
        boolean armorRenderOverride;
        if (stack.has(AccessoriesDataComponents.CUSTOM_RENDERER) && !stack.is(Items.BUNDLE)) {
            return DataDrivenAccessoryRenderer.INSTANCE;
        }
        AccessoryRenderOverrideComponent renderOverrides = (AccessoryRenderOverrideComponent)stack.getOrDefault(AccessoriesDataComponents.RENDER_OVERRIDE, (Object)AccessoryRenderOverrideComponent.DEFAULT);
        Boolean defaultRenderOverride = renderOverrides.defaultRenderOverride();
        if (defaultRenderOverride != null) {
            if (defaultRenderOverride.booleanValue()) {
                return DefaultAccessoryRenderer.INSTANCE;
            }
            if (AccessoriesAPI.isDefaultAccessory(AccessoriesAPI.getOrDefaultAccessory(stack))) {
                return new EmptyRenderer();
            }
        }
        if (armorRenderOverride = renderOverrides.useArmorRenderer()) {
            return ArmorRenderingExtension.RENDERER;
        }
        return AccessoriesRendererRegistry.getRenderer(stack.getItem());
    }

    public static AccessoryRenderer getRenderer(Item item) {
        ResourceLocation id = AccessoriesRendererRegistry.getRendererId(item);
        AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(id);
        if (!CACHED_RENDERERS.containsKey((Object)id)) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        if (renderer instanceof EmptyRenderer && Accessories.config().clientOptions.forceNullRenderReplacement()) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        return renderer == null ? new EmptyRenderer() : renderer;
    }

    @Nullable
    public static AccessoryRenderer getRenderer(ResourceLocation rendererId) {
        return (AccessoryRenderer)CACHED_RENDERERS.get((Object)rendererId);
    }

    @Nullable
    public static ResourceLocation getRendererId(AccessoryRenderer renderer) {
        return (ResourceLocation)CACHED_RENDERERS.inverse().get((Object)renderer);
    }

    public static ResourceLocation getRendererId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @ApiStatus.Internal
    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((rendererId, supplier) -> {
            ResourceLocation otherRendererId;
            AccessoryRenderer renderer = (AccessoryRenderer)supplier.get();
            if (renderer == null) {
                LOGGER.warn("A given renderer [{}] was found to be returning a null renderer which is not advised as method to indicate no rendering!", rendererId);
                renderer = new EmptyRenderer();
            }
            if ((otherRendererId = (ResourceLocation)CACHED_RENDERERS.inverse().get((Object)renderer)) != null) {
                LOGGER.warn("A given renderer [{}] was found to be shared by another renderer [{}], such will be wrapped to prevent crashing and should be reported!", rendererId, (Object)otherRendererId);
                renderer = new WrappedAccessoryRenderer(renderer);
            }
            CACHED_RENDERERS.put(rendererId, (Object)renderer);
        });
    }

    @Deprecated(forRemoval=true)
    public static AccessoryRenderer getRender(ItemStack stack) {
        return AccessoriesRendererRegistry.getRenderer(stack);
    }

    @Deprecated(forRemoval=true)
    public static AccessoryRenderer getRender(Item item) {
        return AccessoriesRendererRegistry.getRenderer(item);
    }

    static {
        AccessoriesRendererRegistry.registerRenderer(Items.BUNDLE, BundleAccessoryRenderer::new);
    }

    @ApiStatus.Internal
    public static class DataDrivenAccessoryRenderer
    implements AccessoryRenderer {
        public static final DataDrivenAccessoryRenderer INSTANCE = new DataDrivenAccessoryRenderer();

        @Override
        public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.get(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null) {
                return;
            }
            ClientRenderingUtils.handle(stack, reference.entity(), null, model, matrices, multiBufferSource, partialTicks, 0xF000F0, OverlayTexture.NO_OVERLAY, -1, data.renderingFunctions());
        }

        @Override
        public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.get(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null) {
                return;
            }
            LivingEntity targetEntity = reference.entity();
            TickRateManager tickRateManager = targetEntity.level().tickRateManager();
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(!tickRateManager.isEntityFrozen((Entity)targetEntity));
            ClientRenderingUtils.handle(stack, targetEntity, arm, model, matrices, multiBufferSource, partialTicks, 0xF000F0, OverlayTexture.NO_OVERLAY, -1, data.renderingFunctions());
        }

        @Override
        public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
            return true;
        }
    }

    @ApiStatus.Internal
    private static class BundleAccessoryRenderer
    implements AccessoryRenderer {
        private BundleAccessoryRenderer() {
        }

        @Override
        public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
            if (contents == null) {
                return;
            }
            DataDrivenAccessoryRenderer.INSTANCE.render(stack, reference, matrices, model, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            Iterable iterable = contents.items();
            if (iterable instanceof List) {
                List list = (List)iterable;
                for (int i = 0; i < list.size(); ++i) {
                    AccessoryRenderer renderer;
                    ItemStack innerStack = (ItemStack)list.get(i);
                    if (innerStack.isEmpty() || (renderer = AccessoriesRendererRegistry.getRenderer(innerStack)).isEmpty()) continue;
                    matrices.pushPose();
                    try {
                        renderer.render(innerStack, AccessoryNestUtils.create(reference, i), matrices, model, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("[BundleAccessoryRenderer] Unable to render a given inner item stack due the following error: ", e);
                    }
                    matrices.popPose();
                }
            }
        }

        @Override
        public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
            BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
            if (contents == null) {
                return;
            }
            DataDrivenAccessoryRenderer.INSTANCE.renderOnFirstPerson(arm, stack, reference, matrices, model, multiBufferSource, light);
            Iterable iterable = contents.items();
            if (iterable instanceof List) {
                List list = (List)iterable;
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack innerStack = (ItemStack)list.get(i);
                    if (innerStack.isEmpty()) continue;
                    AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
                    SlotReference ref = AccessoryNestUtils.create(reference, i);
                    if (renderer.isEmpty() || !renderer.shouldRenderInFirstPerson(arm, innerStack, ref)) continue;
                    matrices.pushPose();
                    try {
                        renderer.renderOnFirstPerson(arm, innerStack, ref, matrices, model, multiBufferSource, light);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("[BundleAccessoryRenderer] Unable to render a given inner item stack due the following error: ", e);
                    }
                    matrices.popPose();
                }
            }
        }
    }
}

