/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.util;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.util.ResourceType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ResourceTypeLoader
extends SimpleJsonResourceReloadListener {
    public ICondition.IContext context;

    public ResourceTypeLoader(Gson gson, String directory) {
        super(gson, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        ResourceType.REGISTRY.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject obj = entry.getValue().getAsJsonObject();
            try {
                ConditionalOps ops = this.makeConditionalOps();
                boolean willLoad = ICondition.conditionsMatched((DynamicOps)ops, (Object)obj);
                if (!willLoad) {
                    System.out.println("Skipping ResourceType " + String.valueOf(id) + " due to conditions not met.");
                    continue;
                }
                if (!obj.has("main_color")) {
                    throw new IllegalArgumentException("Missing 'main_color' for " + String.valueOf(id));
                }
                int mainColor = (int)Long.decode(this.fixColorHex(obj.get("main_color").getAsString())).longValue();
                if (!obj.has("pattern_color")) {
                    throw new IllegalArgumentException("Missing 'pattern_color' for " + String.valueOf(id));
                }
                int patternColor = (int)Long.decode(this.fixColorHex(obj.get("pattern_color").getAsString())).longValue();
                if (!obj.has("drop_items")) {
                    throw new IllegalArgumentException("Missing 'drop_items' for " + String.valueOf(id));
                }
                DataResult dropsResult = ChanceResult.CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("drop_items"));
                List dropItems = (List)dropsResult.result().orElseThrow(() -> new IllegalArgumentException("Invalid drop_items for " + String.valueOf(id) + ": " + dropsResult.error().map(err -> err.message()).orElse("Unknown error")));
                int dropIntervalTicks = obj.has("drop_interval") ? obj.get("drop_interval").getAsInt() : 600;
                ArrayList<ResourceFishEntity.Pattern> patterns = new ArrayList<ResourceFishEntity.Pattern>();
                if (obj.has("patterns")) {
                    for (Object pat : obj.getAsJsonArray("patterns")) {
                        try {
                            patterns.add(ResourceFishEntity.Pattern.valueOf(pat.getAsString().toUpperCase()));
                        }
                        catch (Exception e) {
                            System.out.println("Invalid pattern for " + String.valueOf(id) + ": " + pat.getAsString());
                        }
                    }
                }
                ArrayList<ResourceFishEntity.Pattern.Base> models = new ArrayList<ResourceFishEntity.Pattern.Base>();
                if (obj.has("models")) {
                    Object pat;
                    pat = obj.getAsJsonArray("models").iterator();
                    while (pat.hasNext()) {
                        JsonElement model = (JsonElement)pat.next();
                        try {
                            models.add(ResourceFishEntity.Pattern.Base.valueOf(model.getAsString().toUpperCase()));
                        }
                        catch (Exception e) {
                            System.out.println("Invalid model for " + String.valueOf(id) + ": " + model.getAsString());
                        }
                    }
                }
                ArrayList<String> biomes = new ArrayList<String>();
                if (obj.has("biomes")) {
                    for (JsonElement b : obj.getAsJsonArray("biomes")) {
                        biomes.add(b.getAsString());
                    }
                }
                ResourceType.register(new ResourceType(id, mainColor, patternColor, dropItems, dropIntervalTicks, patterns, models, biomes));
                System.out.println("Loaded ResourceType " + String.valueOf(id));
            }
            catch (Exception e) {
                System.out.println("Failed to load ResourceType " + String.valueOf(id) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.println("Loaded " + ResourceType.REGISTRY.size() + " ResourceTypes");
    }

    private String fixColorHex(String hex) {
        if (!(hex.startsWith("#") || hex.startsWith("0x") || hex.startsWith("0X"))) {
            return "0x" + hex;
        }
        return hex;
    }
}

