/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ResourceTypeContext
implements ICondition.IContext {
    private final RegistryAccess registryAccess;

    public ResourceTypeContext(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
    }

    public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registryKey) {
        Registry registry = this.registryAccess.registryOrThrow(registryKey);
        return registry.getTags().collect(Collectors.toMap(pair -> ((TagKey)pair.getFirst()).location(), pair -> ((HolderSet.Named)pair.getSecond()).stream().collect(Collectors.toList())));
    }

    public <T> Collection<Holder<T>> getTag(TagKey<T> key) {
        return this.registryAccess.registryOrThrow(key.registry()).getTag(key).map(tagSet -> tagSet.stream().collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

