/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.util;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.network.BiggerStreamCodec;
import com.benbenlaw.resourcefish.network.packets.SyncResourceTypesToClient;
import com.benbenlaw.resourcefish.util.ChanceResultStreamCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ResourceType {
    public static final Map<ResourceLocation, ResourceType> REGISTRY = new HashMap<ResourceLocation, ResourceType>();
    private static final List<ChanceResult> EMPTY_DROP_ITEMS = new ArrayList<ChanceResult>();
    private final List<ResourceFishEntity.Pattern> patterns;
    private final List<ResourceFishEntity.Pattern.Base> models;
    private final List<String> biomes;
    public static final ResourceType NONE = new ResourceType(ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"none"), 0xFFFFFF, 0, EMPTY_DROP_ITEMS, 600, List.of(), List.of(), List.of());
    private final ResourceLocation id;
    private final int mainColor;
    private final int patternColor;
    private List<ChanceResult> dropItems;
    private final int dropIntervalTicks;
    public static final Codec<ResourceType> CODEC = RecordCodecBuilder.create(resourceTypeInstance -> resourceTypeInstance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ResourceType::getId), (App)Codec.INT.fieldOf("main_color").forGetter(ResourceType::getColor), (App)Codec.INT.fieldOf("pattern_color").forGetter(ResourceType::getPatternColor), (App)ChanceResult.CODEC.listOf().fieldOf("drop_items").forGetter(ResourceType::getDropItems), (App)Codec.INT.fieldOf("drop_interval_ticks").forGetter(ResourceType::getDropIntervalTicks), (App)ResourceFishEntity.Pattern.CODEC.listOf().fieldOf("patterns").forGetter(ResourceType::getPatterns), (App)ResourceFishEntity.Pattern.Base.CODEC.listOf().fieldOf("models").forGetter(ResourceType::getModels), (App)Codec.STRING.listOf().fieldOf("biomes").forGetter(ResourceType::getBiomes)).apply((Applicative)resourceTypeInstance, ResourceType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceType> STREAM_CODEC = BiggerStreamCodec.composite(ResourceLocation.STREAM_CODEC, ResourceType::getId, ByteBufCodecs.INT, ResourceType::getColor, ByteBufCodecs.INT, ResourceType::getPatternColor, ChanceResultStreamCodec.STREAM_CODEC.apply(ByteBufCodecs.list()), ResourceType::getDropItems, ByteBufCodecs.INT, ResourceType::getDropIntervalTicks, ResourceFishEntity.Pattern.STREAM_CODEC.apply(ByteBufCodecs.list()), ResourceType::getPatterns, ResourceFishEntity.Pattern.Base.STREAM_CODEC.apply(ByteBufCodecs.list()), ResourceType::getModels, ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), ResourceType::getBiomes, ResourceType::new);

    public static void clear() {
        REGISTRY.clear();
    }

    public ResourceType(ResourceLocation id, int mainColor, int patternColor, List<ChanceResult> dropItems, int dropIntervalTicks, List<ResourceFishEntity.Pattern> patterns, List<ResourceFishEntity.Pattern.Base> models, List<String> biomes) {
        this.id = id;
        this.mainColor = mainColor;
        this.patternColor = patternColor;
        this.dropItems = dropItems;
        this.dropIntervalTicks = dropIntervalTicks;
        this.patterns = patterns;
        this.models = models;
        this.biomes = biomes;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getColor() {
        return this.mainColor;
    }

    public int getPatternColor() {
        return this.patternColor;
    }

    public List<ChanceResult> getDropItems() {
        return this.dropItems;
    }

    public List<ItemStack> getResults() {
        return this.getRollResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public List<ResourceFishEntity.Pattern> getPatterns() {
        return this.patterns;
    }

    public List<ResourceFishEntity.Pattern.Base> getModels() {
        return this.models;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public List<ChanceResult> getRollResults() {
        return this.dropItems;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ChanceResult output : this.getRollResults()) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public int getDropIntervalTicks() {
        return this.dropIntervalTicks;
    }

    public static void register(ResourceType type) {
        REGISTRY.put(type.getId(), type);
    }

    public static ResourceType get(ResourceLocation id) {
        return REGISTRY.getOrDefault(id, REGISTRY.get(ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"none")));
    }

    public static Collection<ResourceType> getAll() {
        return REGISTRY.values();
    }

    public static void sendResourceTypes(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncResourceTypesToClient(REGISTRY.values().stream().toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

