/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.screen;

import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.resourcefish.screen.TankControllerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class TankControllerScreen
extends AbstractContainerScreen<TankControllerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/gui/tank_controller.png");

    public TankControllerScreen(TankControllerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 165;
        this.imageWidth = 175;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((TankControllerMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 67, y + 16, 176, 0, ((TankControllerMenu)this.menu).getScaledProgress(), 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderFishInformation(guiGraphics, mouseX, mouseY);
    }

    public void renderFishInformation(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.literal((String)(((TankControllerMenu)this.menu).data.get(2) + " / " + ((TankControllerMenu)this.menu).data.get(3))), this.leftPos + 9, this.topPos + 39, 0x3F3F3F, false);
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)(this.leftPos + 7), (int)(this.topPos + 34), (int)0, (int)0, (int)72, (int)18)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (((TankControllerMenu)this.menu).data.get(2) > ((TankControllerMenu)this.menu).data.get(3)) {
                tooltip.add(Component.translatable((String)"screen.resourcefish.tank_controller.overfilled").withStyle(ChatFormatting.RED));
            } else {
                tooltip.add(Component.translatable((String)"screen.resourcefish.tank_controller.fish_types").withStyle(ChatFormatting.YELLOW));
                for (String name : ((TankControllerMenu)this.menu).blockEntity.fishNames) {
                    tooltip.add(Component.literal((String)("- " + name)).withStyle(ChatFormatting.GRAY));
                }
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

