/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.screen;

import com.benbenlaw.core.screen.util.CoreSlotTextures;
import com.benbenlaw.core.screen.util.slot.CoreSlot;
import com.benbenlaw.core.screen.util.slot.ResultSlot;
import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.block.entity.TankControllerBlockEntity;
import com.benbenlaw.resourcefish.screen.ResourceFishMenuTypes;
import com.benbenlaw.resourcefish.util.ResourceFishTags;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TankControllerMenu
extends AbstractContainerMenu {
    protected TankControllerBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    public int numberOfCatalysts = 0;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 19;

    public TankControllerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(4));
    }

    public TankControllerMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)ResourceFishMenuTypes.TANK_CONTROLLER_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.blockEntity = (TankControllerBlockEntity)this.level.getBlockEntity(blockPos);
        this.data = data;
        TankControllerBlockEntity entity = (TankControllerBlockEntity)this.level.getBlockEntity(blockPos);
        TankControllerMenu.checkContainerSize((Container)inventory, (int)19);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        assert (entity != null);
        int slotCount = 0;
        int xStart = 98;
        int yStart = 17;
        int xOffset = 18;
        int yOffset = 18;
        int rows = 3;
        int columns = 4;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int xPos = xStart + col * xOffset;
                int yPos = yStart + row * yOffset;
                this.addSlot((Slot)new ResultSlot((IItemHandler)this.blockEntity.getItemStackHandler(), slotCount++, xPos, yPos, 64));
            }
        }
        this.createRecipeSlot(entity, 12, 8, 17);
        this.createRecipeSlot(entity, 13, 26, 17);
        this.createRecipeSlot(entity, 14, 44, 17);
        this.createUpgradeSlot(entity, 15, 8, 53);
        this.createUpgradeSlot(entity, 16, 26, 53);
        this.createUpgradeSlot(entity, 17, 44, 53);
        this.createUpgradeSlot(entity, 18, 62, 53);
        this.addDataSlots(data);
    }

    private void createUpgradeSlot(TankControllerBlockEntity entity, int slot, int x, int y) {
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)entity.getItemStackHandler(), slot, x, y){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ResourceFishTags.Items.UPGRADES);
            }
        });
    }

    private void createRecipeSlot(TankControllerBlockEntity entity, int slot, int x, int y) {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)entity.getItemStackHandler(), slot, x, y){

            public boolean mayPlace(ItemStack stack) {
                return !stack.is(ResourceFishTags.Items.UPGRADES);
            }
        });
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getProgress() {
        return this.data.get(0);
    }

    public int getMaxProgress() {
        return this.data.get(1);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 55, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 55) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return TankControllerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)ResourceFishBlocks.TANK_CONTROLLER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

