/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.screen;

import com.benbenlaw.resourcefish.block.entity.CaviarProcessorBlockEntity;
import com.benbenlaw.resourcefish.screen.CaviarFluidStackWidget;
import com.benbenlaw.resourcefish.screen.CaviarProcessorMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class CaviarProcessorScreen
extends AbstractContainerScreen<CaviarProcessorMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/gui/caviar_processor.png");

    public CaviarProcessorScreen(CaviarProcessorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 165;
        this.imageWidth = 175;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.addFluidWidgets();
    }

    private void addFluidWidgets() {
        FluidTank fuelTank = new FluidTank(0);
        CaviarProcessorBlockEntity caviarProcessorBlockEntity = ((CaviarProcessorMenu)this.menu).blockEntity;
        if (caviarProcessorBlockEntity instanceof CaviarProcessorBlockEntity) {
            CaviarProcessorBlockEntity tankBlockEntity = caviarProcessorBlockEntity;
            if (((CaviarProcessorMenu)this.menu).blockEntity.hasTankUpgrade()) {
                fuelTank = tankBlockEntity.TANK;
            }
        }
        if (fuelTank.getCapacity() != 0 && fuelTank.getFluidAmount() != 0) {
            this.addRenderableOnly((Renderable)new CaviarFluidStackWidget((Screen)this, fuelTank, (BlockEntity)((CaviarProcessorMenu)this.menu).blockEntity, this.leftPos + 152, this.topPos + 53, 16, 16));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressBars(guiGraphics, x, y);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        CaviarProcessorBlockEntity tankBlockEntity;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        CaviarProcessorBlockEntity caviarProcessorBlockEntity = ((CaviarProcessorMenu)this.menu).blockEntity;
        if (caviarProcessorBlockEntity instanceof CaviarProcessorBlockEntity && !(tankBlockEntity = caviarProcessorBlockEntity).hasTankUpgrade() && mouseX >= this.leftPos + 152 && mouseX <= this.leftPos + 168 && mouseY >= this.topPos + 53 && mouseY <= this.topPos + 69) {
            FormattedCharSequence[] tooltipLines = new FormattedCharSequence[]{Component.literal((String)"No Tank Upgrade").getVisualOrderText()};
            guiGraphics.renderTooltip(Minecraft.getInstance().font, Arrays.asList(tooltipLines), mouseX, mouseY);
        }
    }

    private void renderProgressBars(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        for (int slot : CaviarProcessorBlockEntity.INPUT_SLOTS) {
            int progress = ((CaviarProcessorMenu)this.menu).getScaledProgress(slot);
            if (progress <= 0) continue;
            Point slotPosition = ((CaviarProcessorMenu)this.menu).slotPositions.get(slot);
            int fullHeight = 18;
            guiGraphics.blit(TEXTURE, x + slotPosition.x - 1, y + slotPosition.y + (fullHeight - progress) - 1, 176, fullHeight - progress, 18, progress);
        }
    }
}

