/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.item;

import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ResourceFishBucketItem
extends MobBucketItem {
    public ResourceFishBucketItem(EntityType<? extends ResourceFishEntity> fishType, Fluid fluid, SoundEvent sound, Item.Properties properties) {
        super(fishType, fluid, sound, properties);
    }

    public Component getName(ItemStack stack) {
        ResourceLocation resourceType = (ResourceLocation)stack.get((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get());
        if (resourceType != null) {
            String name = resourceType.getPath();
            CharSequence[] parts = name.split("_");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].isEmpty()) continue;
                parts[i] = ((String)parts[i]).substring(0, 1).toUpperCase() + ((String)parts[i]).substring(1);
            }
            String formattedName = String.join((CharSequence)" ", parts);
            return Component.translatable((String)"item.resourcefish.resource_fish_bucket", (Object[])new Object[]{formattedName});
        }
        return super.getName(stack);
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        super.checkExtraContent(player, level, stack, pos);
    }
}

