/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration;

import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.integration.JEIResourceFishPlugin;
import com.benbenlaw.resourcefish.integration.fish.FishIngredient;
import com.benbenlaw.resourcefish.recipe.FishBreedingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class FishBreedingRecipeCategory
implements IRecipeCategory<FishBreedingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"fish_breeding");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/gui/jei_fish_breeding.png");
    static final RecipeType<FishBreedingRecipe> RECIPE_TYPE = RecipeType.create((String)"resourcefish", (String)"fish_breeding", FishBreedingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private List<ResourceFishEntity> cachedEntity = new ArrayList<ResourceFishEntity>();

    @Nullable
    public ResourceLocation getRegistryName(FishBreedingRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FishBreedingRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((FishBreedingRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public FishBreedingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ResourceFishBlocks.TANK_CONTROLLER.get()));
        for (int i = 0; i < 3; ++i) {
            this.cachedEntity.add(null);
        }
    }

    public RecipeType<FishBreedingRecipe> getRecipeType() {
        return JEIResourceFishPlugin.BREEDING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.resourcefish.fish_breeding");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FishBreedingRecipe recipe, IFocusGroup iFocusGroup) {
        FishIngredient fishIngredientA = new FishIngredient(recipe.parentIngredientA(), ResourceFishEntities.RESOURCE_FISH.get());
        FishIngredient fishIngredientB = new FishIngredient(recipe.parentIngredientB(), ResourceFishEntities.RESOURCE_FISH.get());
        FishIngredient createdFishIngredient = new FishIngredient(recipe.createdFish(), ResourceFishEntities.RESOURCE_FISH.get());
        this.addSizedIngredient(builder, RecipeIngredientRole.INPUT, 43, 17, recipe.breedingIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 17).addIngredient(JEIResourceFishPlugin.FISH_INGREDIENT_TYPE, (Object)fishIngredientA);
        builder.addSlot(RecipeIngredientRole.INPUT, 79, 17).addIngredient(JEIResourceFishPlugin.FISH_INGREDIENT_TYPE, (Object)fishIngredientB);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 118, 17).addIngredient(JEIResourceFishPlugin.FISH_INGREDIENT_TYPE, (Object)createdFishIngredient)).addRichTooltipCallback((iRecipeSlotView, iTooltipBuilder) -> iTooltipBuilder.add((FormattedText)Component.translatable((String)"jei.resourcefish.chance").append(String.valueOf(100.0 * recipe.chance())).append("%").withStyle(ChatFormatting.GOLD)));
    }

    public void draw(FishBreedingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, (Component)Component.translatable((String)"jei.resourcefish.fish_in_tank_area"), 1, 1, 1, false);
    }

    private void addSizedIngredient(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y, SizedIngredient sizedIngredient) {
        int count = sizedIngredient.count();
        List<ItemStack> stacks = Arrays.stream(sizedIngredient.ingredient().getItems()).map(stack -> {
            ItemStack copy = stack.copy();
            copy.setCount(count);
            return copy;
        }).toList();
        builder.addSlot(role, x, y).addItemStacks(stacks);
    }
}

