/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.entities;

import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.block.entity.TankControllerBlockEntity;
import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.util.ResourceType;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ResourceFishEntity
extends AbstractSchoolingFish {
    private static final EntityDataAccessor<String> DATA_RESOURCE_TYPE = SynchedEntityData.defineId(ResourceFishEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DATA_PATTERN = SynchedEntityData.defineId(ResourceFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MODEL = SynchedEntityData.defineId(ResourceFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int dropTimer = 0;
    private int ticksPerDrop = Integer.MAX_VALUE;
    private boolean allowedToDrop = false;
    private BlockPos tankHome = null;
    private final Level level;

    public ResourceFishEntity(EntityType<? extends AbstractSchoolingFish> type, Level level) {
        super(type, level);
        this.level = level;
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            if (this.tankHome == null) {
                this.allowedToDrop = false;
                return;
            }
            if (!this.level.getBlockState(this.tankHome).is((Block)ResourceFishBlocks.TANK_CONTROLLER.get())) {
                this.allowedToDrop = false;
                this.tankHome = null;
                return;
            }
            if (!this.allowedToDrop) {
                return;
            }
            ++this.dropTimer;
            ResourceType resourceType = this.getResourceType();
            this.ticksPerDrop = resourceType.getDropIntervalTicks();
            if (this.dropTimer >= this.ticksPerDrop) {
                this.dropTimer = 0;
                List<ItemStack> dropStack = resourceType.rollResults(this.random);
                for (ItemStack stack : dropStack) {
                    BlockEntity be;
                    if (stack.isEmpty() || !((be = this.level.getBlockEntity(this.tankHome)) instanceof TankControllerBlockEntity)) continue;
                    TankControllerBlockEntity tankControllerBlockEntity = (TankControllerBlockEntity)be;
                    ItemStackHandler handler = tankControllerBlockEntity.getItemStackHandler();
                    int[] slots = new int[handler.getSlots()];
                    for (int i = 0; i < 12; ++i) {
                        slots[i] = i;
                    }
                    tankControllerBlockEntity.insertStackIntoSlots(handler, stack, slots);
                }
            }
        }
    }

    public boolean isAllowedToDrop() {
        return this.allowedToDrop;
    }

    public void setAllowedToDrop(boolean allowedToDrop) {
        this.allowedToDrop = allowedToDrop;
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.COD_FLOP;
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ResourceFishItems.RESOURCE_FISH_BUCKET.get());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    public static Variant generateVariant(ResourceType type, RandomSource random) {
        List<Pattern.Base> models = type.getModels();
        Pattern.Base chosenModel = models.isEmpty() ? Pattern.Base.SMALL : models.get(random.nextInt(models.size()));
        List<Pattern> patterns = type.getPatterns().stream().filter(p -> p.getBase() == chosenModel).toList();
        Pattern chosenPattern = patterns.isEmpty() ? Pattern.SMALL_0 : patterns.get(random.nextInt(patterns.size()));
        return new Variant(type, chosenPattern, chosenModel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_RESOURCE_TYPE, (Object)ResourceType.NONE.getId().toString());
        builder.define(DATA_PATTERN, (Object)Pattern.SMALL_1.ordinal());
        builder.define(DATA_MODEL, (Object)Pattern.Base.SMALL.ordinal());
    }

    public Variant getVariant() {
        ResourceType resourceType = ResourceType.REGISTRY.getOrDefault(ResourceLocation.tryParse((String)((String)this.entityData.get(DATA_RESOURCE_TYPE))), ResourceType.NONE);
        Pattern pattern = Pattern.values()[(Integer)this.entityData.get(DATA_PATTERN)];
        Pattern.Base model = Pattern.Base.values()[(Integer)this.entityData.get(DATA_MODEL)];
        return new Variant(resourceType, pattern, model);
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_RESOURCE_TYPE, (Object)variant.type().getId().toString());
        this.entityData.set(DATA_PATTERN, (Object)variant.pattern().ordinal());
        this.entityData.set(DATA_MODEL, (Object)variant.model().ordinal());
    }

    public ResourceType getResourceType() {
        ResourceLocation id;
        ResourceType resourceType;
        String idString = (String)this.entityData.get(DATA_RESOURCE_TYPE);
        if (idString == null || idString.isEmpty()) {
            idString = ResourceType.NONE.getId().toString();
        }
        if ((resourceType = ResourceType.REGISTRY.get(id = ResourceLocation.parse((String)idString))) == null) {
            resourceType = ResourceType.NONE;
        }
        return resourceType;
    }

    public void setResourceType(ResourceType type) {
        this.entityData.set(DATA_RESOURCE_TYPE, (Object)type.getId().toString());
    }

    public int getResourceColor() {
        return this.getResourceType().getColor();
    }

    public void setTankHome(BlockPos pos) {
        this.tankHome = pos;
    }

    public BlockPos getTankHome() {
        return this.tankHome;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("ResourceType", this.getResourceType().getId().toString());
        tag.putInt("Pattern", ((Integer)this.entityData.get(DATA_PATTERN)).intValue());
        tag.putInt("Model", ((Integer)this.entityData.get(DATA_MODEL)).intValue());
        tag.putInt("dropTimer", this.dropTimer);
        tag.putInt("ticksPerDrop", this.ticksPerDrop);
        tag.putBoolean("allowedToDrop", this.allowedToDrop);
        if (this.tankHome != null) {
            tag.put("tankHome", NbtUtils.writeBlockPos((BlockPos)this.tankHome));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("ResourceType")) {
            this.entityData.set(DATA_RESOURCE_TYPE, (Object)tag.getString("ResourceType"));
        }
        if (tag.contains("Pattern")) {
            this.entityData.set(DATA_PATTERN, (Object)tag.getInt("Pattern"));
        }
        if (tag.contains("Model")) {
            this.entityData.set(DATA_MODEL, (Object)tag.getInt("Model"));
        }
        this.dropTimer = tag.getInt("dropTimer");
        this.ticksPerDrop = tag.getInt("ticksPerDrop");
        this.allowedToDrop = tag.getBoolean("allowedToDrop");
        if (NbtUtils.readBlockPos((CompoundTag)tag, (String)"tankHome").isPresent()) {
            this.tankHome = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"tankHome").get();
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (spawnType == MobSpawnType.BUCKET) {
            return super.finalizeSpawn(level, difficulty, spawnType, groupData);
        }
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, spawnType, groupData);
        Holder biomeHolder = level.getBiome(this.blockPosition());
        ResourceType type = this.generateRandomResource(level.getRandom(), (Holder<Biome>)biomeHolder);
        this.setResourceType(type);
        this.setVariant(ResourceFishEntity.generateVariant(type, level.getRandom()));
        this.allowedToDrop = false;
        if (type == ResourceType.NONE) {
            System.out.println("No naturally spawning ResourceType found for biome " + String.valueOf(Objects.requireNonNull(biomeHolder.getKey()).location()) + ". Removing entity.");
            this.discard();
            return null;
        }
        return data;
    }

    private boolean matchesBiomeOrTag(Holder<Biome> biomeHolder, String biomeOrTag) {
        if (biomeOrTag.startsWith("#")) {
            String tagLocation = biomeOrTag.substring(1);
            TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tagLocation));
            return biomeHolder.is(biomeTagKey);
        }
        ResourceLocation biomeId = Objects.requireNonNull(biomeHolder.getKey()).location();
        return biomeId.toString().equals(biomeOrTag);
    }

    private ResourceType generateRandomResource(RandomSource random, Holder<Biome> biomeHolder) {
        List<ResourceType> values = ResourceType.REGISTRY.values().stream().filter(type -> !type.getBiomes().isEmpty() && type.getBiomes().stream().anyMatch(biomeOrTag -> this.matchesBiomeOrTag(biomeHolder, (String)biomeOrTag))).toList();
        if (values.isEmpty()) {
            return ResourceType.NONE;
        }
        return values.get(random.nextInt(values.size()));
    }

    public boolean checkSpawnRules(LevelAccessor levelAccessor, MobSpawnType spawnType) {
        if (spawnType == MobSpawnType.BUCKET) {
            return true;
        }
        BlockPos pos = this.blockPosition();
        return this.level.getFluidState(pos).is(FluidTags.WATER);
    }

    public static <T extends ResourceFishEntity> boolean canSpawnHere(EntityType<T> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.BUCKET) {
            return true;
        }
        if (!level.getFluidState(pos).is(FluidTags.WATER)) {
            return false;
        }
        Holder biomeHolder = level.getBiome(pos);
        boolean validBiome = ResourceType.REGISTRY.values().stream().anyMatch(rt -> rt.getBiomes().stream().anyMatch(biomeOrTag -> {
            if (biomeOrTag.startsWith("#")) {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.tryParse((String)biomeOrTag.substring(1)));
                return biomeHolder.is(tagKey);
            }
            ResourceLocation biomeId = Objects.requireNonNull(biomeHolder.getKey()).location();
            return biomeId.toString().equals(biomeOrTag);
        }));
        if (validBiome) {
            // empty if block
        }
        return validBiome;
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        if (tag.contains("BucketResourceType", 8)) {
            this.entityData.set(DATA_RESOURCE_TYPE, (Object)tag.getString("BucketResourceType"));
        }
        if (tag.contains("BucketPattern", 3)) {
            this.entityData.set(DATA_PATTERN, (Object)tag.getInt("BucketPattern"));
        }
        if (tag.contains("BucketModel", 3)) {
            this.entityData.set(DATA_MODEL, (Object)tag.getInt("BucketModel"));
        }
        this.allowedToDrop = tag.contains("allowedToDrop", 1) ? tag.getBoolean("allowedToDrop") : false;
    }

    public void saveToBucketTag(ItemStack bucket) {
        super.saveToBucketTag(bucket);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, data -> {
            data.putString("BucketResourceType", this.getResourceType().getId().toString());
            data.putInt("BucketPattern", ((Integer)this.entityData.get(DATA_PATTERN)).intValue());
            data.putInt("BucketModel", ((Integer)this.entityData.get(DATA_MODEL)).intValue());
            data.putBoolean("allowedToDrop", this.allowedToDrop);
        });
        bucket.set((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get(), (Object)this.getResourceType().getId());
    }

    public Component getName() {
        return this.getDisplayName();
    }

    public Component getDisplayName() {
        if (this.hasCustomName()) {
            return Objects.requireNonNull(this.getCustomName());
        }
        ResourceType resourceType = this.getResourceType();
        String baseName = "entity.resourcefish.resource_fish";
        if (resourceType != null && resourceType != ResourceType.NONE) {
            String path = resourceType.getId().getPath();
            String capitalizedPath = path.substring(0, 1).toUpperCase(Locale.ROOT) + path.substring(1).toLowerCase(Locale.ROOT);
            return Component.translatable((String)baseName, (Object[])new Object[]{capitalizedPath});
        }
        return Component.literal((String)"This should not happen check logs its probably a missing resource type for the biome!");
    }

    public boolean removeWhenFarAway(double p_27492_) {
        return false;
    }

    public static enum Pattern {
        SMALL_0(0, Base.SMALL),
        SMALL_1(0, Base.SMALL),
        SMALL_2(1, Base.SMALL),
        SMALL_3(2, Base.SMALL),
        SMALL_4(3, Base.SMALL),
        SMALL_5(4, Base.SMALL),
        SMALL_6(5, Base.SMALL),
        LARGE_0(6, Base.LARGE),
        LARGE_1(6, Base.LARGE),
        LARGE_2(7, Base.LARGE),
        LARGE_3(8, Base.LARGE),
        LARGE_4(9, Base.LARGE),
        LARGE_5(10, Base.LARGE),
        LARGE_6(11, Base.LARGE);

        private final int id;
        private final Base size;
        public static final Codec<Pattern> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Pattern> STREAM_CODEC;

        private Pattern(int id, Base size) {
            this.id = id;
            this.size = size;
        }

        public int getId() {
            return this.id;
        }

        public Base getBase() {
            return this.size;
        }

        public static Pattern byId(int id) {
            for (Pattern p : Pattern.values()) {
                if (p.getId() != id) continue;
                return p;
            }
            return SMALL_1;
        }

        static {
            CODEC = Codec.INT.xmap(Pattern::byId, Pattern::getId);
            STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Pattern::getId, Pattern::byId);
        }

        public static enum Base {
            SMALL,
            LARGE;

            public static final Codec<Base> CODEC;
            public static final StreamCodec<RegistryFriendlyByteBuf, Base> STREAM_CODEC;

            static {
                CODEC = Codec.STRING.xmap(s -> Base.valueOf(s.toUpperCase()), Enum::name);
                STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Enum::name, Base::valueOf);
            }
        }
    }

    public record Variant(ResourceType type, Pattern pattern, Pattern.Base model) {
        public String getPatternTextureName() {
            return this.pattern.name().toLowerCase();
        }

        public Pattern.Base getModelBase() {
            return this.model;
        }
    }
}

