/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data.builders;

import com.benbenlaw.resourcefish.recipe.FishInfusingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishInfusingRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected ResourceLocation fish;
    protected NonNullList<SizedIngredient> inputs;
    protected int duration;
    protected double chance;
    protected ResourceLocation createdFish;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public FishInfusingRecipeBuilder(ResourceLocation fish, NonNullList<SizedIngredient> inputs, int duration, double chance, ResourceLocation createdFish) {
        this.fish = fish;
        this.inputs = NonNullList.create();
        this.inputs.addAll(inputs);
        this.duration = duration;
        this.chance = chance;
        this.createdFish = createdFish;
    }

    public static FishInfusingRecipeBuilder createFishInfusingRecipe(ResourceLocation fish, NonNullList<SizedIngredient> inputs, int duration, double chance, ResourceLocation createdFish) {
        return new FishInfusingRecipeBuilder(fish, inputs, duration, chance, createdFish);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String goupName) {
        this.group = goupName;
        return this;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)("infusing/" + this.createdFish.getPath())));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        FishInfusingRecipe fishInfusingRecipe = new FishInfusingRecipe(this.fish, this.inputs, this.duration, this.chance, this.createdFish);
        recipeOutput.accept(id, (Recipe)fishInfusingRecipe, builder.build(id.withPrefix("recipes/infusing/")));
    }
}

