/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data;

import com.benbenlaw.core.tag.CommonTags;
import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.data.builders.CaviarProcessorRecipeBuilder;
import com.benbenlaw.resourcefish.data.builders.FishBreedingRecipeBuilder;
import com.benbenlaw.resourcefish.data.builders.FishInfusingRecipeBuilder;
import com.benbenlaw.resourcefish.item.CaviarItem;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.util.ResourceFishTags;
import com.benbenlaw.resourcefish.util.SizedIngredientChanceResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class ResourceFishRecipes
extends RecipeProvider {
    public ResourceFishRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        Item basicFishFood = (Item)ResourceFishItems.BASIC_FISH_FOOD.get();
        Item metallicFishFood = (Item)ResourceFishItems.METALLIC_FISH_FOOD.get();
        Item crystalFishFood = (Item)ResourceFishItems.CRYSTAL_FISH_FOOD.get();
        Item netherFishFood = (Item)ResourceFishItems.NETHER_FISH_FOOD.get();
        Item enderFishFood = (Item)ResourceFishItems.ENDER_FISH_FOOD.get();
        Item basicMobFishFood = (Item)ResourceFishItems.BASIC_MOB_FISH_FOOD.get();
        ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>();
        ArrayList<InfusingRecipeSingle> infusingRecipes = new ArrayList<InfusingRecipeSingle>();
        ArrayList<CaviarSimple> caviarSimpleRecipes = new ArrayList<CaviarSimple>();
        breedingRecipes.add(new BreedingRecipe("dirt", "dirt", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "dirt", false));
        caviarSimpleRecipes.add(new CaviarSimple("dirt", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.DIRT, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("water", "water", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "water", false));
        CaviarProcessorRecipeBuilder.caviarProcessorRecipeBuilder(CaviarItem.createCaviarStack("water"), List.of()).withFluid(new FluidStack((Fluid)Fluids.WATER, 25)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"caviar/water"));
        breedingRecipes.add(new BreedingRecipe("lava", "lava", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "lava", false));
        CaviarProcessorRecipeBuilder.caviarProcessorRecipeBuilder(CaviarItem.createCaviarStack("lava"), List.of()).withFluid(new FluidStack((Fluid)Fluids.LAVA, 25)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"caviar/lava"));
        breedingRecipes.add(new BreedingRecipe("cobblestone", "cobblestone", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "cobblestone", false));
        caviarSimpleRecipes.add(new CaviarSimple("cobblestone", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.COBBLESTONE, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("wood", "wood", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "wood", false));
        infusingRecipes.add(new InfusingRecipeSingle("wood", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)ItemTags.LOGS, (int)64)), 100, 1.0, "wood", false));
        caviarSimpleRecipes.add(new CaviarSimple("wood", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.STICK, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.OAK_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SPRUCE_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BIRCH_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.JUNGLE_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ACACIA_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.DARK_OAK_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CHERRY_LOG, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.MANGROVE_LOG, (int)1), 0.05f)));
        breedingRecipes.add(new BreedingRecipe("water", "lava", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.1, "stone", false));
        infusingRecipes.add(new InfusingRecipeSingle("water", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.STONE, (int)64)), 100, 1.0, "stone", false));
        caviarSimpleRecipes.add(new CaviarSimple("stone", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.STONE, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("stone", "red", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "granite", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GRANITE, (int)64)), 100, 1.0, "granite", false));
        caviarSimpleRecipes.add(new CaviarSimple("granite", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GRANITE, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("stone", "white", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "diorite", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.DIORITE, (int)64)), 100, 1.0, "diorite", false));
        caviarSimpleRecipes.add(new CaviarSimple("diorite", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.DIORITE, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("stone", "gray", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.15, "andesite", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.ANDESITE, (int)64)), 100, 1.0, "andesite", false));
        caviarSimpleRecipes.add(new CaviarSimple("andesite", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ANDESITE, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("dirt", "water", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.5, "sand", false));
        infusingRecipes.add(new InfusingRecipeSingle("dirt", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.SAND, (int)64)), 100, 1.0, "sand", false));
        caviarSimpleRecipes.add(new CaviarSimple("sand", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SAND, (int)1), 0.4f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.RED_SAND, (int)1), 0.1f)));
        breedingRecipes.add(new BreedingRecipe("stone", "water", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.5, "gravel", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GRAVEL, (int)64)), 100, 1.0, "gravel", false));
        caviarSimpleRecipes.add(new CaviarSimple("gravel", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GRAVEL, (int)1), 0.4f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.FLINT, (int)1), 0.05f)));
        breedingRecipes.add(new BreedingRecipe("wood", "black", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "coal", false));
        infusingRecipes.add(new InfusingRecipeSingle("wood", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.COAL, (int)64)), 100, 0.25, "coal", false));
        caviarSimpleRecipes.add(new CaviarSimple("coal", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.COAL, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("coal", "blue", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "lapis", false));
        infusingRecipes.add(new InfusingRecipeSingle("coal", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.LAPIS_LAZULI, (int)64)), 100, 0.25, "lapis", false));
        caviarSimpleRecipes.add(new CaviarSimple("lapis", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.LAPIS_LAZULI, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lapis", "red", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "redstone", false));
        infusingRecipes.add(new InfusingRecipeSingle("lapis", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.REDSTONE, (int)64)), 100, 0.25, "redstone", false));
        caviarSimpleRecipes.add(new CaviarSimple("redstone", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.REDSTONE, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lapis", "light_blue", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "diamond", false));
        infusingRecipes.add(new InfusingRecipeSingle("lapis", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.DIAMOND, (int)64)), 100, 0.25, "diamond", false));
        caviarSimpleRecipes.add(new CaviarSimple("diamond", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.DIAMOND, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lapis", "green", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "emerald", false));
        infusingRecipes.add(new InfusingRecipeSingle("lapis", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.EMERALD, (int)64)), 100, 0.25, "emerald", false));
        caviarSimpleRecipes.add(new CaviarSimple("emerald", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.EMERALD, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("stone", "orange", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "copper", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.COPPER_INGOT, (int)64)), 100, 0.25, "copper", false));
        caviarSimpleRecipes.add(new CaviarSimple("copper", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.COPPER_INGOT, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("copper", "white", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "iron", false));
        infusingRecipes.add(new InfusingRecipeSingle("copper", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.IRON_INGOT, (int)64)), 100, 0.25, "iron", false));
        caviarSimpleRecipes.add(new CaviarSimple("iron", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.IRON_INGOT, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("iron", "yellow", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "gold", false));
        infusingRecipes.add(new InfusingRecipeSingle("iron", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GOLD_INGOT, (int)64)), 100, 0.25, "gold", false));
        caviarSimpleRecipes.add(new CaviarSimple("gold", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GOLD_INGOT, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("stone", "lava", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 100, 0.2, "netherrack", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.NETHERRACK, (int)64)), 100, 0.5, "netherrack", false));
        caviarSimpleRecipes.add(new CaviarSimple("netherrack", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.NETHERRACK, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("sand", "lava", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 100, 0.2, "soul_sand", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.SOUL_SAND, (int)64)), 100, 0.5, "soul_sand", false));
        caviarSimpleRecipes.add(new CaviarSimple("soul_sand", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SOUL_SAND, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("netherrack", "white", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 100, 0.2, "quartz", false));
        infusingRecipes.add(new InfusingRecipeSingle("netherrack", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.QUARTZ, (int)32)), 100, 0.25, "quartz", false));
        caviarSimpleRecipes.add(new CaviarSimple("quartz", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.QUARTZ, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("netherrack", "yellow", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 100, 0.2, "glowstone", false));
        infusingRecipes.add(new InfusingRecipeSingle("netherrack", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GLOWSTONE_DUST, (int)16)), 100, 0.25, "glowstone", false));
        caviarSimpleRecipes.add(new CaviarSimple("glowstone", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GLOWSTONE_DUST, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("dirt", "green", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "zombie", false));
        infusingRecipes.add(new InfusingRecipeSingle("dirt", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.ROTTEN_FLESH, (int)64)), 200, 0.5, "zombie", false));
        caviarSimpleRecipes.add(new CaviarSimple("zombie", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ROTTEN_FLESH, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.POTATO, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CARROT, (int)1), 0.05f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ZOMBIE_HEAD, (int)1), 0.01f)));
        breedingRecipes.add(new BreedingRecipe("dirt", "white", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "skeleton", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.BONE, (int)64)), 200, 0.5, "skeleton", false));
        caviarSimpleRecipes.add(new CaviarSimple("skeleton", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BONE, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SKELETON_SKULL, (int)1), 0.01f)));
        breedingRecipes.add(new BreedingRecipe("dirt", "green", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "creeper", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GUNPOWDER, (int)64)), 200, 0.5, "creeper", false));
        caviarSimpleRecipes.add(new CaviarSimple("creeper", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GUNPOWDER, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CREEPER_HEAD, (int)1), 0.01f)));
        breedingRecipes.add(new BreedingRecipe("dirt", "black", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "spider", false));
        infusingRecipes.add(new InfusingRecipeSingle("wood", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.STRING, (int)64)), 200, 0.5, "spider", false));
        caviarSimpleRecipes.add(new CaviarSimple("spider", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.STRING, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SPIDER_EYE, (int)1), 0.2f)));
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.getSerializedName();
            TagKey dyeTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + colorName)));
            Item dyeItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(String.valueOf(color) + "_dye")));
            infusingRecipes.add(new InfusingRecipeSingle("water", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)dyeTag, (int)1)), 200, 0.5, colorName, false));
            caviarSimpleRecipes.add(new CaviarSimple(colorName, false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)dyeItem, (int)1), 0.3f)));
        }
        breedingRecipes.add(new BreedingRecipe("stone", "light_gray", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "tin", true));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"tin", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "tin", true));
        caviarSimpleRecipes.add(new CaviarSimple("tin", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"tin", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("copper", "light_gray", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "aluminum", true));
        infusingRecipes.add(new InfusingRecipeSingle("copper", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"aluminum", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "aluminum", true));
        caviarSimpleRecipes.add(new CaviarSimple("aluminum", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"aluminum", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("iron", "cyan", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "lead", true));
        infusingRecipes.add(new InfusingRecipeSingle("iron", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"lead", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "lead", true));
        caviarSimpleRecipes.add(new CaviarSimple("lead", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"lead", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("iron", "orange", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "nickel", true));
        infusingRecipes.add(new InfusingRecipeSingle("iron", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"nickel", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "nickel", true));
        caviarSimpleRecipes.add(new CaviarSimple("nickel", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"nickel", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("gold", "blue", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "osmium", true));
        infusingRecipes.add(new InfusingRecipeSingle("gold", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"osmium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "osmium", true));
        caviarSimpleRecipes.add(new CaviarSimple("osmium", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"osmium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("gold", "light_gray", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "platinum", true));
        infusingRecipes.add(new InfusingRecipeSingle("gold", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"platinum", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "platinum", true));
        caviarSimpleRecipes.add(new CaviarSimple("platinum", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"platinum", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("iron", "light_gray", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "silver", true));
        infusingRecipes.add(new InfusingRecipeSingle("iron", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"silver", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "silver", true));
        caviarSimpleRecipes.add(new CaviarSimple("silver", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"silver", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("gold", "green", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "uranium", true));
        infusingRecipes.add(new InfusingRecipeSingle("gold", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"uranium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "uranium", true));
        caviarSimpleRecipes.add(new CaviarSimple("uranium", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"uranium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("copper", "gray", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "zinc", true));
        infusingRecipes.add(new InfusingRecipeSingle("copper", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"zinc", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "zinc", true));
        caviarSimpleRecipes.add(new CaviarSimple("zinc", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"zinc", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("gold", "white", SizedIngredient.of((ItemLike)metallicFishFood, (int)1), 100, 0.15, "iridium", true));
        infusingRecipes.add(new InfusingRecipeSingle("iron", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"iridium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)64)), 100, 0.25, "iridium", true));
        caviarSimpleRecipes.add(new CaviarSimple("iridium", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"iridium", (CommonTags.ResourceType)CommonTags.ResourceType.INGOTS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("emerald", "red", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "ruby", true));
        infusingRecipes.add(new InfusingRecipeSingle("emerald", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"ruby", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)64)), 100, 0.25, "ruby", true));
        caviarSimpleRecipes.add(new CaviarSimple("ruby", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"ruby", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("emerald", "blue", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "sapphire", true));
        infusingRecipes.add(new InfusingRecipeSingle("emerald", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"sapphire", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)64)), 100, 0.25, "sapphire", true));
        caviarSimpleRecipes.add(new CaviarSimple("sapphire", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"sapphire", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("emerald", "green", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "peridot", true));
        infusingRecipes.add(new InfusingRecipeSingle("emerald", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)CommonTags.getTag((String)"peridot", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)64)), 100, 0.25, "peridot", true));
        caviarSimpleRecipes.add(new CaviarSimple("peridot", true, new SizedIngredientChanceResult(SizedIngredient.of((TagKey)CommonTags.getTag((String)"peridot", (CommonTags.ResourceType)CommonTags.ResourceType.GEMS), (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lapis", "purple", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 100, 0.15, "amethyst", false));
        infusingRecipes.add(new InfusingRecipeSingle("lapis", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.AMETHYST_SHARD, (int)64)), 100, 0.25, "amethyst", false));
        caviarSimpleRecipes.add(new CaviarSimple("amethyst", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.AMETHYST_SHARD, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lava", "black", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 100, 0.2, "basalt", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.BASALT, (int)64)), 100, 0.5, "basalt", false));
        caviarSimpleRecipes.add(new CaviarSimple("basalt", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BASALT, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("netherrack", "basalt", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 200, 0.1, "ancient", false));
        infusingRecipes.add(new InfusingRecipeSingle("netherrack", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.ANCIENT_DEBRIS, (int)64)), 200, 0.1, "ancient", false));
        caviarSimpleRecipes.add(new CaviarSimple("ancient", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ANCIENT_DEBRIS, (int)1), 0.05f)));
        breedingRecipes.add(new BreedingRecipe("lava", "water", SizedIngredient.of((ItemLike)crystalFishFood, (int)1), 200, 0.1, "obsidian", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.OBSIDIAN, (int)64)), 200, 0.1, "obsidian", false));
        caviarSimpleRecipes.add(new CaviarSimple("obsidian", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.OBSIDIAN, (int)1), 0.05f)));
        breedingRecipes.add(new BreedingRecipe("lava", "netherrack", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 300, 0.1, "blaze", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.BLAZE_ROD, (int)64)), 300, 0.1, "blaze", false));
        caviarSimpleRecipes.add(new CaviarSimple("blaze", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BLAZE_ROD, (int)1), 0.1f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BLAZE_POWDER, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("stone", "yellow", SizedIngredient.of((ItemLike)enderFishFood, (int)1), 300, 0.1, "end_stone", false));
        infusingRecipes.add(new InfusingRecipeSingle("stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.END_STONE, (int)64)), 300, 0.1, "end_stone", false));
        caviarSimpleRecipes.add(new CaviarSimple("end_stone", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.END_STONE, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("end_stone", "black", SizedIngredient.of((ItemLike)enderFishFood, (int)1), 300, 0.1, "enderman", false));
        infusingRecipes.add(new InfusingRecipeSingle("end_stone", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.END_STONE, (int)64)), 300, 0.1, "enderman", false));
        caviarSimpleRecipes.add(new CaviarSimple("enderman", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ENDER_PEARL, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("skeleton", "coal", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 300, 0.05, "wither_skeleton", false));
        infusingRecipes.add(new InfusingRecipeSingle("skeleton", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.WITHER_SKELETON_SKULL, (int)3)), 300, 0.05, "wither_skeleton", false));
        caviarSimpleRecipes.add(new CaviarSimple("wither_skeleton", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.WITHER_SKELETON_SKULL, (int)1), 0.02f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.COAL, (int)1), 0.1f)));
        breedingRecipes.add(new BreedingRecipe("skeleton", "white", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 300, 0.05, "ghast", false));
        infusingRecipes.add(new InfusingRecipeSingle("skeleton", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.GHAST_TEAR, (int)3)), 300, 0.05, "ghast", false));
        caviarSimpleRecipes.add(new CaviarSimple("ghast", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GHAST_TEAR, (int)1), 0.02f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GUNPOWDER, (int)1), 0.1f)));
        breedingRecipes.add(new BreedingRecipe("green", "dirt", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "slime", false));
        infusingRecipes.add(new InfusingRecipeSingle("green", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.SLIME_BALL, (int)12)), 200, 0.25, "slime", false));
        caviarSimpleRecipes.add(new CaviarSimple("slime", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SLIME_BALL, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("lava", "orange", SizedIngredient.of((ItemLike)netherFishFood, (int)1), 200, 0.2, "magma_cube", false));
        infusingRecipes.add(new InfusingRecipeSingle("lava", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.MAGMA_CREAM, (int)12)), 200, 0.25, "magma_cube", false));
        caviarSimpleRecipes.add(new CaviarSimple("magma_cube", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.MAGMA_CREAM, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("black", "white", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "cow", false));
        infusingRecipes.add(new InfusingRecipeSingle("black", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.LEATHER, (int)12), SizedIngredient.of((ItemLike)Items.BEEF, (int)12)), 200, 0.25, "cow", false));
        caviarSimpleRecipes.add(new CaviarSimple("cow", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.LEATHER, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BEEF, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("pink", "pink", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "pig", false));
        infusingRecipes.add(new InfusingRecipeSingle("pink", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.PORKCHOP, (int)12)), 200, 0.25, "pig", false));
        caviarSimpleRecipes.add(new CaviarSimple("pig", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.PORKCHOP, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("white", "white", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "sheep", false));
        infusingRecipes.add(new InfusingRecipeSingle("white", ResourceFishRecipes.inputList(SizedIngredient.of((TagKey)ItemTags.WOOL, (int)12), SizedIngredient.of((ItemLike)Items.MUTTON, (int)12)), 200, 0.25, "sheep", false));
        caviarSimpleRecipes.add(new CaviarSimple("sheep", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.WHITE_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BLACK_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BLUE_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BROWN_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CYAN_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GRAY_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.LIGHT_BLUE_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.LIGHT_GRAY_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.PINK_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.MAGENTA_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ORANGE_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.RED_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.GREEN_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.LIME_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.YELLOW_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.PURPLE_WOOL, (int)1), 0.025f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.MUTTON, (int)1), 0.2f)));
        breedingRecipes.add(new BreedingRecipe("white", "yellow", SizedIngredient.of((ItemLike)basicMobFishFood, (int)1), 200, 0.2, "chicken", false));
        infusingRecipes.add(new InfusingRecipeSingle("white", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.FEATHER, (int)12), SizedIngredient.of((ItemLike)Items.CHICKEN, (int)12)), 200, 0.25, "chicken", false));
        caviarSimpleRecipes.add(new CaviarSimple("chicken", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CHICKEN, (int)1), 0.2f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.EGG, (int)1), 0.1f)));
        breedingRecipes.add(new BreedingRecipe("sand", "water", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.2, "clay", false));
        infusingRecipes.add(new InfusingRecipeSingle("sand", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.CLAY_BALL, (int)64)), 100, 0.5, "clay", false));
        caviarSimpleRecipes.add(new CaviarSimple("clay", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.CLAY_BALL, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("water", "white", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.2, "snow", false));
        infusingRecipes.add(new InfusingRecipeSingle("water", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.SNOWBALL, (int)64)), 100, 0.5, "snow", false));
        caviarSimpleRecipes.add(new CaviarSimple("snow", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.SNOWBALL, (int)1), 0.4f)));
        breedingRecipes.add(new BreedingRecipe("snow", "blue", SizedIngredient.of((ItemLike)basicFishFood, (int)1), 100, 0.2, "ice", false));
        infusingRecipes.add(new InfusingRecipeSingle("snow", ResourceFishRecipes.inputList(SizedIngredient.of((ItemLike)Items.ICE, (int)64)), 100, 0.5, "ice", false));
        caviarSimpleRecipes.add(new CaviarSimple("ice", false, new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.ICE, (int)1), 0.4f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.PACKED_ICE, (int)1), 0.1f), new SizedIngredientChanceResult(SizedIngredient.of((ItemLike)Items.BLUE_ICE, (int)1), 0.05f)));
        for (BreedingRecipe recipe : breedingRecipes) {
            RecipeBuilder builder = FishBreedingRecipeBuilder.createFishBreedingRecipe(ResourceFishRecipes.createFish(recipe.parent1), ResourceFishRecipes.createFish(recipe.parent2), recipe.catalyst, recipe.time, recipe.successChance, ResourceFishRecipes.createFish(recipe.child)).unlockedBy("has_item", ResourceFishRecipes.has((ItemLike)recipe.catalyst.ingredient().getItems()[0].getItem()));
            if (recipe.withCondition) {
                builder.save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(CommonTags.getTag((String)recipe.child, (CommonTags.ResourceType)CommonTags.ResourceType.ORES)))}));
                continue;
            }
            builder.save(consumer);
        }
        for (InfusingRecipeSingle recipe : infusingRecipes) {
            RecipeBuilder builder = FishInfusingRecipeBuilder.createFishInfusingRecipe(ResourceFishRecipes.createFish(recipe.fishToCovert), recipe.inputs, recipe.time, recipe.successChance, ResourceFishRecipes.createFish(recipe.result)).unlockedBy("has_item", ResourceFishRecipes.has((ItemLike)((SizedIngredient)recipe.inputs.get(0)).ingredient().getItems()[0].getItem()));
            if (recipe.withCondition) {
                builder.save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(CommonTags.getTag((String)recipe.result, (CommonTags.ResourceType)CommonTags.ResourceType.ORES)))}));
                continue;
            }
            builder.save(consumer);
        }
        for (CaviarSimple recipe : caviarSimpleRecipes) {
            CaviarProcessorRecipeBuilder builder = CaviarProcessorRecipeBuilder.caviarProcessorRecipeBuilder(CaviarItem.createCaviarStack(recipe.fish), List.of(recipe.chanceResults));
            if (recipe.withCondition) {
                builder.save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(CommonTags.getTag((String)recipe.fish, (CommonTags.ResourceType)CommonTags.ResourceType.ORES)))}), recipe.fish);
                continue;
            }
            builder.save(consumer, recipe.fish);
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.BASIC_FISH_FOOD, (int)6).pattern(" A ").pattern("A A").pattern(" A ").define(Character.valueOf('A'), (ItemLike)Items.KELP).unlockedBy("has_item", ResourceFishRecipes.has((ItemLike)Items.KELP)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.METALLIC_FISH_FOOD, (int)6).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), ResourceFishItems.BASIC_FISH_FOOD).define(Character.valueOf('B'), Tags.Items.INGOTS).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.BASIC_FISH_FOOD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.CRYSTAL_FISH_FOOD, (int)6).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), ResourceFishItems.METALLIC_FISH_FOOD).define(Character.valueOf('B'), Tags.Items.GEMS).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.METALLIC_FISH_FOOD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.BASIC_MOB_FISH_FOOD, (int)6).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), ResourceFishItems.METALLIC_FISH_FOOD).define(Character.valueOf('B'), (ItemLike)Items.BONE_BLOCK).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.METALLIC_FISH_FOOD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.NETHER_FISH_FOOD, (int)6).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), ResourceFishItems.CRYSTAL_FISH_FOOD).define(Character.valueOf('B'), (ItemLike)Items.GLOWSTONE).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.CRYSTAL_FISH_FOOD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.ENDER_FISH_FOOD, (int)6).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), ResourceFishItems.NETHER_FISH_FOOD).define(Character.valueOf('B'), (ItemLike)Items.END_STONE).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.NETHER_FISH_FOOD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishBlocks.TANK_CONTROLLER).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), ResourceFishItems.RESOURCE_FISH_BUCKET).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.RESOURCE_FISH_BUCKET)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishBlocks.CAVIAR_PROCESSOR).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)CaviarItem.createCaviarStack("lava").getItem()).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.DEPTH_UPGRADE_1).pattern("AAA").pattern(" B ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.DEPTH_UPGRADE_2).pattern("AAA").pattern(" B ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.DEPTH_UPGRADE_3).pattern("AAA").pattern(" B ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.WIDTH_UPGRADE_1).pattern("A A").pattern("ABA").pattern("A A").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.WIDTH_UPGRADE_2).pattern("A A").pattern("ABA").pattern("A A").define(Character.valueOf('A'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.WIDTH_UPGRADE_3).pattern("A A").pattern("ABA").pattern("A A").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.SPEED_UPGRADE_1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)Items.SUGAR).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.SPEED_UPGRADE_2).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.SPEED_UPGRADE_3).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)Items.END_ROD).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.TANK_UPGRADE).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.RESOURCE_FISH_BUCKET)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.BREEDING_UPGRADE).pattern("AAA").pattern("B B").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), ResourceFishItems.RESOURCE_FISH_BUCKET).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.RESOURCE_FISH_BUCKET)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.INFUSING_UPGRADE).pattern("AAA").pattern("BCB").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.BONE_MEAL).define(Character.valueOf('B'), ResourceFishItems.RESOURCE_FISH_BUCKET).define(Character.valueOf('C'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishItems.INFUSING_UPGRADE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ResourceFishItems.ROUND_ROBIN_UPGRADE).pattern("BAB").pattern("ABA").pattern("BAB").define(Character.valueOf('A'), (ItemLike)Items.REDSTONE).define(Character.valueOf('B'), ResourceFishTags.Items.CAVIAR).unlockedBy("has_item", ResourceFishRecipes.has(ResourceFishTags.Items.CAVIAR)).save(consumer);
    }

    public static NonNullList<SizedIngredient> inputList(SizedIngredient ... stacks) {
        NonNullList list = NonNullList.create();
        list.addAll(Arrays.asList(stacks));
        return list;
    }

    public static ResourceLocation createFish(String resource) {
        return ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)resource);
    }

    record BreedingRecipe(String parent1, String parent2, SizedIngredient catalyst, int time, double successChance, String child, boolean withCondition) {
    }

    record CaviarSimple(String fish, boolean withCondition, SizedIngredientChanceResult[] chanceResults) {
    }

    record InfusingRecipeSingle(String fishToCovert, NonNullList<SizedIngredient> inputs, int time, double successChance, String result, boolean withCondition) {
    }

    record InfusingRecipe(String fishToCovert, SizedIngredient input1, SizedIngredient input2, SizedIngredient input3, int time, double successChance, String result) {
    }
}

