/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.tag.CommonTags;
import com.benbenlaw.resourcefish.data.builders.ResourceFishBuilder;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.item.CaviarItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class ResourceFishFishes
extends ResourceFishBuilder {
    public ResourceFishFishes(PackOutput output) {
        super(output);
        ArrayList<FishData> fishData = new ArrayList<FishData>();
        List<ResourceFishEntity.Pattern.Base> smallModels = List.of(ResourceFishEntity.Pattern.Base.SMALL);
        List<ResourceFishEntity.Pattern.Base> largeModels = List.of(ResourceFishEntity.Pattern.Base.LARGE);
        ResourceFishEntity.Pattern small1 = ResourceFishEntity.Pattern.SMALL_1;
        ResourceFishEntity.Pattern small2 = ResourceFishEntity.Pattern.SMALL_2;
        ResourceFishEntity.Pattern small3 = ResourceFishEntity.Pattern.SMALL_3;
        ResourceFishEntity.Pattern small4 = ResourceFishEntity.Pattern.SMALL_4;
        ResourceFishEntity.Pattern small5 = ResourceFishEntity.Pattern.SMALL_5;
        ResourceFishEntity.Pattern small6 = ResourceFishEntity.Pattern.SMALL_6;
        ResourceFishEntity.Pattern large1 = ResourceFishEntity.Pattern.LARGE_1;
        ResourceFishEntity.Pattern large2 = ResourceFishEntity.Pattern.LARGE_2;
        ResourceFishEntity.Pattern large3 = ResourceFishEntity.Pattern.LARGE_3;
        ResourceFishEntity.Pattern large4 = ResourceFishEntity.Pattern.LARGE_4;
        ResourceFishEntity.Pattern large5 = ResourceFishEntity.Pattern.LARGE_5;
        ResourceFishEntity.Pattern large6 = ResourceFishEntity.Pattern.LARGE_6;
        fishData.add(new FishData("dirt", -8441088, -8636894, List.of(), 300, List.of(large5, large2), largeModels, List.of("#c:is_ocean"), false));
        fishData.add(new FishData("water", -2144583814, -2143397001, List.of(), 300, List.of(small3, small4), smallModels, List.of("#c:is_ocean"), false));
        fishData.add(new FishData("lava", -2130754304, -2138374144, List.of(), 300, List.of(small3, small6), smallModels, List.of("#c:is_ocean"), false));
        fishData.add(new FishData("cobblestone", -8355712, -9868951, List.of(), 300, List.of(large1, large2), largeModels, List.of("#c:is_ocean"), false));
        fishData.add(new FishData("wood", -7650029, -10733015, List.of(), 300, List.of(large2, large3), largeModels, List.of("#c:is_ocean"), false));
        fishData.add(new FishData("stone", -5658199, -9868951, List.of(), 300, List.of(large3, large6), largeModels, List.of(), false));
        fishData.add(new FishData("granite", -5802397, -5802397, List.of(), 300, List.of(large4, large5), largeModels, List.of(), false));
        fishData.add(new FishData("diorite", -657956, -5658199, List.of(), 300, List.of(large1, large2), largeModels, List.of(), false));
        fishData.add(new FishData("andesite", -2894893, -9868951, List.of(), 300, List.of(large2, large3), largeModels, List.of(), false));
        fishData.add(new FishData("sand", -744352, -2180985, List.of(), 300, List.of(large2, large6), largeModels, List.of(), false));
        fishData.add(new FishData("gravel", -8355712, -9868951, List.of(), 300, List.of(large3, large4), largeModels, List.of(), false));
        fishData.add(new FishData("coal", -13684945, -14935012, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("lapis", -14774017, -16777077, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("redstone", -65536, -7667712, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("diamond", -16728065, -14935012, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("emerald", -11483016, -16751616, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("copper", -4689101, -12422349, List.of(), 300, List.of(small3, small1), smallModels, List.of(), false));
        fishData.add(new FishData("iron", -2829100, -8750470, List.of(), 300, List.of(small2, small3), smallModels, List.of(), false));
        fishData.add(new FishData("gold", -10496, -4684277, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("netherrack", -7667712, -11862016, List.of(), 300, List.of(large4, large5), largeModels, List.of(), false));
        fishData.add(new FishData("soul_sand", -14542314, -8888239, List.of(), 300, List.of(large2, large3), largeModels, List.of(), false));
        fishData.add(new FishData("quartz", -1, -4210753, List.of(), 300, List.of(small4, small1), smallModels, List.of(), false));
        fishData.add(new FishData("glowstone", -1331, -10496, List.of(), 300, List.of(small5, small6), smallModels, List.of(), false));
        fishData.add(new FishData("zombie", 547989929, -9728477, List.of(), 300, List.of(small6), smallModels, List.of(), false));
        fishData.add(new FishData("skeleton", 0x20FFFFFF, -9737365, List.of(), 300, List.of(small5), smallModels, List.of(), false));
        fishData.add(new FishData("creeper", 547989929, -14513374, List.of(), 300, List.of(small4), smallModels, List.of(), false));
        fishData.add(new FishData("spider", 547989929, -7650029, List.of(), 300, List.of(small2), smallModels, List.of(), false));
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.getSerializedName();
            int rgb = color.getFireworkColor();
            int colorInt = 0xFF000000 | rgb;
            fishData.add(new FishData(colorName, colorInt, colorInt, List.of(), 300, List.of(small1), smallModels, List.of(), false));
        }
        fishData.add(new FishData("tin", -5192482, -9404272, List.of(), 300, List.of(small5, small1), smallModels, List.of(), true));
        fishData.add(new FishData("aluminum", -4144960, -8355712, List.of(), 300, List.of(small6, small2), smallModels, List.of(), true));
        fishData.add(new FishData("lead", -9868951, -13676721, List.of(), 300, List.of(small3, small4), smallModels, List.of(), true));
        fishData.add(new FishData("nickel", -4210238, -9535616, List.of(), 300, List.of(small2, small5), smallModels, List.of(), true));
        fishData.add(new FishData("osmium", -9131583, -13739644, List.of(), 300, List.of(small4, small6), smallModels, List.of(), true));
        fishData.add(new FishData("platinum", -1710878, -7434610, List.of(), 300, List.of(small1, small3), smallModels, List.of(), true));
        fishData.add(new FishData("silver", -4144960, -5197648, List.of(), 300, List.of(small5, small2), smallModels, List.of(), true));
        fishData.add(new FishData("uranium", -8388864, -11179217, List.of(), 300, List.of(small6, small4), smallModels, List.of(), true));
        fishData.add(new FishData("zinc", -5192482, -9404272, List.of(), 300, List.of(small3, small1), smallModels, List.of(), true));
        fishData.add(new FishData("iridium", -12764102, -14935012, List.of(), 300, List.of(small2, small6), smallModels, List.of(), true));
        fishData.add(new FishData("ruby", -5635820, -8716288, List.of(), 300, List.of(small1, small4), smallModels, List.of(), true));
        fishData.add(new FishData("sapphire", -15772998, -16777077, List.of(), 300, List.of(small5, small3), smallModels, List.of(), true));
        fishData.add(new FishData("peridot", -4930524, -9532611, List.of(), 300, List.of(small6, small2), smallModels, List.of(), true));
        fishData.add(new FishData("amethyst", -6723892, -11861886, List.of(), 300, List.of(small4, small1), smallModels, List.of(), false));
        fishData.add(new FishData("basalt", -13882324, -15066598, List.of(), 300, List.of(large6, large3), largeModels, List.of(), false));
        fishData.add(new FishData("ancient", -7305339, -6977146, List.of(), 300, List.of(large5, large1), largeModels, List.of(), false));
        fishData.add(new FishData("obsidian", -14935012, -16053493, List.of(), 300, List.of(large4, large2), largeModels, List.of(), false));
        fishData.add(new FishData("blaze", -2130736128, -2130754304, List.of(), 300, List.of(small5, small6), smallModels, List.of(), false));
        fishData.add(new FishData("end_stone", -1123198, -4343957, List.of(), 300, List.of(small1, small2), smallModels, List.of(), false));
        fishData.add(new FishData("enderman", -2145378272, Integer.MIN_VALUE, List.of(), 300, List.of(small3, small4), smallModels, List.of(), false));
        fishData.add(new FishData("wither_skeleton", -6908266, -13224394, List.of(), 300, List.of(small5, small1), smallModels, List.of(), false));
        fishData.add(new FishData("ghast", -1800, -5103070, List.of(), 300, List.of(small4, small2), smallModels, List.of(), false));
        fishData.add(new FishData("slime", -2147418368, -2147450880, List.of(), 300, List.of(small6, small3), smallModels, List.of(), false));
        fishData.add(new FishData("magma_cube", -2130754304, -2138374144, List.of(), 300, List.of(small1, small5), smallModels, List.of(), false));
        fishData.add(new FishData("cow", -5658199, -7650029, List.of(), 300, List.of(small6, small2), smallModels, List.of(), false));
        fishData.add(new FishData("pig", -5658199, -16181, List.of(), 300, List.of(small4, small3), smallModels, List.of(), false));
        fishData.add(new FishData("sheep", -5658199, -1, List.of(), 300, List.of(small2, small5), smallModels, List.of(), false));
        fishData.add(new FishData("chicken", -5658199, -1828, List.of(), 300, List.of(small1, small6), smallModels, List.of(), false));
        fishData.add(new FishData("clay", -5192482, -9404272, List.of(), 300, List.of(large1, large4), largeModels, List.of(), false));
        fishData.add(new FishData("snow", -1, -5185306, List.of(), 300, List.of(large2, large5), largeModels, List.of(), false));
        fishData.add(new FishData("ice", -5383962, -7876885, List.of(), 300, List.of(large3, large6), largeModels, List.of(), false));
        for (FishData data : fishData) {
            ChanceResult addCaviarStack = new ChanceResult(CaviarItem.createCaviarStack(data.name), 1.0f);
            ArrayList<ChanceResult> totalDrops = new ArrayList<ChanceResult>(data.drops);
            totalDrops.add(addCaviarStack);
            ResourceFishBuilder.Builder fishBuilder = ResourceFishBuilder.builder(data.name).mainColor(data.mainColor).patternColor(data.patternColor).dropItems(totalDrops).dropInterval(data.dropInterval).patterns(data.patterns).models(data.models).biomes(data.biomes);
            if (data.withConditions) {
                fishBuilder.conditions(List.of(new NotCondition((ICondition)new TagEmptyCondition(CommonTags.getTag((String)data.name, (CommonTags.ResourceType)CommonTags.ResourceType.ORES)))));
            }
            this.addFish(fishBuilder.build());
        }
    }

    record FishData(String name, int mainColor, int patternColor, List<ChanceResult> drops, int dropInterval, List<ResourceFishEntity.Pattern> patterns, List<ResourceFishEntity.Pattern.Base> models, List<String> biomes, boolean withConditions) {
    }
}

