/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data;

import com.benbenlaw.resourcefish.data.ResourceFishBlockTags;
import com.benbenlaw.resourcefish.data.ResourceFishFishes;
import com.benbenlaw.resourcefish.data.ResourceFishItemModelsProvider;
import com.benbenlaw.resourcefish.data.ResourceFishItemTags;
import com.benbenlaw.resourcefish.data.ResourceFishLangProvider;
import com.benbenlaw.resourcefish.data.ResourceFishLootTableProvider;
import com.benbenlaw.resourcefish.data.ResourceFishRecipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="resourcefish")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ResourceFishRecipes(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ResourceFishLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        ResourceFishBlockTags blockTags = new ResourceFishBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        ResourceFishItemTags itemTags = new ResourceFishItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new ResourceFishItemModelsProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ResourceFishLangProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ResourceFishFishes(packOutput));
    }
}

