/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.resourcefish.block.entity.ResourceFishBlockEntities;
import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.ActiveRecipeType;
import com.benbenlaw.resourcefish.recipe.FishBreedingRecipe;
import com.benbenlaw.resourcefish.recipe.FishInfusingRecipe;
import com.benbenlaw.resourcefish.recipe.TankRecipeInput;
import com.benbenlaw.resourcefish.util.ResourceFishTags;
import com.benbenlaw.resourcefish.util.ResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TankControllerBlockEntity
extends SyncableBlockEntity {
    public final ContainerData data;
    private ActiveRecipeType activeRecipe = ActiveRecipeType.NONE;
    public static final int RECIPE_SLOT_1 = 12;
    public static final int RECIPE_SLOT_2 = 13;
    public static final int RECIPE_SLOT_3 = 14;
    public static final int UPGRADE_SLOT_1 = 15;
    public static final int UPGRADE_SLOT_2 = 16;
    public static final int UPGRADE_SLOT_3 = 17;
    public static final int UPGRADE_SLOT_4 = 18;
    public int progress = 0;
    public int maxProgress = Integer.MAX_VALUE;
    private boolean inventoryChanged = true;
    public List<ResourceFishEntity> fishPool = new ArrayList<ResourceFishEntity>();
    private final Set<UUID> previouslyAllowedFish = new HashSet<UUID>();
    public int fishCount = 0;
    public int maxFishCount = 0;
    private boolean showRange = false;
    public List<String> fishNames = new ArrayList<String>();
    private Optional<RecipeHolder<FishBreedingRecipe>> currentBreedingMatch = Optional.empty();
    private Optional<RecipeHolder<FishInfusingRecipe>> currentInfusingMatch = Optional.empty();
    private TankRecipeInput cachedInventory = this.getRecipeInput();
    private final ItemStackHandler itemHandler = new ItemStackHandler(19){

        protected void onContentsChanged(int slot) {
            TankControllerBlockEntity.this.setChanged();
            TankControllerBlockEntity.this.sync();
            TankControllerBlockEntity.this.inventoryChanged = true;
        }

        public int getSlotLimit(int slot) {
            if (slot >= 15 && slot <= 18) {
                return 1;
            }
            return 64;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot >= 15 && slot <= 18) {
                if (stack.is(ResourceFishTags.Items.UPGRADES)) {
                    return 1;
                }
                return 0;
            }
            if (slot >= 12 && slot <= 14) {
                if (stack.is(ResourceFishTags.Items.UPGRADES)) {
                    return 0;
                }
                return stack.getMaxStackSize();
            }
            return stack.getMaxStackSize();
        }
    };
    private final IItemHandler tankControllerItemHandlerSide = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (slot, stack) -> slot >= 12 && slot <= 15, slot -> slot >= 0 && slot <= 11);

    @NotNull
    private TankRecipeInput getRecipeInput() {
        return new TankRecipeInput(this.itemHandler, this.getBlockPos()){

            @Override
            @NotNull
            public ItemStack getItem(int index) {
                return TankControllerBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            @Override
            public int size() {
                return TankControllerBlockEntity.this.itemHandler.getSlots();
            }

            @Override
            public BlockPos getPos() {
                return TankControllerBlockEntity.this.getBlockPos();
            }
        };
    }

    public TankControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ResourceFishBlockEntities.TANK_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> TankControllerBlockEntity.this.progress;
                    case 1 -> TankControllerBlockEntity.this.maxProgress;
                    case 2 -> TankControllerBlockEntity.this.fishCount;
                    case 3 -> TankControllerBlockEntity.this.maxFishCount;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        TankControllerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        TankControllerBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        TankControllerBlockEntity.this.fishCount = value;
                        break;
                    }
                    case 3: {
                        TankControllerBlockEntity.this.maxFishCount = value;
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public IItemHandler getTankControllerItemHandlerSide(Direction side) {
        return this.tankControllerItemHandlerSide;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public int getMaxFish(AABB box) {
        BlockPos min = new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ);
        BlockPos max = new BlockPos((int)box.maxX, (int)box.maxY, (int)box.maxZ);
        int blocksOfWaterPerFish = 3;
        int waterBlocks = 0;
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int y = min.getY(); y <= max.getY(); ++y) {
                for (int z = min.getZ(); z <= max.getZ(); ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    assert (this.level != null);
                    if (!this.level.getBlockState(currentPos).getFluidState().isSource() || this.level.getBlockState(currentPos).getFluidState().isEmpty()) continue;
                    ++waterBlocks;
                }
            }
        }
        this.maxFishCount = waterBlocks / blocksOfWaterPerFish;
        return this.maxFishCount;
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        Direction opposite = facing.getOpposite();
        BlockPos centerPos = this.worldPosition.relative(opposite, 3);
        AABB box = this.calculateBox(centerPos, opposite);
        if (this.level.isClientSide()) {
            if (this.showRange) {
                this.spawnBoxOutlineParticles(box);
            }
            return;
        }
        if (this.inventoryChanged) {
            this.cachedInventory = this.getRecipeInput();
            Optional breedingMatch = this.level.getRecipeManager().getRecipeFor((RecipeType)FishBreedingRecipe.Type.INSTANCE, (RecipeInput)this.cachedInventory, this.level);
            Optional infusingMatch = this.level.getRecipeManager().getRecipeFor((RecipeType)FishInfusingRecipe.Type.INSTANCE, (RecipeInput)this.cachedInventory, this.level);
            if (breedingMatch.isPresent()) {
                this.activeRecipe = ActiveRecipeType.BREEDING;
                this.currentBreedingMatch = breedingMatch;
                this.currentInfusingMatch = Optional.empty();
            } else if (infusingMatch.isPresent()) {
                this.activeRecipe = ActiveRecipeType.INFUSING;
                this.currentInfusingMatch = infusingMatch;
                this.currentBreedingMatch = Optional.empty();
            } else {
                this.activeRecipe = ActiveRecipeType.NONE;
                this.currentBreedingMatch = Optional.empty();
                this.currentInfusingMatch = Optional.empty();
            }
            this.inventoryChanged = false;
        }
        switch (this.activeRecipe) {
            case BREEDING: {
                if (this.currentBreedingMatch == null || !this.currentBreedingMatch.isPresent()) break;
                this.breedingRecipe(this.currentBreedingMatch, centerPos, this.itemHandler, this.level);
                break;
            }
            case INFUSING: {
                if (this.currentInfusingMatch == null || !this.currentInfusingMatch.isPresent()) break;
                this.infusingRecipe(this.currentInfusingMatch, centerPos, this.itemHandler, this.level);
                break;
            }
            case NONE: {
                this.progress = 0;
                this.maxProgress = Integer.MAX_VALUE;
            }
        }
        if (this.level.getGameTime() % 20L == 0L) {
            List entityList = this.level.getEntities(null, box);
            this.fishPool.clear();
            HashSet<UUID> currentAllowedFish = new HashSet<UUID>();
            boolean tooManyFish = this.fishCount > this.maxFishCount;
            boolean breedingBlocked = this.hasBreedingUpgrade();
            for (Entity entity : entityList) {
                if (!(entity instanceof ResourceFishEntity)) continue;
                ResourceFishEntity resourceFishEntity = (ResourceFishEntity)entity;
                this.fishPool.add(resourceFishEntity);
                boolean canDrop = !tooManyFish && !breedingBlocked;
                resourceFishEntity.setAllowedToDrop(canDrop);
                if (resourceFishEntity.getTankHome() != this.worldPosition) {
                    resourceFishEntity.setTankHome(this.worldPosition);
                }
                if (!canDrop) continue;
                currentAllowedFish.add(resourceFishEntity.getUUID());
            }
            this.fishCount = this.fishPool.size();
            this.maxFishCount = this.getMaxFish(box);
            HashMap<String, Integer> fishCountMap = new HashMap<String, Integer>();
            for (ResourceFishEntity resourceFishEntity : this.fishPool) {
                String name = resourceFishEntity.getDisplayName().getString();
                fishCountMap.put(name, fishCountMap.getOrDefault(name, 0) + 1);
            }
            this.fishNames.clear();
            for (Map.Entry entry : fishCountMap.entrySet()) {
                int count = (Integer)entry.getValue();
                String display = (String)(count > 1 ? count + "x " : "") + (String)entry.getKey();
                this.fishNames.add(display);
            }
            this.setChanged();
            this.sync();
            this.previouslyAllowedFish.clear();
            this.previouslyAllowedFish.addAll(currentAllowedFish);
        }
    }

    private boolean hasBreedingUpgrade() {
        return this.itemHandler.getStackInSlot(15).is(ResourceFishItems.BREEDING_UPGRADE) || this.itemHandler.getStackInSlot(16).is(ResourceFishItems.BREEDING_UPGRADE) || this.itemHandler.getStackInSlot(17).is(ResourceFishItems.BREEDING_UPGRADE) || this.itemHandler.getStackInSlot(18).is(ResourceFishItems.BREEDING_UPGRADE) || this.itemHandler.getStackInSlot(15).is(ResourceFishItems.INFUSING_UPGRADE) || this.itemHandler.getStackInSlot(16).is(ResourceFishItems.INFUSING_UPGRADE) || this.itemHandler.getStackInSlot(17).is(ResourceFishItems.INFUSING_UPGRADE) || this.itemHandler.getStackInSlot(18).is(ResourceFishItems.INFUSING_UPGRADE);
    }

    private AABB calculateBox(BlockPos centerPos, Direction direction) {
        int widthUpgradeAmount = 0;
        int depthUpgradeAmount = 0;
        for (int i = 15; i <= 18; ++i) {
            ItemStack upgradeStack = this.itemHandler.getStackInSlot(i);
            if (upgradeStack.isEmpty()) continue;
            Item item = upgradeStack.getItem();
            if (item == ResourceFishItems.DEPTH_UPGRADE_1.get()) {
                ++depthUpgradeAmount;
                continue;
            }
            if (item == ResourceFishItems.DEPTH_UPGRADE_2.get()) {
                depthUpgradeAmount += 2;
                continue;
            }
            if (item == ResourceFishItems.DEPTH_UPGRADE_3.get()) {
                depthUpgradeAmount += 3;
                continue;
            }
            if (item == ResourceFishItems.WIDTH_UPGRADE_1.get()) {
                ++widthUpgradeAmount;
                continue;
            }
            if (item == ResourceFishItems.WIDTH_UPGRADE_2.get()) {
                widthUpgradeAmount += 2;
                continue;
            }
            if (item != ResourceFishItems.WIDTH_UPGRADE_3.get()) continue;
            widthUpgradeAmount += 3;
        }
        BlockPos newCenterPositionWidth = centerPos.relative(direction, widthUpgradeAmount);
        BlockPos newCenterPositionDepth = centerPos.relative(direction, depthUpgradeAmount);
        int minX = newCenterPositionWidth.getX() - 1 - widthUpgradeAmount;
        int minZ = newCenterPositionWidth.getZ() - 1 - widthUpgradeAmount;
        int maxX = newCenterPositionWidth.getX() + 2 + widthUpgradeAmount;
        int maxZ = newCenterPositionWidth.getZ() + 2 + widthUpgradeAmount;
        int minY = newCenterPositionDepth.getY() - 1 - depthUpgradeAmount;
        int maxY = newCenterPositionDepth.getY() + 2 + depthUpgradeAmount;
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private void breedingRecipe(Optional<RecipeHolder<FishBreedingRecipe>> match, BlockPos centerPos, ItemStackHandler itemHandler, Level level) {
        if (match.isEmpty()) {
            this.activeRecipe = ActiveRecipeType.NONE;
            this.currentBreedingMatch = Optional.empty();
            this.progress = 0;
            this.maxProgress = Integer.MAX_VALUE;
            return;
        }
        RecipeHolder<FishBreedingRecipe> recipeHolder = match.get();
        this.maxProgress = ((FishBreedingRecipe)recipeHolder.value()).duration();
        ++this.progress;
        if (this.progress >= this.maxProgress) {
            boolean chanceSuccess;
            boolean consumed = false;
            for (int slot = 12; slot <= 14; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!((FishBreedingRecipe)recipeHolder.value()).breedingIngredient().test(stack) || stack.getCount() < ((FishBreedingRecipe)recipeHolder.value()).breedingIngredient().count()) continue;
                stack.shrink(((FishBreedingRecipe)recipeHolder.value()).breedingIngredient().count());
                this.inventoryChanged = true;
                consumed = true;
                break;
            }
            if (!consumed) {
                this.progress = 0;
                this.maxProgress = Integer.MAX_VALUE;
                this.activeRecipe = ActiveRecipeType.NONE;
                this.currentBreedingMatch = Optional.empty();
                return;
            }
            boolean bl = chanceSuccess = level.random.nextDouble() < ((FishBreedingRecipe)recipeHolder.value()).chance();
            if (chanceSuccess) {
                ResourceFishEntity fish = (ResourceFishEntity)ResourceFishEntities.RESOURCE_FISH.get().create(level);
                fish.setResourceType(ResourceType.get(((FishBreedingRecipe)recipeHolder.value()).createdFish()));
                fish.setPos(Vec3.atCenterOf((Vec3i)centerPos));
                level.addFreshEntity((Entity)fish);
            } else {
                ItemEntity bones = new ItemEntity(level, (double)centerPos.getX() + 0.5, (double)(centerPos.getY() + 1), (double)centerPos.getZ() + 0.5, new ItemStack((ItemLike)Items.BONE));
                level.addFreshEntity((Entity)bones);
            }
            this.progress = 0;
            this.maxProgress = Integer.MAX_VALUE;
            this.activeRecipe = ActiveRecipeType.NONE;
            this.currentBreedingMatch = Optional.empty();
        }
    }

    private void infusingRecipe(Optional<RecipeHolder<FishInfusingRecipe>> match, BlockPos centerPos, ItemStackHandler itemHandler, Level level) {
        if (match.isEmpty()) {
            this.activeRecipe = ActiveRecipeType.NONE;
            this.currentInfusingMatch = Optional.empty();
            this.progress = 0;
            this.maxProgress = Integer.MAX_VALUE;
            return;
        }
        RecipeHolder<FishInfusingRecipe> recipeHolder = match.get();
        FishInfusingRecipe recipe = (FishInfusingRecipe)recipeHolder.value();
        this.maxProgress = recipe.duration();
        ++this.progress;
        if (this.progress < this.maxProgress) {
            return;
        }
        NonNullList<SizedIngredient> ingredients = recipe.inputs();
        boolean[] usedSlots = new boolean[3];
        for (SizedIngredient ingredient : ingredients) {
            if (ingredient.ingredient() == Ingredient.EMPTY) continue;
            boolean found = false;
            for (int slot = 0; slot < 3; ++slot) {
                ItemStack stack;
                if (usedSlots[slot] || !ingredient.test(stack = itemHandler.getStackInSlot(12 + slot)) || stack.getCount() < ingredient.count()) continue;
                usedSlots[slot] = true;
                found = true;
                break;
            }
            if (found) continue;
            this.progress = 0;
            this.maxProgress = Integer.MAX_VALUE;
            this.activeRecipe = ActiveRecipeType.NONE;
            this.currentInfusingMatch = Optional.empty();
            return;
        }
        block2: for (int i = 0; i < ingredients.size(); ++i) {
            SizedIngredient ingredient;
            ingredient = (SizedIngredient)ingredients.get(i);
            if (ingredient.ingredient() == Ingredient.EMPTY) continue;
            for (int slot = 0; slot < 3; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(12 + slot);
                if (!ingredient.test(stack) || stack.getCount() < ingredient.count()) continue;
                stack.shrink(ingredient.count());
                usedSlots[slot] = true;
                continue block2;
            }
        }
        this.inventoryChanged = true;
        if (level.random.nextDouble() < recipe.chance()) {
            for (ResourceFishEntity fish : this.fishPool) {
                if (!recipe.fish().equals((Object)fish.getResourceType().getId())) continue;
                fish.setResourceType(ResourceType.get(recipe.createdFish()));
                break;
            }
        } else {
            ItemEntity bones = new ItemEntity(level, (double)centerPos.getX() + 0.5, (double)(centerPos.getY() + 1), (double)centerPos.getZ() + 0.5, new ItemStack((ItemLike)Items.BONE));
            level.addFreshEntity((Entity)bones);
        }
        this.progress = 0;
        this.maxProgress = Integer.MAX_VALUE;
        this.activeRecipe = ActiveRecipeType.NONE;
        this.currentInfusingMatch = Optional.empty();
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putInt("fishCount", this.fishCount);
        compoundTag.putInt("maxFishCount", this.maxFishCount);
        compoundTag.putBoolean("showRange", this.showRange);
        ListTag fishList = new ListTag();
        for (String fishName : this.fishNames) {
            fishList.add((Object)StringTag.valueOf((String)fishName));
        }
        compoundTag.put("fishNames", (Tag)fishList);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        super.loadAdditional(compoundTag, provider);
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.fishCount = compoundTag.getInt("fishCount");
        this.maxFishCount = compoundTag.getInt("maxFishCount");
        this.showRange = compoundTag.getBoolean("showRange");
        this.fishNames.clear();
        ListTag fishList = compoundTag.getList("fishNames", 8);
        for (int i = 0; i < fishList.size(); ++i) {
            this.fishNames.add(fishList.getString(i));
        }
    }

    public void onRightClick(ServerPlayer player) {
        if (this.showRange) {
            this.showRange = false;
        } else {
            this.showRange = true;
            player.sendSystemMessage((Component)Component.translatable((String)"block.resourcefish.tank_controller_range"));
        }
        this.sync();
    }

    private int simulateInsertStack(ItemStackHandler itemHandler, ItemStack stack, int[] slots) {
        ItemStack slotStack;
        ItemStack copy = stack.copy();
        for (int slot : slots) {
            slotStack = itemHandler.getStackInSlot(slot);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)copy)) continue;
            int spaceLeft = slotStack.getMaxStackSize() - slotStack.getCount();
            int toAdd = Math.min(spaceLeft, copy.getCount());
            copy.shrink(toAdd);
            if (!copy.isEmpty()) continue;
            return 0;
        }
        for (int slot : slots) {
            slotStack = itemHandler.getStackInSlot(slot);
            if (!slotStack.isEmpty()) continue;
            int toAdd = Math.min(copy.getMaxStackSize(), copy.getCount());
            copy.shrink(toAdd);
            if (!copy.isEmpty()) continue;
            return 0;
        }
        return copy.getCount();
    }

    private void spawnBoxOutlineParticles(AABB box) {
        if (this.level.isClientSide) {
            for (double x = box.minX; x <= box.maxX; x += 0.25) {
                for (double y = box.minY; y <= box.maxY; y += 0.25) {
                    for (double z = box.minZ; z <= box.maxZ; z += 0.25) {
                        boolean onZEdge;
                        boolean onXEdge = x == box.minX || x == box.maxX;
                        boolean onYEdge = y == box.minY || y == box.maxY;
                        boolean bl = onZEdge = z == box.minZ || z == box.maxZ;
                        if (!(onXEdge && onYEdge || onXEdge && onZEdge) && (!onYEdge || !onZEdge)) continue;
                        this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public void insertStackIntoSlots(ItemStackHandler itemHandler, ItemStack stack, int[] slots) {
        ItemStack slotStack;
        for (int slot : slots) {
            int maxStackSize;
            int spaceLeft;
            slotStack = itemHandler.getStackInSlot(slot);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) <= 0) continue;
            int toAdd = Math.min(spaceLeft, stack.getCount());
            slotStack.grow(toAdd);
            stack.shrink(toAdd);
            if (!stack.isEmpty()) continue;
            return;
        }
        for (int slot : slots) {
            slotStack = itemHandler.getStackInSlot(slot);
            if (!slotStack.isEmpty()) continue;
            int toAdd = Math.min(stack.getMaxStackSize(), stack.getCount());
            itemHandler.setStackInSlot(slot, stack.copyWithCount(toAdd));
            stack.shrink(toAdd);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

