/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.block;

import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NestBlock
extends Block {
    public NestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        if (!level.isClientSide()) {
            int amount = level.random.nextInt(4) + 1;
            for (int i = 0; i < amount; ++i) {
                ResourceFishEntity fish = (ResourceFishEntity)ResourceFishEntities.RESOURCE_FISH.get().create(level);
                double offsetX = (level.random.nextDouble() - 0.5) * 2.0;
                double offsetZ = (level.random.nextDouble() - 0.5) * 2.0;
                if (fish == null) continue;
                fish.setPos((double)pos.getX() + offsetX, pos.getY(), (double)pos.getZ() + offsetZ);
                fish.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.TRIGGERED, null);
                level.addFreshEntity((Entity)fish);
            }
        }
        super.playerDestroy(level, player, pos, state, be, stack);
    }
}

