/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.common.block.BaseComfortsBlock;
import com.illusivesoulworks.comforts.common.block.RopeAndNailBlock;
import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.illusivesoulworks.comforts.common.block.entity.HammockBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HammockBlock
extends BaseComfortsBlock {
    private static final VoxelShape HAMMOCK_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(BaseComfortsBlock.BedType.HAMMOCK, color, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOL).sound(SoundType.WOOL).strength(0.1f));
        this.color = color;
    }

    public static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.getOpposite();
    }

    @Override
    protected boolean canRest() {
        return (Boolean)ComfortsConfig.SERVER.hammocksStopPhantoms.get();
    }

    public static void dropRopeSupport(BlockPos pos, Direction direction, boolean isHead, Level level) {
        BlockPos ropePos = isHead ? pos.relative(direction) : pos.relative(direction.getOpposite());
        BlockState ropeState = level.getBlockState(ropePos);
        if (ropeState.getBlock() instanceof RopeAndNailBlock) {
            level.setBlockAndUpdate(ropePos, (BlockState)ropeState.setValue((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction direction = HammockBlock.getConnectedDirection((BlockState)state).getOpposite();
        return switch (direction) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> HAMMOCK_SHAPE;
        };
    }

    @Override
    public BlockState playerWillDestroy(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        super.playerWillDestroy(level, pos, state, player);
        BedPart bedpart = (BedPart)state.getValue((Property)PART);
        boolean isHead = bedpart == BedPart.HEAD;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(HammockBlock.getDirectionToOther(bedpart, direction));
        HammockBlock.dropRopeSupport(pos, direction, isHead, level);
        HammockBlock.dropRopeSupport(otherPos, direction, !isHead, level);
        return state;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        FluidState ifluidstate = context.getLevel().getFluidState(blockpos);
        return context.getLevel().getBlockState(blockpos1).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)BaseComfortsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER)) : null;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new HammockBlockEntity(pos, state, this.color);
    }

    @Override
    public BlockEntityType<? extends BaseComfortsBlockEntity> getBlockEntityType() {
        return ComfortsRegistry.HAMMOCK_BLOCK_ENTITY.get();
    }
}

