/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.infinitystorage.block.entity.handlers;

import com.benbenlaw.infinitystorage.item.InfinityDrive;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class InfinityDriveFluidHandler
implements IFluidHandler {
    private final InfinityDrive drive;

    public InfinityDriveFluidHandler(InfinityDrive drive) {
        this.drive = drive;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        if (this.drive.getContent().isFluid()) {
            return this.drive.getContent().getInfinityFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.drive.getContent().isFluid() && stack.is(this.drive.getContent().getInfinityFluidStack().getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return resource.getAmount();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.drive.getContent().isFluid() && resource.is(this.drive.getContent().getInfinityFluidStack().getFluid())) {
            return new FluidStack(this.drive.getContent().getInfinityFluidStack().getFluid(), resource.getAmount());
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.drive.getContent().isFluid()) {
            FluidStack copy = this.drive.getContent().getInfinityFluidStack().copy();
            copy.setAmount(maxDrain);
            return copy;
        }
        return FluidStack.EMPTY;
    }
}

