/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.infinitystorage.block.entity;

import com.benbenlaw.infinitystorage.block.ISBlockEntities;
import com.benbenlaw.infinitystorage.block.custom.IInventoryHandlingBlockEntity;
import com.benbenlaw.infinitystorage.block.custom.InputOutputItemHandler;
import com.benbenlaw.infinitystorage.item.InfinityContent;
import com.benbenlaw.infinitystorage.item.InfinityDrive;
import com.benbenlaw.infinitystorage.screen.InfinityStorageDriveMenu;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityStorageDriveBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            InfinityStorageDriveBlockEntity.this.setChanged();
            InfinityStorageDriveBlockEntity.this.sync();
        }
    };
    private FakePlayer fakePlayer;
    private final IItemHandler driveItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> stack.getItem() instanceof InfinityDrive, i -> true){

        @Override
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            ItemStack driveStack = super.getStackInSlot(slot);
            Item item = driveStack.getItem();
            if (item instanceof InfinityDrive) {
                InfinityDrive drive = (InfinityDrive)item;
                InfinityContent content = drive.getContent();
                if (content.isItem()) {
                    ItemStack copy = content.getInfinityStack().copy();
                    copy.setCount(Integer.MAX_VALUE);
                    return copy;
                }
                return ItemStack.EMPTY;
            }
            return driveStack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack driveStack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(slot);
            Item item = driveStack.getItem();
            if (item instanceof InfinityDrive) {
                InfinityDrive drive = (InfinityDrive)item;
                InfinityContent content = drive.getContent();
                if (content.isItem()) {
                    return new ItemStack((ItemLike)content.getInfinityStack().getItem(), amount);
                }
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            InfinityDrive drive;
            InfinityContent content;
            ItemStack driveStack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(slot);
            Item item = driveStack.getItem();
            if (item instanceof InfinityDrive && (content = (drive = (InfinityDrive)item).getContent()).isItem() && stack.is(content.getInfinityStack().getItem())) {
                return ItemStack.EMPTY;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    };
    private final IFluidHandler driveFluidHandler = new IFluidHandler(){

        public int getTanks() {
            return InfinityStorageDriveBlockEntity.this.itemHandler.getSlots();
        }

        public FluidStack getFluidInTank(int tank) {
            InfinityDrive drive;
            InfinityContent content;
            ItemStack stack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(tank);
            Item item = stack.getItem();
            if (item instanceof InfinityDrive && (content = (drive = (InfinityDrive)item).getContent()).isFluid()) {
                FluidStack copy = content.getInfinityFluidStack().copy();
                copy.setAmount(Integer.MAX_VALUE);
                return copy;
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            InfinityDrive drive;
            ItemStack stack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(tank);
            Item item = stack.getItem();
            if (item instanceof InfinityDrive && (drive = (InfinityDrive)item).getContent().isFluid()) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            ItemStack driveStack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(tank);
            Item item = driveStack.getItem();
            if (item instanceof InfinityDrive) {
                InfinityDrive drive = (InfinityDrive)item;
                InfinityContent content = drive.getContent();
                return content.isFluid() && stack.is(content.getInfinityFluidStack().getFluid());
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < InfinityStorageDriveBlockEntity.this.itemHandler.getSlots(); ++i) {
                InfinityDrive drive;
                InfinityContent content;
                ItemStack stack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof InfinityDrive) || !(content = (drive = (InfinityDrive)item).getContent()).isFluid() || !resource.is(content.getInfinityFluidStack().getFluid())) continue;
                FluidStack copy = content.getInfinityFluidStack().copy();
                copy.setAmount(resource.getAmount());
                return copy;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (int i = 0; i < InfinityStorageDriveBlockEntity.this.itemHandler.getSlots(); ++i) {
                InfinityDrive drive;
                InfinityContent content;
                ItemStack stack = InfinityStorageDriveBlockEntity.this.itemHandler.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof InfinityDrive) || !(content = (drive = (InfinityDrive)item).getContent()).isFluid()) continue;
                FluidStack copy = content.getInfinityFluidStack().copy();
                copy.setAmount(maxDrain);
                return copy;
            }
            return FluidStack.EMPTY;
        }
    };

    public InfinityStorageDriveBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ISBlockEntities.INFINITY_STORAGE_DRIVE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.driveItemHandler;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.driveFluidHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public void tick() {
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinitystorage.infinity_storage_drive");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new InfinityStorageDriveMenu(container, inventory, this.getBlockPos());
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

