/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.particle.ParticleRotating;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ParticleItem
extends ParticleRotating {
    public static HashSet<String> itemBlacklist = new HashSet();
    public BakedModel bakedModel;
    public ItemStack itemStack;
    private final RenderBuffers renderBuffers;
    private final EntityRenderDispatcher entityRenderDispatcher;
    public float xFrom;
    public float yFrom;
    public float zFrom;
    public float xTo;
    public float yTo;
    public float zTo;

    public ParticleItem(ClientLevel pLevel, float brightness, ItemStack itemStack, RenderBuffers renderBuffers, EntityRenderDispatcher entityRenderDispatcher, float xFrom, float yFrom, float zFrom, float xTo, float yTo, float zTo) {
        super(pLevel, xFrom, yFrom, zFrom);
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.setSize(0.2f, 0.2f);
        this.quadSize = 1.0f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xFrom = xFrom;
        this.yFrom = yFrom;
        this.zFrom = zFrom;
        this.xTo = xTo;
        this.yTo = yTo;
        this.zTo = zTo;
        this.setColor(this.getColorRed() * brightness, this.getColorGreen() * brightness, this.getColorBlue() * brightness);
        this.bakedModel = Minecraft.getInstance().getItemRenderer().getModel(itemStack, (Level)Minecraft.getInstance().level, null, 0);
        this.itemStack = itemStack;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.rotationYaw = pLevel.getRandom().nextFloat() * 360.0f;
        this.renderBuffers = renderBuffers;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL;
    }

    protected float getU0() {
        return this.bakedModel.getParticleIcon().getU0();
    }

    protected float getU1() {
        return this.bakedModel.getParticleIcon().getU1();
    }

    protected float getV0() {
        return this.bakedModel.getParticleIcon().getV0();
    }

    protected float getV1() {
        return this.bakedModel.getParticleIcon().getV1();
    }

    public void setSize(float pWidth, float pHeight) {
        super.setSize(pWidth, pHeight);
    }

    @Override
    public void tick() {
        super.tick();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= 6) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    @Override
    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (itemBlacklist.contains(this.itemStack.getItem().toString())) {
            return;
        }
        Vec3 vec3 = pRenderInfo.getPosition();
        float f = (float)Mth.lerp((double)pPartialTicks, (double)this.xo, (double)this.x);
        float f1 = (float)Mth.lerp((double)pPartialTicks, (double)this.yo, (double)this.y);
        float f2 = (float)Mth.lerp((double)pPartialTicks, (double)this.zo, (double)this.z);
        float lerp = ((float)this.age + pPartialTicks) / 3.0f;
        double d0 = this.xTo;
        double d1 = this.yTo;
        double d2 = this.zTo;
        double x = Mth.lerp((double)lerp, (double)f, (double)d0);
        double y = Mth.lerp((double)lerp, (double)f1, (double)d1);
        double z = Mth.lerp((double)lerp, (double)f2, (double)d2);
        if (this.age >= 3) {
            x = this.xTo;
            y = this.yTo;
            z = this.zTo;
        }
        x -= vec3.x();
        y -= vec3.y();
        z -= vec3.z();
        int j = this.getLightColor(pPartialTicks);
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(this.rotationYaw));
        PoseStack pose = new PoseStack();
        pose.pushPose();
        pose.translate(x, y, z);
        pose.scale(this.quadSize, this.quadSize, this.quadSize);
        pose.rotateAround(quaternion, 0.0f, 1.0f, 0.0f);
        try {
            Minecraft.getInstance().getItemRenderer().render(this.itemStack, ItemDisplayContext.GROUND, false, pose, (MultiBufferSource)this.renderBuffers.bufferSource(), j, OverlayTexture.NO_OVERLAY, this.bakedModel);
            this.renderBuffers.bufferSource().endBatch();
        }
        catch (Exception exception) {
            CULog.err((String)("ERROR, exception trying to render item: " + this.itemStack.getItem().toString() + " - adding to ParticleItem render blacklist for this minecraft session"));
            itemBlacklist.add(this.itemStack.getItem().toString());
            exception.printStackTrace();
        }
    }
}

