/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block.entity;

import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.ImporterBlockEntity;
import com.benbenlaw.routers.block.entity.MekanismCompat;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.config.StartupConfig;
import com.benbenlaw.routers.integration.RoutersCapabilities;
import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.item.UpgradeItem;
import com.benbenlaw.routers.screen.ExporterMenu;
import com.benbenlaw.routers.screen.util.FluidContainerHelper;
import com.benbenlaw.routers.util.RoutersTags;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExporterBlockEntity
extends BlockEntity
implements MenuProvider,
IAttachmentHolder {
    private List<BlockPos> importerPositions;
    public final ContainerData data;
    private String dimension = "";
    private final Map<BlockPos, ImporterBlockEntity> importerCache = new HashMap<BlockPos, ImporterBlockEntity>();
    private final NonNullList<ItemStack> filters = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    private final NonNullList<FluidStack> fluidFilters = NonNullList.withSize((int)18, (Object)FluidStack.EMPTY);
    private final NonNullList<?> chemicalFilters;
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            ExporterBlockEntity.this.setChanged();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.is(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (i == slot || !this.getStackInSlot(i).is(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) continue;
                    return false;
                }
                return true;
            }
            return stack.is(RoutersTags.Items.UPGRADES);
        }
    };
    private int lastRoundRobinIndex = 0;
    private final Map<BlockPos, Map<BlockPos, Double>> particleProgress = new HashMap<BlockPos, Map<BlockPos, Double>>();

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.routers.exporter_block");
    }

    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ExporterMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public ExporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RoutersBlockEntities.EXPORTER_BLOCK_ENTITY.get(), pos, state);
        this.importerPositions = new ArrayList<BlockPos>();
        this.chemicalFilters = ModList.get().isLoaded("mekanism") ? MekanismCompat.createChemicalFilters() : NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
        this.data = new ContainerData(this){

            public int get(int index) {
                return 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 0;
            }
        };
    }

    public String getDimension() {
        return this.dimension;
    }

    public String setDimension(String dimension) {
        this.dimension = dimension;
        return this.dimension;
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public NonNullList<FluidStack> getFluidFilters() {
        return this.fluidFilters;
    }

    public NonNullList<?> getChemicalFilters() {
        return this.chemicalFilters;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public void toggleImporter(BlockPos importerPos, Player player) {
        if (this.importerPositions.contains(importerPos)) {
            this.importerPositions.remove(importerPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.routers.exporter.remove_importer"), true);
        } else {
            this.importerPositions.add(importerPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.routers.exporter.add_importer"), true);
        }
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
        this.setChanged();
    }

    public void tick() {
        block72: {
            Optional targetHeatHandler;
            block77: {
                int maxTransfer;
                float available;
                IAirHandlerMachine source;
                block78: {
                    Optional targetAirHandler;
                    block75: {
                        ImporterBlockEntity importer;
                        int maxTransfer2;
                        ISoulHandler targetSoulHandler;
                        block76: {
                            ImporterBlockEntity be;
                            block73: {
                                ISourceCap targetSourceHandler;
                                block74: {
                                    int canReceive;
                                    int canExtract;
                                    int transferAmount;
                                    ImporterBlockEntity importer2;
                                    ISourceCap importerSource;
                                    Object importerFilters;
                                    ImporterBlockEntity importer3;
                                    ImporterBlockEntity importer4;
                                    ImporterBlockEntity be2;
                                    BlockPos importerPos4;
                                    int attempts;
                                    int slot;
                                    int maxTransfer3;
                                    if (this.level == null || this.level.isClientSide) {
                                        return;
                                    }
                                    if (this.level.getGameTime() % 10L == 0L) {
                                        this.removeInvalidImporters();
                                    }
                                    if (this.dimension == null || this.dimension.isEmpty()) {
                                        this.dimension = this.level.dimension().location().toString();
                                        this.setChanged();
                                    }
                                    Direction facing = (Direction)this.getBlockState().getValue((Property)ImporterBlock.FACING);
                                    BlockPos targetPos = this.worldPosition.relative(facing);
                                    assert (this.level != null);
                                    BlockEntity targetBlockEntity = this.level.getBlockEntity(targetPos);
                                    Direction inputDirection = facing.getOpposite();
                                    int speedPerOperation = this.getSpeedPerOperation();
                                    IEnergyStorage targetEnergyStorage = (IEnergyStorage)Capabilities.EnergyStorage.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                                    if (targetEnergyStorage != null && this.hasUpgrade(RoutersTags.Items.RF_UPGRADES)) {
                                        int maxTransfer4 = this.getExtractAmount(RoutersTags.Items.RF_UPGRADES);
                                        if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                                            if (!this.importerPositions.isEmpty()) {
                                                int canExtract2;
                                                int canReceive2;
                                                int transferAmount2;
                                                ImporterBlockEntity importer5;
                                                IEnergyStorage importerEnergy;
                                                int index = this.lastRoundRobinIndex % this.importerPositions.size();
                                                BlockPos importerPos2 = this.importerPositions.get(index);
                                                ImporterBlockEntity be3 = this.findImporter(importerPos2);
                                                if (be3 instanceof ImporterBlockEntity && (importerEnergy = (importer5 = be3).getEnergyStorage()) != null && (transferAmount2 = Math.min(canReceive2 = importerEnergy.receiveEnergy(maxTransfer4, true), canExtract2 = targetEnergyStorage.extractEnergy(maxTransfer4, true))) > 0) {
                                                    targetEnergyStorage.extractEnergy(transferAmount2, false);
                                                    importerEnergy.receiveEnergy(transferAmount2, false);
                                                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                                    return;
                                                }
                                                this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                            }
                                        } else {
                                            for (BlockPos importerPos2 : this.importerPositions) {
                                                int canExtract3;
                                                int canReceive3;
                                                int transferAmount3;
                                                IEnergyStorage importerEnergy;
                                                ImporterBlockEntity importer6 = this.findImporter(importerPos2);
                                                if (importer6 == null || (importerEnergy = importer6.getEnergyStorage()) == null || (transferAmount3 = Math.min(canReceive3 = importerEnergy.receiveEnergy(maxTransfer4, true), canExtract3 = targetEnergyStorage.extractEnergy(maxTransfer4, true))) <= 0) continue;
                                                targetEnergyStorage.extractEnergy(transferAmount3, false);
                                                importerEnergy.receiveEnergy(transferAmount3, false);
                                                maxTransfer4 -= transferAmount3;
                                            }
                                        }
                                    }
                                    if (this.level.getGameTime() % (long)speedPerOperation != 0L || targetBlockEntity == null) break block72;
                                    IItemHandler targetItemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                                    IFluidHandler targetFluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                                    IChemicalHandler targetChemicalHandler = ModList.get().isLoaded("mekanism") ? (IChemicalHandler)RoutersCapabilities.CHEMICAL_HANDLER.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection) : null;
                                    targetSourceHandler = ModList.get().isLoaded("ars_nouveau") ? (ISourceCap)CapabilityRegistry.SOURCE_CAPABILITY.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection) : null;
                                    targetSoulHandler = ModList.get().isLoaded("industrialforegoingsouls") ? (ISoulHandler)SoulCapabilities.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection) : null;
                                    targetAirHandler = ModList.get().isLoaded("pneumaticcraft") ? PNCCapabilities.getAirHandler((BlockEntity)targetBlockEntity, (Direction)inputDirection) : Optional.empty();
                                    Optional optional = targetHeatHandler = ModList.get().isLoaded("pneumaticcraft") ? PNCCapabilities.getHeatLogic((BlockEntity)targetBlockEntity, (Direction)inputDirection) : Optional.empty();
                                    if (targetItemHandler != null && this.hasUpgrade(RoutersTags.Items.ITEM_UPGRADES)) {
                                        List<Item> expandedExporterFilters = this.expandFilters(this.getFilters());
                                        maxTransfer3 = this.getExtractAmount(RoutersTags.Items.ITEM_UPGRADES);
                                        for (slot = 0; slot < targetItemHandler.getSlots(); ++slot) {
                                            boolean allowByExporter;
                                            ItemStack extracted = targetItemHandler.extractItem(slot, maxTransfer3, true);
                                            if (extracted.isEmpty()) continue;
                                            boolean bl = allowByExporter = expandedExporterFilters.isEmpty() || expandedExporterFilters.contains(extracted.getItem());
                                            if (!allowByExporter) continue;
                                            if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                                                if (this.importerPositions.isEmpty()) continue;
                                                int index = this.lastRoundRobinIndex % this.importerPositions.size();
                                                for (attempts = 0; attempts < this.importerPositions.size(); ++attempts) {
                                                    IItemHandler importerHandler;
                                                    importerPos4 = this.importerPositions.get(index);
                                                    be2 = this.findImporter(importerPos4);
                                                    if (be2 instanceof ImporterBlockEntity && (importerHandler = (importer4 = be2).getTargetHandler()) != null) {
                                                        boolean allowByImporter;
                                                        List<Item> expandedImporterFilters = this.expandFilters(importer4.getFilters());
                                                        boolean bl2 = allowByImporter = expandedImporterFilters.isEmpty() || expandedImporterFilters.contains(extracted.getItem());
                                                        if (allowByImporter) {
                                                            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)importerHandler, (ItemStack)extracted, (boolean)false);
                                                            int inserted = extracted.getCount() - remainder.getCount();
                                                            if (inserted > 0) {
                                                                targetItemHandler.extractItem(slot, inserted, false);
                                                                this.lastRoundRobinIndex = (index + 1) % this.importerPositions.size();
                                                                return;
                                                            }
                                                        }
                                                    }
                                                    index = (index + 1) % this.importerPositions.size();
                                                }
                                                this.lastRoundRobinIndex = index;
                                                continue;
                                            }
                                            for (BlockPos importerPos3 : this.importerPositions) {
                                                boolean allowByImporter;
                                                IItemHandler importerHandler;
                                                importer3 = this.findImporter(importerPos3);
                                                if (importer3 == null || (importerHandler = importer3.getTargetHandler()) == null) continue;
                                                importerFilters = importer3.getFilters();
                                                List<Item> expandedImporterFilters = this.expandFilters(importer3.getFilters());
                                                boolean bl3 = allowByImporter = expandedImporterFilters.isEmpty() || expandedImporterFilters.contains(extracted.getItem());
                                                if (!allowByImporter) continue;
                                                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)importerHandler, (ItemStack)extracted, (boolean)false);
                                                int inserted = extracted.getCount() - remainder.getCount();
                                                if (inserted <= 0) continue;
                                                targetItemHandler.extractItem(slot, inserted, false);
                                                return;
                                            }
                                        }
                                    }
                                    if (targetFluidHandler != null && this.hasUpgrade(RoutersTags.Items.FLUID_UPGRADES)) {
                                        NonNullList<FluidStack> exporterFluidFilters = this.getFluidFilters();
                                        maxTransfer3 = this.getExtractAmount(RoutersTags.Items.FLUID_UPGRADES);
                                        for (slot = 0; slot < targetFluidHandler.getTanks(); ++slot) {
                                            boolean allowByExporter;
                                            FluidStack tankFluid = targetFluidHandler.getFluidInTank(slot);
                                            if (tankFluid.isEmpty()) continue;
                                            FluidStack simulatedDrain = new FluidStack(tankFluid.getFluidHolder(), Math.min(maxTransfer3, tankFluid.getAmount()));
                                            boolean bl = allowByExporter = exporterFluidFilters.stream().allMatch(FluidStack::isEmpty) || exporterFluidFilters.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain));
                                            if (!allowByExporter) continue;
                                            if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                                                IFluidHandler importerFluid;
                                                if (this.importerPositions.isEmpty()) continue;
                                                int index = this.lastRoundRobinIndex % this.importerPositions.size();
                                                importerPos4 = this.importerPositions.get(index);
                                                be2 = this.findImporter(importerPos4);
                                                if (be2 instanceof ImporterBlockEntity && (importerFluid = (importer4 = be2).getFluidHandler()) != null) {
                                                    int canReceive4;
                                                    boolean allowByImporter;
                                                    NonNullList<FluidStack> importerFilters2 = importer4.getFluidFilters();
                                                    boolean bl4 = allowByImporter = importerFilters2.stream().allMatch(FluidStack::isEmpty) || importerFilters2.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain));
                                                    if (allowByImporter && (canReceive4 = importerFluid.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                                                        FluidStack request = new FluidStack(simulatedDrain.getFluid(), canReceive4);
                                                        FluidStack extracted = targetFluidHandler.drain(request, IFluidHandler.FluidAction.EXECUTE);
                                                        importerFluid.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                                                        this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                                        return;
                                                    }
                                                }
                                                this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                                continue;
                                            }
                                            for (BlockPos importerPos4 : this.importerPositions) {
                                                int canReceive5;
                                                NonNullList<FluidStack> importerFilters3;
                                                boolean allowByImporter;
                                                IFluidHandler importerFluid;
                                                ImporterBlockEntity importer7 = this.findImporter(importerPos4);
                                                if (importer7 == null || (importerFluid = importer7.getFluidHandler()) == null || !(allowByImporter = (importerFilters3 = importer7.getFluidFilters()).stream().allMatch(FluidStack::isEmpty) || importerFilters3.stream().anyMatch(f -> !f.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)simulatedDrain))) || (canReceive5 = importerFluid.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                                                FluidStack request = new FluidStack(simulatedDrain.getFluid(), canReceive5);
                                                FluidStack extracted = targetFluidHandler.drain(request, IFluidHandler.FluidAction.EXECUTE);
                                                importerFluid.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                                                return;
                                            }
                                        }
                                    }
                                    if (targetChemicalHandler != null && this.hasUpgrade(RoutersTags.Items.CHEMICAL_UPGRADES)) {
                                        final NonNullList<?> exporterFilters = this.getChemicalFilters();
                                        maxTransfer3 = this.getExtractAmount(RoutersTags.Items.CHEMICAL_UPGRADES);
                                        final var isEmptyFilter = new Predicate<Object>(this){

                                            @Override
                                            public boolean test(Object f) {
                                                if (f == null) {
                                                    return true;
                                                }
                                                if (f == MekanismCompat.EMPTY_CHEMICAL) {
                                                    return true;
                                                }
                                                try {
                                                    Method m = f.getClass().getMethod("isEmpty", new Class[0]);
                                                    Object r = m.invoke(f, new Object[0]);
                                                    if (r instanceof Boolean) {
                                                        return (Boolean)r;
                                                    }
                                                }
                                                catch (NoSuchMethodException noSuchMethodException) {
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                return false;
                                            }
                                        };
                                        final var matchesFilter = new BiPredicate<Object, Object>(this){

                                            @Override
                                            public boolean test(Object filter, Object chemStack) {
                                                if (filter == null) {
                                                    return true;
                                                }
                                                if (filter == MekanismCompat.EMPTY_CHEMICAL) {
                                                    return true;
                                                }
                                                if (chemStack == null) {
                                                    return false;
                                                }
                                                try {
                                                    if (filter.equals(chemStack)) {
                                                        return true;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                try {
                                                    if (chemStack.equals(filter)) {
                                                        return true;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                try {
                                                    Method getTypeMethod = null;
                                                    for (String name : new String[]{"getType", "getChemical", "getDefinition", "getLeft"}) {
                                                        try {
                                                            getTypeMethod = filter.getClass().getMethod(name, new Class[0]);
                                                            break;
                                                        }
                                                        catch (NoSuchMethodException noSuchMethodException) {
                                                        }
                                                    }
                                                    Method chemGetTypeMethod = null;
                                                    Class<?> chemClass = chemStack.getClass();
                                                    for (String name : new String[]{"getType", "getChemical", "getDefinition", "getLeft"}) {
                                                        try {
                                                            chemGetTypeMethod = chemClass.getMethod(name, new Class[0]);
                                                            break;
                                                        }
                                                        catch (NoSuchMethodException noSuchMethodException) {
                                                        }
                                                    }
                                                    if (getTypeMethod != null && chemGetTypeMethod != null) {
                                                        Object fType = getTypeMethod.invoke(filter, new Object[0]);
                                                        Object cType = chemGetTypeMethod.invoke(chemStack, new Object[0]);
                                                        if (fType != null && fType.equals(cType)) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                return false;
                                            }
                                        };
                                        var exporterAllows = new Predicate<Object>(){

                                            @Override
                                            public boolean test(Object chemStack) {
                                                boolean allEmpty = true;
                                                for (Object f : exporterFilters) {
                                                    if (isEmptyFilter.test(f)) continue;
                                                    allEmpty = false;
                                                    break;
                                                }
                                                if (allEmpty) {
                                                    return true;
                                                }
                                                for (Object f : exporterFilters) {
                                                    if (isEmptyFilter.test(f) || !matchesFilter.test(f, chemStack)) continue;
                                                    return true;
                                                }
                                                return false;
                                            }
                                        };
                                        if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                                            if (!this.importerPositions.isEmpty()) {
                                                int index = this.lastRoundRobinIndex % this.importerPositions.size();
                                                for (attempts = 0; attempts < this.importerPositions.size(); ++attempts) {
                                                    IChemicalHandler importerChem;
                                                    importerPos4 = this.importerPositions.get(index);
                                                    be2 = this.findImporter(importerPos4);
                                                    if (be2 instanceof ImporterBlockEntity && (importerChem = (importer4 = be2).getChemicalHandler()) != null) {
                                                        NonNullList<?> importerFilters4 = importer4.getChemicalFilters();
                                                        for (int tank = 0; tank < targetChemicalHandler.getChemicalTanks(); ++tank) {
                                                            Object toExtract;
                                                            ChemicalStack tankStack = targetChemicalHandler.getChemicalInTank(tank);
                                                            if (tankStack == null) continue;
                                                            boolean isTankEmpty = false;
                                                            try {
                                                                Method isEmptyM = tankStack.getClass().getMethod("isEmpty", new Class[0]);
                                                                Object r = isEmptyM.invoke((Object)tankStack, new Object[0]);
                                                                if (r instanceof Boolean) {
                                                                    isTankEmpty = (Boolean)r;
                                                                }
                                                            }
                                                            catch (Throwable isEmptyM) {
                                                                // empty catch block
                                                            }
                                                            if (isTankEmpty || !exporterAllows.test(tankStack)) continue;
                                                            boolean importerAllEmpty = true;
                                                            for (Object f2 : importerFilters4) {
                                                                if (isEmptyFilter.test(f2)) continue;
                                                                importerAllEmpty = false;
                                                                break;
                                                            }
                                                            if (!importerAllEmpty) {
                                                                Object f2;
                                                                boolean anyMatch = false;
                                                                f2 = importerFilters4.iterator();
                                                                while (f2.hasNext()) {
                                                                    Object f3 = f2.next();
                                                                    if (isEmptyFilter.test(f3) || !matchesFilter.test(f3, tankStack)) continue;
                                                                    anyMatch = true;
                                                                    break;
                                                                }
                                                                if (!anyMatch) continue;
                                                            }
                                                            try {
                                                                Method copyM = tankStack.getClass().getMethod("copy", new Class[0]);
                                                                toExtract = copyM.invoke((Object)tankStack, new Object[0]);
                                                                try {
                                                                    Method setAmount = toExtract.getClass().getMethod("setAmount", Long.TYPE);
                                                                    long amount = Math.min((Long)toExtract.getClass().getMethod("getAmount", new Class[0]).invoke((Object)tankStack, new Object[0]), (long)maxTransfer3);
                                                                    setAmount.invoke(toExtract, amount);
                                                                }
                                                                catch (NoSuchMethodException setAmount) {}
                                                            }
                                                            catch (Throwable t) {
                                                                continue;
                                                            }
                                                            try {
                                                                Method insertSim = importerChem.getClass().getMethod("insertChemical", toExtract.getClass(), Action.class);
                                                                Object remainder = insertSim.invoke((Object)importerChem, toExtract, Action.SIMULATE);
                                                                long beforeAmount = (Long)toExtract.getClass().getMethod("getAmount", new Class[0]).invoke(toExtract, new Object[0]);
                                                                long remainderAmount = (Long)remainder.getClass().getMethod("getAmount", new Class[0]).invoke(remainder, new Object[0]);
                                                                long inserted = beforeAmount - remainderAmount;
                                                                if (inserted <= 0L) continue;
                                                                Method extractExec = targetChemicalHandler.getClass().getMethod("extractChemical", Long.TYPE, Action.class);
                                                                Object extracted = extractExec.invoke((Object)targetChemicalHandler, inserted, Action.EXECUTE);
                                                                Method insertExec = importerChem.getClass().getMethod("insertChemical", extracted.getClass(), Action.class);
                                                                insertExec.invoke((Object)importerChem, extracted, Action.EXECUTE);
                                                                this.lastRoundRobinIndex = (index + 1) % this.importerPositions.size();
                                                                return;
                                                            }
                                                            catch (Throwable e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    index = (index + 1) % this.importerPositions.size();
                                                }
                                                this.lastRoundRobinIndex = index;
                                            }
                                        } else {
                                            for (BlockPos importerPos5 : this.importerPositions) {
                                                IChemicalHandler importerChem;
                                                importer3 = this.findImporter(importerPos5);
                                                if (importer3 == null || (importerChem = importer3.getChemicalHandler()) == null) continue;
                                                importerFilters = importer3.getChemicalFilters();
                                                for (int tank = 0; tank < targetChemicalHandler.getChemicalTanks(); ++tank) {
                                                    Object toExtract;
                                                    ChemicalStack tankStack = targetChemicalHandler.getChemicalInTank(tank);
                                                    if (tankStack == null) continue;
                                                    boolean isTankEmpty = false;
                                                    try {
                                                        Method isEmptyM = tankStack.getClass().getMethod("isEmpty", new Class[0]);
                                                        Object r = isEmptyM.invoke((Object)tankStack, new Object[0]);
                                                        if (r instanceof Boolean) {
                                                            isTankEmpty = (Boolean)r;
                                                        }
                                                    }
                                                    catch (Throwable isEmptyM) {
                                                        // empty catch block
                                                    }
                                                    if (isTankEmpty || !exporterAllows.test(tankStack)) continue;
                                                    boolean importerAllEmpty = true;
                                                    for (Object f4 : importerFilters) {
                                                        if (isEmptyFilter.test(f4)) continue;
                                                        importerAllEmpty = false;
                                                        break;
                                                    }
                                                    if (!importerAllEmpty) {
                                                        Object f4;
                                                        boolean anyMatch = false;
                                                        f4 = importerFilters.iterator();
                                                        while (f4.hasNext()) {
                                                            Object f5 = f4.next();
                                                            if (isEmptyFilter.test(f5) || !matchesFilter.test(f5, tankStack)) continue;
                                                            anyMatch = true;
                                                            break;
                                                        }
                                                        if (!anyMatch) continue;
                                                    }
                                                    try {
                                                        Method copyM = tankStack.getClass().getMethod("copy", new Class[0]);
                                                        toExtract = copyM.invoke((Object)tankStack, new Object[0]);
                                                        try {
                                                            Method setAmount = toExtract.getClass().getMethod("setAmount", Long.TYPE);
                                                            long amount = Math.min((Long)toExtract.getClass().getMethod("getAmount", new Class[0]).invoke((Object)tankStack, new Object[0]), (long)maxTransfer3);
                                                            setAmount.invoke(toExtract, amount);
                                                        }
                                                        catch (NoSuchMethodException setAmount) {}
                                                    }
                                                    catch (Throwable t) {
                                                        continue;
                                                    }
                                                    try {
                                                        Method insertSim = importerChem.getClass().getMethod("insertChemical", toExtract.getClass(), Action.class);
                                                        Object remainder = insertSim.invoke((Object)importerChem, toExtract, Action.SIMULATE);
                                                        long beforeAmount = (Long)toExtract.getClass().getMethod("getAmount", new Class[0]).invoke(toExtract, new Object[0]);
                                                        long remainderAmount = (Long)remainder.getClass().getMethod("getAmount", new Class[0]).invoke(remainder, new Object[0]);
                                                        long inserted = beforeAmount - remainderAmount;
                                                        if (inserted <= 0L) continue;
                                                        Method extractExec = targetChemicalHandler.getClass().getMethod("extractChemical", Long.TYPE, Action.class);
                                                        Object extracted = extractExec.invoke((Object)targetChemicalHandler, inserted, Action.EXECUTE);
                                                        Method insertExec = importerChem.getClass().getMethod("insertChemical", extracted.getClass(), Action.class);
                                                        insertExec.invoke((Object)importerChem, extracted, Action.EXECUTE);
                                                        return;
                                                    }
                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (targetSourceHandler == null || !this.hasUpgrade(RoutersTags.Items.SOURCE_UPGRADES)) break block73;
                                    maxTransfer2 = this.getExtractAmount(RoutersTags.Items.SOURCE_UPGRADES);
                                    if (!this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) break block74;
                                    if (this.importerPositions.isEmpty()) break block73;
                                    int index = this.lastRoundRobinIndex % this.importerPositions.size();
                                    BlockPos importerPos6 = this.importerPositions.get(index);
                                    be = this.findImporter(importerPos6);
                                    if (be instanceof ImporterBlockEntity && (importerSource = (importer2 = be).getSourceHandler()) != null && (transferAmount = Math.min(canExtract = targetSourceHandler.extractSource(maxTransfer2, true), canReceive = importerSource.receiveSource(canExtract, true))) > 0) {
                                        targetSourceHandler.extractSource(transferAmount, false);
                                        importerSource.receiveSource(transferAmount, false);
                                        this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                        return;
                                    }
                                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                    break block73;
                                }
                                for (BlockPos importerPos : this.importerPositions) {
                                    int canReceive;
                                    int canExtract;
                                    int transferAmount4;
                                    ISourceCap importerSource;
                                    importer = this.findImporter(importerPos);
                                    if (importer == null || (importerSource = importer.getSourceHandler()) == null || (transferAmount4 = Math.min(canExtract = targetSourceHandler.extractSource(maxTransfer2, true), canReceive = importerSource.receiveSource(canExtract, true))) <= 0) continue;
                                    targetSourceHandler.extractSource(transferAmount4, false);
                                    importerSource.receiveSource(transferAmount4, false);
                                    if ((maxTransfer2 -= transferAmount4) > 0) continue;
                                    break;
                                }
                            }
                            if (targetSoulHandler == null || !this.hasUpgrade(RoutersTags.Items.SOUL_UPGRADES)) break block75;
                            maxTransfer2 = this.getExtractAmount(RoutersTags.Items.SOUL_UPGRADES);
                            if (!this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) break block76;
                            if (this.importerPositions.isEmpty()) break block75;
                            int index = this.lastRoundRobinIndex % this.importerPositions.size();
                            BlockPos importerPos = this.importerPositions.get(index);
                            be = this.findImporter(importerPos);
                            if (be instanceof ImporterBlockEntity) {
                                int available2;
                                int canExtract4;
                                int transferAmount;
                                SoulNetwork soulNet;
                                SoulNetwork importerSoulNetwork;
                                ImporterBlockEntity importer8 = be;
                                SoulNetwork transferAmount4 = importer8.getSoulNetwork();
                                SoulNetwork soulNetwork = importerSoulNetwork = transferAmount4 instanceof SoulNetwork ? (soulNet = transferAmount4) : null;
                                if (importerSoulNetwork != null && (transferAmount = Math.min(canExtract4 = targetSoulHandler.drain(maxTransfer2, ISoulHandler.Action.SIMULATE), available2 = importerSoulNetwork.getMaxSouls() - importerSoulNetwork.getSoulAmount())) > 0) {
                                    int drained = targetSoulHandler.drain(transferAmount, ISoulHandler.Action.EXECUTE);
                                    importerSoulNetwork.addSouls(this.level, drained);
                                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                                    return;
                                }
                            }
                            this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                            break block75;
                        }
                        for (BlockPos importerPos : this.importerPositions) {
                            int available3;
                            int canExtract;
                            int transferAmount;
                            SoulNetwork soulNet;
                            SoulNetwork canExtract4;
                            SoulNetwork importerSoulNetwork;
                            importer = this.findImporter(importerPos);
                            if (importer == null || (importerSoulNetwork = (canExtract4 = importer.getSoulNetwork()) instanceof SoulNetwork ? (soulNet = canExtract4) : null) == null || (transferAmount = Math.min(canExtract = targetSoulHandler.drain(maxTransfer2, ISoulHandler.Action.SIMULATE), available3 = importerSoulNetwork.getMaxSouls() - importerSoulNetwork.getSoulAmount())) <= 0) continue;
                            int drained = targetSoulHandler.drain(transferAmount, ISoulHandler.Action.EXECUTE);
                            importerSoulNetwork.addSouls(this.level, drained);
                            if ((maxTransfer2 -= drained) > 0) continue;
                            break;
                        }
                    }
                    if (this.importerPositions.isEmpty() || !this.hasUpgrade(RoutersTags.Items.PRESSURE_UPGRADES) || !targetAirHandler.isPresent()) break block77;
                    source = (IAirHandlerMachine)targetAirHandler.get();
                    if (source == null) {
                        return;
                    }
                    available = source.getAir();
                    if (available <= 0.0f) {
                        return;
                    }
                    maxTransfer = this.getExtractAmount(RoutersTags.Items.PRESSURE_UPGRADES);
                    if (!this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) break block78;
                    if (this.importerPositions.isEmpty()) break block77;
                    int index = this.lastRoundRobinIndex % this.importerPositions.size();
                    for (int attempts = 0; attempts < this.importerPositions.size(); ++attempts) {
                        int transfer;
                        ImporterBlockEntity importer;
                        IAirHandlerMachine importerSource;
                        BlockPos importerPos = this.importerPositions.get(index);
                        ImporterBlockEntity be = this.findImporter(importerPos);
                        if (be instanceof ImporterBlockEntity && (importerSource = (importer = be).getPressureHandler()) != null && (transfer = (int)Math.min((double)maxTransfer, Math.floor(available))) > 0) {
                            source.addAir(-transfer);
                            importerSource.addAir(transfer);
                            importerSource.setConnectableFaces(Collections.singleton(((Direction)importer.getBlockState().getValue((Property)ImporterBlock.FACING)).getOpposite()));
                            this.lastRoundRobinIndex = (index + 1) % this.importerPositions.size();
                            return;
                        }
                        index = (index + 1) % this.importerPositions.size();
                    }
                    this.lastRoundRobinIndex = index;
                    break block77;
                }
                for (BlockPos importerPos : this.importerPositions) {
                    int transfer;
                    IAirHandlerMachine importerSource;
                    ImporterBlockEntity importer = this.findImporter(importerPos);
                    if (importer == null || (importerSource = importer.getPressureHandler()) == null || (transfer = (int)Math.min((double)maxTransfer, Math.floor(available))) <= 0) continue;
                    source.addAir(-transfer);
                    importerSource.addAir(transfer);
                    importerSource.setConnectableFaces(Collections.singleton(((Direction)importer.getBlockState().getValue((Property)ImporterBlock.FACING)).getOpposite()));
                    break;
                }
            }
            if (this.importerPositions.isEmpty() || !this.hasUpgrade(RoutersTags.Items.HEAT_UPGRADES_PC) || !targetHeatHandler.isPresent()) break block72;
            IHeatExchangerLogic sourceHeatHandler = (IHeatExchangerLogic)targetHeatHandler.get();
            double maxHeatTransfer = this.getExtractAmount(RoutersTags.Items.HEAT_UPGRADES_PC);
            if (this.hasUpgrade(RoutersTags.Items.ROUND_ROBIN_UPGRADES)) {
                int startIndex = this.lastRoundRobinIndex % this.importerPositions.size();
                for (int i = 0; i < this.importerPositions.size() && maxHeatTransfer > 0.0; ++i) {
                    double targetTemp;
                    double sourceTemp;
                    double heatDifference;
                    IHeatExchangerLogic importerHeatHandler;
                    int index = (startIndex + i) % this.importerPositions.size();
                    BlockPos importerPos = this.importerPositions.get(index);
                    ImporterBlockEntity importer = this.findImporter(importerPos);
                    if (importer == null || (importerHeatHandler = (IHeatExchangerLogic)PNCCapabilities.getHeatLogic((BlockEntity)importer, null).orElse(null)) == null || (heatDifference = (sourceTemp = sourceHeatHandler.getTemperature()) - (targetTemp = importerHeatHandler.getTemperature())) <= 0.0) continue;
                    double transferAmount = Math.min(maxHeatTransfer, heatDifference);
                    sourceHeatHandler.addHeat(-transferAmount);
                    importerHeatHandler.addHeat(transferAmount);
                    maxHeatTransfer -= transferAmount;
                    this.lastRoundRobinIndex = (this.lastRoundRobinIndex + 1) % this.importerPositions.size();
                    break;
                }
            } else {
                for (BlockPos importerPos : this.importerPositions) {
                    if (!(maxHeatTransfer <= 0.0)) {
                        double targetTemp;
                        double sourceTemp;
                        double heatDifference;
                        IHeatExchangerLogic importerHeatHandler;
                        ImporterBlockEntity importer = this.findImporter(importerPos);
                        if (importer == null || (importerHeatHandler = (IHeatExchangerLogic)PNCCapabilities.getHeatLogic((BlockEntity)importer, null).orElse(null)) == null || (heatDifference = (sourceTemp = sourceHeatHandler.getTemperature()) - (targetTemp = importerHeatHandler.getTemperature())) <= 0.0) continue;
                        double transferAmount = Math.min(maxHeatTransfer, heatDifference);
                        sourceHeatHandler.addHeat(-transferAmount);
                        importerHeatHandler.addHeat(transferAmount);
                        maxHeatTransfer -= transferAmount;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private boolean matchesChemicalFilter(Object filter, ChemicalStack chemical) {
        if (filter == null || chemical == null) {
            return false;
        }
        if (!ModList.get().isLoaded("mekanism")) {
            return false;
        }
        NonNullList<?> chemicalFilters = this.getChemicalFilters();
        return filter.equals(chemical);
    }

    @Nullable
    private ImporterBlockEntity findImporter(BlockPos pos) {
        ImporterBlockEntity cached = this.importerCache.get(pos);
        if (cached != null && !cached.isRemoved()) {
            return cached;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        boolean allowCrossDim = this.hasUpgrade(RoutersTags.Items.DIMENSIONAL_UPGRADES);
        if (allowCrossDim) {
            for (ServerLevel candidate : server.getAllLevels()) {
                String candidateDim;
                ImporterBlockEntity importer;
                String importerDim;
                BlockEntity be = candidate.getBlockEntity(pos);
                if (!(be instanceof ImporterBlockEntity) || !(importerDim = (importer = (ImporterBlockEntity)be).getDimension()).equals(candidateDim = candidate.dimension().location().toString())) continue;
                this.importerCache.put(pos, importer);
                return importer;
            }
        } else {
            String expectedDim;
            ImporterBlockEntity importer;
            String importerDim;
            BlockEntity be = serverLevel.getBlockEntity(pos);
            if (be instanceof ImporterBlockEntity && (importerDim = (importer = (ImporterBlockEntity)be).getDimension()).equals(expectedDim = serverLevel.dimension().location().toString())) {
                this.importerCache.put(pos, importer);
                return importer;
            }
        }
        return null;
    }

    private List<Item> expandFilters(NonNullList<ItemStack> filters) {
        ArrayList<Item> expanded = new ArrayList<Item>();
        for (ItemStack filter : filters) {
            if (filter.isEmpty()) continue;
            if (filter.is(RoutersItems.TAG_FILTER)) {
                ResourceLocation tagId;
                DataComponentType component = (DataComponentType)RoutersDataComponents.TAG_FILTER.get();
                if (component == null || (tagId = (ResourceLocation)filter.get(component)) == null || this.level == null) continue;
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId);
                this.level.registryAccess().registryOrThrow(Registries.ITEM).getTag(tagKey).ifPresent(tagSet -> tagSet.forEach(holder -> expanded.add((Item)holder.value())));
                continue;
            }
            if (filter.is(RoutersItems.MOD_FILTER)) {
                String modId = (String)filter.get((DataComponentType)RoutersDataComponents.MOD_FILTER.get());
                if (modId == null || modId.isEmpty()) continue;
                assert (this.level != null);
                this.level.registryAccess().registryOrThrow(Registries.ITEM).forEach(item -> {
                    ResourceLocation id = this.level.registryAccess().registryOrThrow(Registries.ITEM).getKey(item);
                    if (id != null && id.getNamespace().equals(modId)) {
                        expanded.add((Item)item);
                    }
                });
                continue;
            }
            expanded.add(filter.getItem());
        }
        return expanded;
    }

    public int getSpeedPerOperation() {
        if (this.hasUpgrade(RoutersTags.Items.SPEED_UPGRADES)) {
            int speed = 0;
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                Item item;
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty() || !stack.is(RoutersTags.Items.SPEED_UPGRADES) || !((item = stack.getItem()) instanceof UpgradeItem)) continue;
                UpgradeItem upgradeItem = (UpgradeItem)item;
                speed += upgradeItem.getExtractAmount();
                break;
            }
            return speed;
        }
        return (Integer)StartupConfig.defaultSpeedPerOperation.get();
    }

    public boolean hasUpgrade(TagKey<Item> tag) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty() || !stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public int getExtractAmount(TagKey<Item> tag) {
        int total = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            Item item;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty() || !stack.is(tag) || !((item = stack.getItem()) instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            total += upgradeItem.getExtractAmount();
        }
        return total;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveWithoutMetadata(p_323910_);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.saveAllFluids(compoundTag, this.fluidFilters, true, provider);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.saveChemicalFilters(compoundTag, this.chemicalFilters, provider);
        }
        if (this.importerPositions != null && !this.importerPositions.isEmpty()) {
            ListTag listTag = new ListTag();
            for (BlockPos pos : this.importerPositions) {
                CompoundTag posTag = new CompoundTag();
                posTag.putInt("x", pos.getX());
                posTag.putInt("y", pos.getY());
                posTag.putInt("z", pos.getZ());
                listTag.add((Object)posTag);
            }
            compoundTag.put("ImporterPositions", (Tag)listTag);
        }
        compoundTag.putString("dimension", this.dimension);
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.loadAllFluids(compoundTag, this.fluidFilters, provider);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.loadChemicalFilters(compoundTag, this.chemicalFilters, provider);
        }
        this.importerPositions = new ArrayList<BlockPos>();
        if (compoundTag.contains("ImporterPositions")) {
            ListTag listTag = compoundTag.getList("ImporterPositions", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag posTag = listTag.getCompound(i);
                BlockPos pos = new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z"));
                this.importerPositions.add(pos);
            }
        }
        this.dimension = compoundTag.getString("dimension");
    }

    public List<BlockPos> getImporterPositions() {
        return this.importerPositions;
    }

    public void removeInvalidImporters() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        boolean allowCrossDim = this.hasUpgrade(RoutersTags.Items.DIMENSIONAL_UPGRADES);
        this.importerPositions.removeIf(pos -> {
            ImporterBlockEntity importer;
            if (allowCrossDim) {
                for (ServerLevel candidate : server.getAllLevels()) {
                    ImporterBlockEntity importer2;
                    BlockEntity patt0$temp = candidate.getBlockEntity(pos);
                    if (!(patt0$temp instanceof ImporterBlockEntity) || !(importer2 = (ImporterBlockEntity)patt0$temp).getDimension().equals(candidate.dimension().location().toString())) continue;
                    return false;
                }
                return true;
            }
            BlockEntity patt0$temp = serverLevel.getBlockEntity(pos);
            return !(patt0$temp instanceof ImporterBlockEntity) || !(importer = (ImporterBlockEntity)patt0$temp).getDimension().equals(serverLevel.dimension().location().toString());
        });
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }
}

