/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.screen.custom;

import com.benbenlaw.core.screen.util.TooltipArea;
import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.strainers.screen.custom.WoodenStrainerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodenStrainerScreen
extends AbstractContainerScreen<WoodenStrainerMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"textures/gui/wooden_strainer_gui.png");

    public WoodenStrainerScreen(WoodenStrainerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = pMenu.level;
        this.imageHeight = this.imageWidth + 39;
        this.inventoryLabelY += 39;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((WoodenStrainerMenu)this.menu).isCrafting()) {
            int l = ((WoodenStrainerMenu)this.menu).getScaledProgress();
            guiGraphics.blit(TEXTURE, x + 31, y + 25, 176, 0, ((WoodenStrainerMenu)this.menu).getScaledProgress() + 1, 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderSlotTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        ArrayList<TooltipArea> tooltipAreas = new ArrayList<TooltipArea>();
        tooltipAreas.add(new TooltipArea(8, 17, 16, 16, "block.strainers.gui.input_slot"));
        tooltipAreas.add(new TooltipArea(8, 35, 16, 16, "block.strainers.gui.mesh_slot"));
        tooltipAreas.add(new TooltipArea(8, 53, 16, 16, "block.strainers.gui.upgrade_slot"));
        tooltipAreas.add(new TooltipArea(8, 71, 16, 16, "block.strainers.gui.upgrade_slot"));
        tooltipAreas.add(new TooltipArea(8, 89, 16, 16, "block.strainers.gui.upgrade_slot"));
        for (TooltipArea area : tooltipAreas) {
            if (!MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)area.offsetX, (int)area.offsetY, (int)area.width, (int)area.height) || !((WoodenStrainerMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.hasItem()) continue;
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)area.translationKey), mouseX, mouseY);
        }
    }
}

